# Directory containing class headers.
SET(VTK_COMMON_HEADER_DIR "${VTK_INSTALL_PREFIX}/include/vtk-5.2")

# Classes in vtkCommon.
SET(VTK_COMMON_CLASSES
  "vtkAbstractArray"
  "vtkAbstractTransform"
  "vtkAmoebaMinimizer"
  "vtkAnimationCue"
  "vtkAnimationScene"
  "vtkArrayIterator"
  "vtkAssemblyNode"
  "vtkAssemblyPath"
  "vtkAssemblyPaths"
  "vtkBitArray"
  "vtkBitArrayIterator"
  "vtkBoundingBox"
  "vtkBox"
  "vtkByteSwap"
  "vtkCallbackCommand"
  "vtkCharArray"
  "vtkClientSocket"
  "vtkCollection"
  "vtkCollectionIterator"
  "vtkCommand"
  "vtkCommonInformationKeyManager"
  "vtkContourValues"
  "vtkCriticalSection"
  "vtkCylindricalTransform"
  "vtkDataArray"
  "vtkDataArrayCollection"
  "vtkDataArrayCollectionIterator"
  "vtkDataArraySelection"
  "vtkDebugLeaks"
  "vtkDebugLeaksManager"
  "vtkDirectory"
  "vtkDoubleArray"
  "vtkDynamicLoader"
  "vtkEdgeTable"
  "vtkErrorCode"
  "vtkEventForwarderCommand"
  "vtkExtentSplitter"
  "vtkExtentTranslator"
  "vtkFastNumericConversion"
  "vtkFileOutputWindow"
  "vtkFloatArray"
  "vtkFloatingPointExceptions"
  "vtkFunctionParser"
  "vtkFunctionSet"
  "vtkGarbageCollector"
  "vtkGarbageCollectorManager"
  "vtkGeneralTransform"
  "vtkHeap"
  "vtkHomogeneousTransform"
  "vtkIOStream"
  "vtkIdList"
  "vtkIdListCollection"
  "vtkIdTypeArray"
  "vtkIdentityTransform"
  "vtkImplicitFunction"
  "vtkImplicitFunctionCollection"
  "vtkIndent"
  "vtkInformation"
  "vtkInformationDataObjectKey"
  "vtkInformationDoubleKey"
  "vtkInformationDoubleVectorKey"
  "vtkInformationIdTypeKey"
  "vtkInformationInformationKey"
  "vtkInformationInformationVectorKey"
  "vtkInformationIntegerKey"
  "vtkInformationIntegerPointerKey"
  "vtkInformationIntegerVectorKey"
  "vtkInformationIterator"
  "vtkInformationKey"
  "vtkInformationKeyVectorKey"
  "vtkInformationObjectBaseKey"
  "vtkInformationRequestKey"
  "vtkInformationStringKey"
  "vtkInformationStringVectorKey"
  "vtkInformationUnsignedLongKey"
  "vtkInformationVector"
  "vtkInitialValueProblemSolver"
  "vtkInstantiator"
  "vtkIntArray"
  "vtkLargeInteger"
  "vtkLinearTransform"
  "vtkLogLookupTable"
  "vtkLongArray"
  "vtkLookupTable"
  "vtkMath"
  "vtkMatrix4x4"
  "vtkMatrixToHomogeneousTransform"
  "vtkMatrixToLinearTransform"
  "vtkMultiThreader"
  "vtkMutexLock"
  "vtkOStrStreamWrapper"
  "vtkOStreamWrapper"
  "vtkObject"
  "vtkObjectBase"
  "vtkObjectFactory"
  "vtkObjectFactoryCollection"
  "vtkOldStyleCallbackCommand"
  "vtkOnePieceExtentTranslator"
  "vtkOutputWindow"
  "vtkOverrideInformation"
  "vtkOverrideInformationCollection"
  "vtkParametricBoy"
  "vtkParametricConicSpiral"
  "vtkParametricCrossCap"
  "vtkParametricDini"
  "vtkParametricEllipsoid"
  "vtkParametricEnneper"
  "vtkParametricFigure8Klein"
  "vtkParametricFunction"
  "vtkParametricKlein"
  "vtkParametricMobius"
  "vtkParametricRandomHills"
  "vtkParametricRoman"
  "vtkParametricSuperEllipsoid"
  "vtkParametricSuperToroid"
  "vtkParametricTorus"
  "vtkPerspectiveTransform"
  "vtkPlane"
  "vtkPlaneCollection"
  "vtkPlanes"
  "vtkPoints"
  "vtkPolynomialSolversUnivariate"
  "vtkPriorityQueue"
  "vtkProp"
  "vtkPropCollection"
  "vtkProperty2D"
  "vtkQuadric"
  "vtkReferenceCount"
  "vtkRungeKutta2"
  "vtkRungeKutta4"
  "vtkRungeKutta45"
  "vtkScalarsToColors"
  "vtkServerSocket"
  "vtkShortArray"
  "vtkSignedCharArray"
  "vtkSmartPointerBase"
  "vtkSocket"
  "vtkSocketCollection"
  "vtkSortDataArray"
  "vtkSphericalTransform"
  "vtkStdString"
  "vtkStringArray"
  "vtkStructuredData"
  "vtkStructuredVisibilityConstraint"
  "vtkTableExtentTranslator"
  "vtkTensor"
  "vtkThreadMessager"
  "vtkTimeStamp"
  "vtkTimerLog"
  "vtkTransform"
  "vtkTransformCollection"
  "vtkUnsignedCharArray"
  "vtkUnsignedIntArray"
  "vtkUnsignedLongArray"
  "vtkUnsignedShortArray"
  "vtkVariant"
  "vtkVariantArray"
  "vtkVersion"
  "vtkVoidArray"
  "vtkWarpTransform"
  "vtkWeakPointerBase"
  "vtkWindow"
  "vtkWindowLevelLookupTable"
  "vtkXMLFileOutputWindow"
  "vtkLongLongArray"
  "vtkUnsignedLongLongArray"
  "vtkTypeInt8Array"
  "vtkTypeInt16Array"
  "vtkTypeInt32Array"
  "vtkTypeInt64Array"
  "vtkTypeUInt8Array"
  "vtkTypeUInt16Array"
  "vtkTypeUInt32Array"
  "vtkTypeUInt64Array"
  "vtkTypeFloat32Array"
  "vtkTypeFloat64Array")

# Abstract classes in vtkCommon.
SET(VTK_COMMON_CLASSES_ABSTRACT
  "vtkAbstractArray"
  "vtkAbstractTransform"
  "vtkArrayIterator"
  "vtkCallbackCommand"
  "vtkCommand"
  "vtkCommonInformationKeyManager"
  "vtkDataArray"
  "vtkEventForwarderCommand"
  "vtkFloatingPointExceptions"
  "vtkFunctionSet"
  "vtkHomogeneousTransform"
  "vtkImplicitFunction"
  "vtkInformationDataObjectKey"
  "vtkInformationDoubleKey"
  "vtkInformationDoubleVectorKey"
  "vtkInformationIdTypeKey"
  "vtkInformationInformationKey"
  "vtkInformationInformationVectorKey"
  "vtkInformationIntegerKey"
  "vtkInformationIntegerPointerKey"
  "vtkInformationIntegerVectorKey"
  "vtkInformationKey"
  "vtkInformationKeyVectorKey"
  "vtkInformationObjectBaseKey"
  "vtkInformationRequestKey"
  "vtkInformationStringKey"
  "vtkInformationStringVectorKey"
  "vtkInformationUnsignedLongKey"
  "vtkInitialValueProblemSolver"
  "vtkLinearTransform"
  "vtkObjectBase"
  "vtkObjectFactory"
  "vtkOldStyleCallbackCommand"
  "vtkOverrideInformation"
  "vtkOverrideInformationCollection"
  "vtkParametricFunction"
  "vtkProp"
  "vtkScalarsToColors"
  "vtkSocket"
  "vtkStructuredData"
  "vtkWarpTransform"
  "vtkWindow")

# Wrap-exclude classes in vtkCommon.
SET(VTK_COMMON_CLASSES_WRAP_EXCLUDE
  "vtkBoundingBox"
  "vtkCallbackCommand"
  "vtkCommand"
  "vtkCommonInformationKeyManager"
  "vtkDebugLeaksManager"
  "vtkErrorCode"
  "vtkEventForwarderCommand"
  "vtkFloatingPointExceptions"
  "vtkGarbageCollectorManager"
  "vtkIOStream"
  "vtkIndent"
  "vtkLargeInteger"
  "vtkOStrStreamWrapper"
  "vtkOStreamWrapper"
  "vtkOldStyleCallbackCommand"
  "vtkSmartPointerBase"
  "vtkStdString"
  "vtkTimeStamp"
  "vtkVariant"
  "vtkWeakPointerBase")

# Set convenient variables to test each class.
FOREACH(class ${VTK_COMMON_CLASSES})
  SET(VTK_CLASS_EXISTS_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_COMMON_CLASSES_ABSTRACT})
  SET(VTK_CLASS_ABSTRACT_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_COMMON_CLASSES_WRAP_EXCLUDE})
  SET(VTK_CLASS_WRAP_EXCLUDE_${class} 1)
ENDFOREACH(class)
