/*=========================================================================

  Module:    $RCSfile: vtkKWWidgetSetSubclass.h.in,v $

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkKWSpinBoxSet - a concrete set of vtkKWSpinBox
// .SECTION Description
// A composite widget to conveniently store, allocate, create and pack a 
// set of vtkKWSpinBox. 
// Each vtkKWSpinBox is created, removed or queried based
// on a unique ID provided by the user (ids are *not* handled by the class
// since it is likely that they will be defined as enum's or #define by
// the user for easier retrieval).
// As a subclass of vtkKWWidgetSet, it inherits methods to set the widgets
// visibility individually, set the layout parameters, and query each widget.
// Widgets are packed (gridded) in the order they were added.
// @ingroup kwwidgets_autogenerated_widget_set_group
// .SECTION Note
// This class and the corresponding code were 
// \subpage kwwidgets_autogenerated_page "generated automatically" by
// instantiating the <tt>Templates/vtkKWWidgetSetSubclass.h.in</tt>
// and <tt>Templates/vtkKWWidgetSetSubclass.cxx.in</tt> files for 
// the type vtkKWSpinBox. Classes related to the same template can be found
// in the \ref kwwidgets_autogenerated_widget_set_group section.
// .SECTION See Also
// vtkKWWidgetSet vtkKWSpinBox

#ifndef __vtkKWSpinBoxSet_h
#define __vtkKWSpinBoxSet_h

#include "vtkKWWidgetSet.h"

class vtkKWSpinBox;

class KWWidgets_EXPORT vtkKWSpinBoxSet : public vtkKWWidgetSet
{
public:
  static vtkKWSpinBoxSet* New();
  vtkTypeRevisionMacro(vtkKWSpinBoxSet,vtkKWWidgetSet);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Add a vtkKWSpinBox to the end of the set.
  // The id has to be unique among the set.
  // Return a pointer to the vtkKWSpinBox, or NULL on error.
  virtual vtkKWSpinBox* AddWidget(int id);

  // Description:
  // Insert a vtkKWSpinBox at a specific position in the set.
  // The id has to be unique among the set.
  // Return a pointer to the vtkKWSpinBox, or NULL on error.
  virtual vtkKWSpinBox* InsertWidget(int id, int pos);

  // Description:
  // Get a vtkKWSpinBox from the set, given its unique id.
  // Return a pointer to the vtkKWSpinBox, or NULL on error.
  virtual vtkKWSpinBox* GetWidget(int id);

protected:
  vtkKWSpinBoxSet() {};
  ~vtkKWSpinBoxSet() {};

  // Helper methods

  virtual vtkKWWidget* AllocateAndCreateWidget();

private:
  vtkKWSpinBoxSet(const vtkKWSpinBoxSet&); // Not implemented
  void operator=(const vtkKWSpinBoxSet&); // Not implemented
};

#endif
