/*=========================================================================

  Module:    $RCSfile: vtkKWWidgetSetSubclass.h.in,v $

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkKWPiecewiseFunctionEditorSet - a concrete set of vtkKWPiecewiseFunctionEditor
// .SECTION Description
// A composite widget to conveniently store, allocate, create and pack a 
// set of vtkKWPiecewiseFunctionEditor. 
// Each vtkKWPiecewiseFunctionEditor is created, removed or queried based
// on a unique ID provided by the user (ids are *not* handled by the class
// since it is likely that they will be defined as enum's or #define by
// the user for easier retrieval).
// As a subclass of vtkKWWidgetSet, it inherits methods to set the widgets
// visibility individually, set the layout parameters, and query each widget.
// Widgets are packed (gridded) in the order they were added.
// @ingroup kwwidgets_autogenerated_widget_set_group
// .SECTION Note
// This class and the corresponding code were 
// \subpage kwwidgets_autogenerated_page "generated automatically" by
// instantiating the <tt>Templates/vtkKWWidgetSetSubclass.h.in</tt>
// and <tt>Templates/vtkKWWidgetSetSubclass.cxx.in</tt> files for 
// the type vtkKWPiecewiseFunctionEditor. Classes related to the same template can be found
// in the \ref kwwidgets_autogenerated_widget_set_group section.
// .SECTION See Also
// vtkKWWidgetSet vtkKWPiecewiseFunctionEditor

#ifndef __vtkKWPiecewiseFunctionEditorSet_h
#define __vtkKWPiecewiseFunctionEditorSet_h

#include "vtkKWWidgetSet.h"

class vtkKWPiecewiseFunctionEditor;

class KWWidgets_EXPORT vtkKWPiecewiseFunctionEditorSet : public vtkKWWidgetSet
{
public:
  static vtkKWPiecewiseFunctionEditorSet* New();
  vtkTypeRevisionMacro(vtkKWPiecewiseFunctionEditorSet,vtkKWWidgetSet);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Add a vtkKWPiecewiseFunctionEditor to the end of the set.
  // The id has to be unique among the set.
  // Return a pointer to the vtkKWPiecewiseFunctionEditor, or NULL on error.
  virtual vtkKWPiecewiseFunctionEditor* AddWidget(int id);

  // Description:
  // Insert a vtkKWPiecewiseFunctionEditor at a specific position in the set.
  // The id has to be unique among the set.
  // Return a pointer to the vtkKWPiecewiseFunctionEditor, or NULL on error.
  virtual vtkKWPiecewiseFunctionEditor* InsertWidget(int id, int pos);

  // Description:
  // Get a vtkKWPiecewiseFunctionEditor from the set, given its unique id.
  // Return a pointer to the vtkKWPiecewiseFunctionEditor, or NULL on error.
  virtual vtkKWPiecewiseFunctionEditor* GetWidget(int id);

protected:
  vtkKWPiecewiseFunctionEditorSet() {};
  ~vtkKWPiecewiseFunctionEditorSet() {};

  // Helper methods

  virtual vtkKWWidget* AllocateAndCreateWidget();

private:
  vtkKWPiecewiseFunctionEditorSet(const vtkKWPiecewiseFunctionEditorSet&); // Not implemented
  void operator=(const vtkKWPiecewiseFunctionEditorSet&); // Not implemented
};

#endif
