/*=========================================================================

  Module:    $RCSfile: vtkKWWidgetWithSpinButtonsSubclass.h.in,v $

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkKWMenuButtonWithSpinButtons - a vtkKWMenuButton associated to a vtkKWSpinButtons
// .SECTION Description
// This class creates a composite widget associating a vtkKWMenuButton to a
// vtkKWSpinButtons.
// As a subclass of vtkKWWidgetWithSpinButtons, it inherits a set of
// spin buttons.
// The only requirement is for the vtkKWMenuButton class to implement the
// NextValue() and PreviousValue() callbacks.
// @ingroup kwwidgets_autogenerated_widget_with_spinbuttons_group
// .SECTION Note
// This class and the corresponding code were 
// \subpage kwwidgets_autogenerated_page "generated automatically" by
// instantiating the <tt>Templates/vtkKWWidgetWithSpinButtonsSubclass.h.in</tt>
// and <tt>Templates/vtkKWWidgetWithSpinButtonsSubclass.cxx.in</tt> files for 
// the type vtkKWMenuButton. Classes related to the same template can be found
// in the \ref kwwidgets_autogenerated_widget_with_spinbuttons_group.
// .SECTION See Also
// vtkKWWidgetWithSpinButtons vtkKWMenuButton

#ifndef __vtkKWMenuButtonWithSpinButtons_h
#define __vtkKWMenuButtonWithSpinButtons_h

#include "vtkKWWidgetWithSpinButtons.h"

class vtkKWMenuButton;

class KWWidgets_EXPORT vtkKWMenuButtonWithSpinButtons : public vtkKWWidgetWithSpinButtons
{
public:
  static vtkKWMenuButtonWithSpinButtons* New();
  vtkTypeRevisionMacro(vtkKWMenuButtonWithSpinButtons, vtkKWWidgetWithSpinButtons);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Get the vtkKWMenuButton that is being associated to the spin buttons
  virtual vtkKWMenuButton* GetWidget();
  
  // Description:
  // Set the string that enables balloon help for this widget.
  // Override to pass down to children.
  virtual void SetBalloonHelpString(const char *str);

  // Description:
  // Update the "enable" state of the object and its internal parts.
  // Depending on different Ivars (this->Enabled, the application's 
  // Limited Edition Mode, etc.), the "enable" state of the object is updated
  // and propagated to its internal parts/subwidgets. This will, for example,
  // enable/disable parts of the widget UI, enable/disable the visibility
  // of 3D widgets, etc.
  virtual void UpdateEnableState();

  // Description:
  // Callbacks
  virtual void NextValueCallback();
  virtual void PreviousValueCallback();

protected:
  vtkKWMenuButtonWithSpinButtons();
  ~vtkKWMenuButtonWithSpinButtons();

  // Description:
  // Create the widget
  virtual void CreateWidget();

  // Description:
  // Pack or repack the widget. To be implemented by subclasses.
  virtual void Pack();

  // Description:
  // Internal widget
  vtkKWMenuButton *Widget;

private:

  vtkKWMenuButtonWithSpinButtons(const vtkKWMenuButtonWithSpinButtons&); // Not implemented
  void operator=(const vtkKWMenuButtonWithSpinButtons&); // Not implemented
};

#endif
