function acor = fast_cvm2acor(cvm,biased) 
%
% acor = fast_cvm2acor(cvm) 
%
% Computes the autocorrelation function from the 
% covariance matrix


%
% fast_cvm2acor.m
%
% Original Author: Doug Greve
% CVS Revision Info:
%    $Author: nicks $
%    $Date: 2007/01/10 22:02:30 $
%    $Revision: 1.3 $
%
% Copyright (C) 2002-2007,
% The General Hospital Corporation (Boston, MA). 
% All rights reserved.
%
% Distribution, usage and copying of this software is covered under the
% terms found in the License Agreement file named 'COPYING' found in the
% FreeSurfer source code root directory, and duplicated here:
% https://surfer.nmr.mgh.harvard.edu/fswiki/FreeSurferOpenSourceLicense
%
% General inquiries: freesurfer@nmr.mgh.harvard.edu
% Bug reports: analysis-bugs@nmr.mgh.harvard.edu
%

acor = [];

if(nargin ~= 1 & nargin ~= 2)
  fprintf('USAGE: acor = fast_cvm2acor(cvm,<biased>)\n');
  return;
end

if(exist('biased') ~= 1) biased = []; end
if(isempty(biased)) biased = 0; end

ntrs = size(cvm,1);

acor = zeros(ntrs,1);
for n = 1:ntrs, 
  acor(n) = mean(diag(cvm,n-1));
end

acor = acor/acor(1);

if(biased)
  acor = acor.*([ntrs:-1:1]');
  acor = acor/max(acor);
end


return;
