function m = unwarp_scanners_table()

% 
% Edit this structure, then run it to build the table.
% 
% Ugh, this is tricky - because there's model names 'signa' and 'genesis
% signa', and there's station name bay1 and bay1ow0, etc.  So some
% {{'cell', 'arrays'}}...
% 
% Okay, 'genesis_signa' just appeared, 09-2003
% 
% And note many scanners don't set their ScannerSerialNo tag.  -ebeth
% 
% Ugh, sometimes they set DeviceSerialNumber, 09-2003
%
% S.Czanner, added table for Avanto, 01-2005


%
% unwarp_scanners_table.m
%
% Original Author: Elizabeth Haley
% CVS Revision Info:
%    $Author: nicks $
%    $Date: 2007/01/10 22:55:10 $
%    $Revision: 1.4 $
%
% Copyright (C) 2002-2007,
% The General Hospital Corporation (Boston, MA). 
% All rights reserved.
%
% Distribution, usage and copying of this software is covered under the
% terms found in the License Agreement file named 'COPYING' found in the
% FreeSurfer source code root directory, and duplicated here:
% https://surfer.nmr.mgh.harvard.edu/fswiki/FreeSurferOpenSourceLicense
%
% General inquiries: freesurfer@nmr.mgh.harvard.edu
% Bug reports: analysis-bugs@nmr.mgh.harvard.edu
%

global TABLE;
unwarp_init_globals(0); % 0 = called by script - probably not!

m(1) = struct(...
    'nickname','crm',...
    'Manufacturer','ge medical systems',...
    'ManufacturersModelName',{{'signa','genesis signa','genesis_signa'}},...
    'ScannerSerialNo',...
    {{...
	'0000000000345649',... % Duke
	'0000ONGWOOD15MR'...   % BWH
	'000000000001015'...   % MGH Bay1
	}},...
    'InstitutionStation',...
    {{...
	'duke univ med ctr mr6c'...       % Duke
	'anon mr6cow'...                  % Duke
	'imaging center bay1 bay1ow0',... % MGH Bay1
	'imaging center bay1 bay1',...    % MGH Bay1
	'cni ms scanner boston bwow1',... % BWH
	}},...
    'filename','crm.gwv');

m(2) = struct(...
    'nickname','brm',...
    'Manufacturer','ge medical systems',...
    'ManufacturersModelName',{{'signa','genesis signa'}},...
    'ScannerSerialNo',...
    {{...
	}},...
    'InstitutionStation',...
    {{...
	'vamcsd mrs1'                     % UCSD
        }},...
    'filename','brm.gwv');

m(3) = struct(...
    'nickname','sonata',...
    'Manufacturer','siemens',...
    'ManufacturersModelName',{{'sonata','trio'}},...
    'ScannerSerialNo',...
    {{...
	'21913'...                        % MGH-Bay 2
	}},...
    'InstitutionStation',...
    {{...
        }},...
    'filename','sonata.gwv');

m(4) = struct(...
    'nickname','trio',...
    'Manufacturer','siemens',...
    'ManufacturersModelName',{{'sonata','trio'}},...
    'ScannerSerialNo',...
    {{...
	}},...
    'InstitutionStation',...
    {{...
        }},...
    'filename','sonata.gwv');

m(5) = struct(...
    'nickname','allegra',...
    'Manufacturer','siemens',...
    'ManufacturersModelName',{{'allegra'}},...
    'ScannerSerialNo',...
    {{...
	}},...
    'InstitutionStation',...
    {{...
        }},...
    'filename','allegra.gwv');

m(6) = struct(...
    'nickname','avanto',...
    'Manufacturer','siemens',...
    'ManufacturersModelName',{{'avanto'}},...
    'ScannerSerialNo',...
    {{...
	}},...
    'InstitutionStation',...
    {{...
        }},...
    'filename','avanto.gwv');

save(TABLE,'m');
return


