# Directory containing class headers.
SET(VTK_FILTERING_HEADER_DIR "${VTK_INSTALL_PREFIX}/include/vtk-5.2")

# Classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES
  "vtkAbstractMapper"
  "vtkActor2DCollection"
  "vtkActor2D"
  "vtkAdjacentVertexIterator"
  "vtkAlgorithm"
  "vtkAlgorithmOutput"
  "vtkAttributesErrorMetric"
  "vtkBiQuadraticQuad"
  "vtkBiQuadraticQuadraticHexahedron"
  "vtkBiQuadraticQuadraticWedge"
  "vtkCachedStreamingDemandDrivenPipeline"
  "vtkCardinalSpline"
  "vtkCastToConcrete"
  "vtkCell3D"
  "vtkCellArray"
  "vtkCell"
  "vtkCellData"
  "vtkCellLinks"
  "vtkCellLocator"
  "vtkCellTypes"
  "vtkColorTransferFunction"
  "vtkCompositeDataIterator"
  "vtkCompositeDataPipeline"
  "vtkCompositeDataSetAlgorithm"
  "vtkCompositeDataSet"
  "vtkCone"
  "vtkConvexPointSet"
  "vtkCoordinate"
  "vtkCylinder"
  "vtkDataObjectAlgorithm"
  "vtkDataObjectCollection"
  "vtkDataObject"
  "vtkDataObjectSource"
  "vtkDataObjectTypes"
  "vtkDataSetAlgorithm"
  "vtkDataSetAttributes"
  "vtkDataSetCollection"
  "vtkDataSet"
  "vtkDataSetSource"
  "vtkDataSetToDataSetFilter"
  "vtkDataSetToImageFilter"
  "vtkDataSetToPolyDataFilter"
  "vtkDataSetToStructuredGridFilter"
  "vtkDataSetToStructuredPointsFilter"
  "vtkDataSetToUnstructuredGridFilter"
  "vtkDemandDrivenPipeline"
  "vtkDirectedAcyclicGraph"
  "vtkDirectedGraphAlgorithm"
  "vtkDirectedGraph"
  "vtkEdgeListIterator"
  "vtkEmptyCell"
  "vtkExecutive"
  "vtkExplicitCell"
  "vtkFieldData"
  "vtkFilteringInformationKeyManager"
  "vtkGenericAdaptorCell"
  "vtkGenericAttributeCollection"
  "vtkGenericAttribute"
  "vtkGenericCell"
  "vtkGenericCellIterator"
  "vtkGenericCellTessellator"
  "vtkGenericDataSetAlgorithm"
  "vtkGenericDataSet"
  "vtkGenericEdgeTable"
  "vtkGenericInterpolatedVelocityField"
  "vtkGenericPointIterator"
  "vtkGenericSubdivisionErrorMetric"
  "vtkGeometricErrorMetric"
  "vtkGraphAlgorithm"
  "vtkGraph"
  "vtkGraphEdge"
  "vtkHexagonalPrism"
  "vtkHexahedron"
  "vtkHierarchicalBoxDataIterator"
  "vtkHierarchicalBoxDataSetAlgorithm"
  "vtkHierarchicalBoxDataSet"
  "vtkHyperOctreeAlgorithm"
  "vtkHyperOctreeCursor"
  "vtkHyperOctree"
  "vtkHyperOctreePointsGrabber"
  "vtkImageAlgorithm"
  "vtkImageData"
  "vtkImageInPlaceFilter"
  "vtkImageIterator"
  "vtkImageMultipleInputFilter"
  "vtkImageMultipleInputOutputFilter"
  "vtkImageProgressIterator"
  "vtkImageSource"
  "vtkImageToImageFilter"
  "vtkImageToStructuredPoints"
  "vtkImageTwoInputFilter"
  "vtkImplicitBoolean"
  "vtkImplicitDataSet"
  "vtkImplicitSelectionLoop"
  "vtkImplicitSum"
  "vtkImplicitVolume"
  "vtkImplicitWindowFunction"
  "vtkInEdgeIterator"
  "vtkInformation"
  "vtkInformationExecutivePortKey"
  "vtkInformationExecutivePortVectorKey"
  "vtkInterpolatedVelocityField"
  "vtkKochanekSpline"
  "vtkLine"
  "vtkLocator"
  "vtkMapper2D"
  "vtkMergePoints"
  "vtkMultiBlockDataSetAlgorithm"
  "vtkMultiBlockDataSet"
  "vtkMultiPieceDataSet"
  "vtkMutableDirectedGraph"
  "vtkMutableUndirectedGraph"
  "vtkNonLinearCell"
  "vtkOrderedTriangulator"
  "vtkOutEdgeIterator"
  "vtkParametricSpline"
  "vtkPassInputTypeAlgorithm"
  "vtkPentagonalPrism"
  "vtkPerlinNoise"
  "vtkPiecewiseFunctionAlgorithm"
  "vtkPiecewiseFunction"
  "vtkPiecewiseFunctionShiftScale"
  "vtkPixel"
  "vtkPointData"
  "vtkPointLocator"
  "vtkPointSetAlgorithm"
  "vtkPointSet"
  "vtkPointSetSource"
  "vtkPointSetToPointSetFilter"
  "vtkPolyDataAlgorithm"
  "vtkPolyDataCollection"
  "vtkPolyData"
  "vtkPolyDataSource"
  "vtkPolyDataToPolyDataFilter"
  "vtkPolygon"
  "vtkPolyLine"
  "vtkPolyVertex"
  "vtkProcessObject"
  "vtkPropAssembly"
  "vtkPyramid"
  "vtkQuad"
  "vtkQuadraticEdge"
  "vtkQuadraticHexahedron"
  "vtkQuadraticLinearQuad"
  "vtkQuadraticLinearWedge"
  "vtkQuadraticPyramid"
  "vtkQuadraticQuad"
  "vtkQuadraticTetra"
  "vtkQuadraticTriangle"
  "vtkQuadraticWedge"
  "vtkRectilinearGridAlgorithm"
  "vtkRectilinearGrid"
  "vtkRectilinearGridSource"
  "vtkRectilinearGridToPolyDataFilter"
  "vtkScalarTree"
  "vtkSelectionAlgorithm"
  "vtkSelection"
  "vtkSimpleCellTessellator"
  "vtkSimpleImageToImageFilter"
  "vtkSimpleScalarTree"
  "vtkSmoothErrorMetric"
  "vtkSource"
  "vtkSphere"
  "vtkSpline"
  "vtkStreamingDemandDrivenPipeline"
  "vtkStructuredGridAlgorithm"
  "vtkStructuredGrid"
  "vtkStructuredGridSource"
  "vtkStructuredGridToPolyDataFilter"
  "vtkStructuredGridToStructuredGridFilter"
  "vtkStructuredPointsCollection"
  "vtkStructuredPoints"
  "vtkStructuredPointsSource"
  "vtkStructuredPointsToPolyDataFilter"
  "vtkStructuredPointsToStructuredPointsFilter"
  "vtkStructuredPointsToUnstructuredGridFilter"
  "vtkSuperquadric"
  "vtkTableAlgorithm"
  "vtkTable"
  "vtkTemporalDataSetAlgorithm"
  "vtkTemporalDataSet"
  "vtkTetra"
  "vtkThreadedImageAlgorithm"
  "vtkTreeAlgorithm"
  "vtkTree"
  "vtkTreeDFSIterator"
  "vtkTriangle"
  "vtkTriangleStrip"
  "vtkTriQuadraticHexahedron"
  "vtkTrivialProducer"
  "vtkUndirectedGraphAlgorithm"
  "vtkUndirectedGraph"
  "vtkUniformGrid"
  "vtkUnstructuredGridAlgorithm"
  "vtkUnstructuredGrid"
  "vtkUnstructuredGridSource"
  "vtkUnstructuredGridToPolyDataFilter"
  "vtkUnstructuredGridToUnstructuredGridFilter"
  "vtkVertex"
  "vtkVertexListIterator"
  "vtkViewDependentErrorMetric"
  "vtkViewport"
  "vtkVoxel"
  "vtkWedge")

# Abstract classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES_ABSTRACT
  "vtkAbstractMapper"
  "vtkCell3D"
  "vtkCell"
  "vtkCompositeDataIterator"
  "vtkCompositeDataSet"
  "vtkDataObjectSource"
  "vtkDataSet"
  "vtkDataSetSource"
  "vtkDataSetToDataSetFilter"
  "vtkDataSetToImageFilter"
  "vtkDataSetToPolyDataFilter"
  "vtkDataSetToStructuredGridFilter"
  "vtkDataSetToStructuredPointsFilter"
  "vtkDataSetToUnstructuredGridFilter"
  "vtkExecutive"
  "vtkExplicitCell"
  "vtkFilteringInformationKeyManager"
  "vtkGenericAdaptorCell"
  "vtkGenericAttribute"
  "vtkGenericCellIterator"
  "vtkGenericCellTessellator"
  "vtkGenericDataSetAlgorithm"
  "vtkGenericDataSet"
  "vtkGenericPointIterator"
  "vtkGenericSubdivisionErrorMetric"
  "vtkGraph"
  "vtkHyperOctreeAlgorithm"
  "vtkHyperOctreeCursor"
  "vtkHyperOctreePointsGrabber"
  "vtkImageAlgorithm"
  "vtkImageInPlaceFilter"
  "vtkImageIterator"
  "vtkImageMultipleInputFilter"
  "vtkImageMultipleInputOutputFilter"
  "vtkImageProgressIterator"
  "vtkImageSource"
  "vtkImageToImageFilter"
  "vtkImageTwoInputFilter"
  "vtkInformationExecutivePortKey"
  "vtkInformationExecutivePortVectorKey"
  "vtkLocator"
  "vtkMapper2D"
  "vtkNonLinearCell"
  "vtkPointSet"
  "vtkPointSetSource"
  "vtkPointSetToPointSetFilter"
  "vtkPolyDataSource"
  "vtkPolyDataToPolyDataFilter"
  "vtkProcessObject"
  "vtkRectilinearGridSource"
  "vtkRectilinearGridToPolyDataFilter"
  "vtkScalarTree"
  "vtkSimpleImageToImageFilter"
  "vtkSource"
  "vtkSpline"
  "vtkStructuredGridSource"
  "vtkStructuredGridToPolyDataFilter"
  "vtkStructuredGridToStructuredGridFilter"
  "vtkStructuredPointsSource"
  "vtkStructuredPointsToPolyDataFilter"
  "vtkStructuredPointsToStructuredPointsFilter"
  "vtkStructuredPointsToUnstructuredGridFilter"
  "vtkThreadedImageAlgorithm"
  "vtkUnstructuredGridSource"
  "vtkUnstructuredGridToPolyDataFilter"
  "vtkUnstructuredGridToUnstructuredGridFilter"
  "vtkViewport")

# Wrap-exclude classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES_WRAP_EXCLUDE
  "vtkFilteringInformationKeyManager"
  "vtkImageIterator"
  "vtkImageProgressIterator"
  "vtkInformation")

# Set convenient variables to test each class.
FOREACH(class ${VTK_FILTERING_CLASSES})
  SET(VTK_CLASS_EXISTS_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_FILTERING_CLASSES_ABSTRACT})
  SET(VTK_CLASS_ABSTRACT_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_FILTERING_CLASSES_WRAP_EXCLUDE})
  SET(VTK_CLASS_WRAP_EXCLUDE_${class} 1)
ENDFOREACH(class)
