/*=========================================================================

  Module:    $RCSfile: vtkKWWidgetSetSubclass.h.in,v $

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkKWLabelWithLabelSet - a concrete set of vtkKWLabelWithLabel
// .SECTION Description
// A composite widget to conveniently store, allocate, create and pack a 
// set of vtkKWLabelWithLabel. 
// Each vtkKWLabelWithLabel is created, removed or queried based
// on a unique ID provided by the user (ids are *not* handled by the class
// since it is likely that they will be defined as enum's or #define by
// the user for easier retrieval).
// As a subclass of vtkKWWidgetSet, it inherits methods to set the widgets
// visibility individually, set the layout parameters, and query each widget.
// Widgets are packed (gridded) in the order they were added.
// @ingroup kwwidgets_autogenerated_widget_set_group
// .SECTION Note
// This class and the corresponding code were 
// \subpage kwwidgets_autogenerated_page "generated automatically" by
// instantiating the <tt>Templates/vtkKWWidgetSetSubclass.h.in</tt>
// and <tt>Templates/vtkKWWidgetSetSubclass.cxx.in</tt> files for 
// the type vtkKWLabelWithLabel. Classes related to the same template can be found
// in the \ref kwwidgets_autogenerated_widget_set_group section.
// .SECTION See Also
// vtkKWWidgetSet vtkKWLabelWithLabel

#ifndef __vtkKWLabelWithLabelSet_h
#define __vtkKWLabelWithLabelSet_h

#include "vtkKWWidgetSet.h"

class vtkKWLabelWithLabel;

class KWWidgets_EXPORT vtkKWLabelWithLabelSet : public vtkKWWidgetSet
{
public:
  static vtkKWLabelWithLabelSet* New();
  vtkTypeRevisionMacro(vtkKWLabelWithLabelSet,vtkKWWidgetSet);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Add a vtkKWLabelWithLabel to the end of the set.
  // The id has to be unique among the set.
  // Return a pointer to the vtkKWLabelWithLabel, or NULL on error.
  virtual vtkKWLabelWithLabel* AddWidget(int id);

  // Description:
  // Insert a vtkKWLabelWithLabel at a specific position in the set.
  // The id has to be unique among the set.
  // Return a pointer to the vtkKWLabelWithLabel, or NULL on error.
  virtual vtkKWLabelWithLabel* InsertWidget(int id, int pos);

  // Description:
  // Get a vtkKWLabelWithLabel from the set, given its unique id.
  // Return a pointer to the vtkKWLabelWithLabel, or NULL on error.
  virtual vtkKWLabelWithLabel* GetWidget(int id);

protected:
  vtkKWLabelWithLabelSet() {};
  ~vtkKWLabelWithLabelSet() {};

  // Helper methods

  virtual vtkKWWidget* AllocateAndCreateWidget();

private:
  vtkKWLabelWithLabelSet(const vtkKWLabelWithLabelSet&); // Not implemented
  void operator=(const vtkKWLabelWithLabelSet&); // Not implemented
};

#endif
