/*=========================================================================

  Module:    $RCSfile: vtkKWWidgetWithScrollbarsSubclass.h.in,v $

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkKWListBoxWithScrollbars - a vtkKWListBox associated to two vtkKWScrollbar's
// .SECTION Description
// This composite widget provides horizontal and vertical scrolling
// capabilities to a core widget. They can be enabled or disabled separately.
// As a subclass of vtkKWWidgetWithScrollbars, it inherits methods to
// retrieve the scrollbars and set their visibility and layout.
// @ingroup kwwidgets_autogenerated_widget_with_scrollbars_group
// .SECTION Note
// This class and the corresponding code were 
// \subpage kwwidgets_autogenerated_page "generated automatically" by
// instantiating the <tt>Templates/vtkKWWidgetWithScrollbarsSubclass.h.in</tt>
// and <tt>Templates/vtkKWWidgetWithScrollbarsSubclass.cxx.in</tt> files for 
// the type vtkKWListBox. Classes related to the same template can be found
// in the \ref kwwidgets_autogenerated_widget_with_scrollbars_group section.
// .SECTION See Also
// vtkKWWidgetWithScrollbars vtkKWListBox

#ifndef __vtkKWListBoxWithScrollbars_h
#define __vtkKWListBoxWithScrollbars_h

#include "vtkKWWidgetWithScrollbars.h"

class vtkKWScrollbar;
class vtkKWListBox;

class KWWidgets_EXPORT vtkKWListBoxWithScrollbars : public vtkKWWidgetWithScrollbars
{
public:
  static vtkKWListBoxWithScrollbars* New();
  vtkTypeRevisionMacro(vtkKWListBoxWithScrollbars,vtkKWWidgetWithScrollbars);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Get the vtkKWListBox for which we addded the scrollbars
  virtual vtkKWListBox* GetWidget();
  
  // Description:
  // Update the "enable" state of the object and its internal parts.
  // Depending on different Ivars (this->Enabled, the application's 
  // Limited Edition Mode, etc.), the "enable" state of the object is updated
  // and propagated to its internal parts/subwidgets. This will, for example,
  // enable/disable parts of the widget UI, enable/disable the visibility
  // of 3D widgets, etc.
  virtual void UpdateEnableState();

protected:
  vtkKWListBoxWithScrollbars();
  ~vtkKWListBoxWithScrollbars();

  // Description:
  // Create the widget.
  virtual void CreateWidget();

  // Description:
  // Internal widget
  vtkKWListBox *Widget;

  // Description:
  // Create scrollbars and associate the scrollbars to a widget by
  // setting up the callbacks between both instances.
  // Re-implemented to set the associated now that we know the internal widget
  virtual void CreateHorizontalScrollbar();
  virtual void CreateVerticalScrollbar();

  // Description:
  // Pack.
  virtual void Pack();

private:
  vtkKWListBoxWithScrollbars(const vtkKWListBoxWithScrollbars&); // Not implemented
  void operator=(const vtkKWListBoxWithScrollbars&); // Not implemented
};

#endif
