# Directory containing class headers.
SET(VTK_FILTERING_HEADER_DIR "${VTK_INSTALL_PREFIX}/include/vtk-5.1")

# Classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES
  "vtkAbstractGraph"
  "vtkAbstractGraphAlgorithm"
  "vtkAbstractMapper"
  "vtkActor2D"
  "vtkActor2DCollection"
  "vtkAlgorithm"
  "vtkAlgorithmOutput"
  "vtkBiQuadraticQuad"
  "vtkBiQuadraticQuadraticHexahedron"
  "vtkBiQuadraticQuadraticWedge"
  "vtkCachedStreamingDemandDrivenPipeline"
  "vtkCardinalSpline"
  "vtkCastToConcrete"
  "vtkCell"
  "vtkCell3D"
  "vtkCellArray"
  "vtkCellData"
  "vtkCellLinks"
  "vtkCellLocator"
  "vtkCellTypes"
  "vtkColorTransferFunction"
  "vtkCompositeDataIterator"
  "vtkCompositeDataPipeline"
  "vtkCompositeDataSet"
  "vtkCone"
  "vtkConvexPointSet"
  "vtkCoordinate"
  "vtkCylinder"
  "vtkDataObject"
  "vtkDataObjectAlgorithm"
  "vtkDataObjectCollection"
  "vtkDataObjectSource"
  "vtkDataObjectTypes"
  "vtkDataSet"
  "vtkDataSetAlgorithm"
  "vtkDataSetAttributes"
  "vtkDataSetCollection"
  "vtkDataSetSource"
  "vtkDataSetToDataSetFilter"
  "vtkDataSetToImageFilter"
  "vtkDataSetToPolyDataFilter"
  "vtkDataSetToStructuredGridFilter"
  "vtkDataSetToStructuredPointsFilter"
  "vtkDataSetToUnstructuredGridFilter"
  "vtkDemandDrivenPipeline"
  "vtkEmptyCell"
  "vtkExecutive"
  "vtkExplicitCell"
  "vtkFieldData"
  "vtkFilteringInformationKeyManager"
  "vtkGenericAdaptorCell"
  "vtkGenericAttribute"
  "vtkGenericAttributeCollection"
  "vtkGenericCell"
  "vtkGenericCellIterator"
  "vtkGenericCellTessellator"
  "vtkGenericDataSet"
  "vtkGenericDataSetAlgorithm"
  "vtkGenericEdgeTable"
  "vtkGenericPointIterator"
  "vtkGenericSubdivisionErrorMetric"
  "vtkGeometricErrorMetric"
  "vtkGraph"
  "vtkGraphAlgorithm"
  "vtkGraphDFSIterator"
  "vtkGraphIdList"
  "vtkAttributesErrorMetric"
  "vtkHexagonalPrism"
  "vtkHexahedron"
  "vtkHierarchicalDataInformation"
  "vtkHierarchicalDataIterator"
  "vtkHierarchicalBoxDataSet"
  "vtkHierarchicalDataSet"
  "vtkHierarchicalDataSetAlgorithm"
  "vtkHyperOctree"
  "vtkHyperOctreeAlgorithm"
  "vtkHyperOctreeCursor"
  "vtkHyperOctreePointsGrabber"
  "vtkImageAlgorithm"
  "vtkImageData"
  "vtkImageInPlaceFilter"
  "vtkImageIterator"
  "vtkImageMultipleInputFilter"
  "vtkImageMultipleInputOutputFilter"
  "vtkImageProgressIterator"
  "vtkImageSource"
  "vtkImageToImageFilter"
  "vtkImageToStructuredPoints"
  "vtkImageTwoInputFilter"
  "vtkImplicitBoolean"
  "vtkImplicitDataSet"
  "vtkImplicitSelectionLoop"
  "vtkImplicitSum"
  "vtkImplicitVolume"
  "vtkImplicitWindowFunction"
  "vtkInformation"
  "vtkInformationDataObjectKey"
  "vtkInformationDoubleKey"
  "vtkInformationDoubleVectorKey"
  "vtkInformationExecutivePortKey"
  "vtkInformationExecutivePortVectorKey"
  "vtkInformationIdTypeKey"
  "vtkInformationInformationKey"
  "vtkInformationInformationVectorKey"
  "vtkInformationIntegerKey"
  "vtkInformationIntegerPointerKey"
  "vtkInformationIntegerVectorKey"
  "vtkInformationIterator"
  "vtkInformationKey"
  "vtkInformationKeyVectorKey"
  "vtkInformationObjectBaseKey"
  "vtkInformationRequestKey"
  "vtkInformationStringKey"
  "vtkInformationUnsignedLongKey"
  "vtkInformationVector"
  "vtkInterpolatedVelocityField"
  "vtkKochanekSpline"
  "vtkLine"
  "vtkLocator"
  "vtkMapper2D"
  "vtkMergePoints"
  "vtkMultiBlockDataSet"
  "vtkMultiBlockDataSetAlgorithm"
  "vtkMultiGroupDataInformation"
  "vtkMultiGroupDataIterator"
  "vtkMultiGroupDataSet"
  "vtkMultiGroupDataSetAlgorithm"
  "vtkNonLinearCell"
  "vtkOrderedTriangulator"
  "vtkParametricSpline"
  "vtkPentagonalPrism"
  "vtkPerlinNoise"
  "vtkPiecewiseFunction"
  "vtkPiecewiseFunctionAlgorithm"
  "vtkPiecewiseFunctionShiftScale"
  "vtkPixel"
  "vtkPointData"
  "vtkPointLocator"
  "vtkPointSet"
  "vtkPointSetAlgorithm"
  "vtkPointSetSource"
  "vtkPointSetToPointSetFilter"
  "vtkPolyData"
  "vtkPolyDataAlgorithm"
  "vtkPolyDataCollection"
  "vtkPolyDataSource"
  "vtkPolyDataToPolyDataFilter"
  "vtkPolyLine"
  "vtkPolyVertex"
  "vtkPolygon"
  "vtkProcessObject"
  "vtkPropAssembly"
  "vtkPyramid"
  "vtkQuad"
  "vtkQuadraticEdge"
  "vtkQuadraticHexahedron"
  "vtkQuadraticPyramid"
  "vtkQuadraticLinearQuad"
  "vtkQuadraticQuad"
  "vtkQuadraticTetra"
  "vtkQuadraticTriangle"
  "vtkQuadraticLinearWedge"
  "vtkQuadraticWedge"
  "vtkRectilinearGrid"
  "vtkRectilinearGridAlgorithm"
  "vtkRectilinearGridSource"
  "vtkRectilinearGridToPolyDataFilter"
  "vtkScalarTree"
  "vtkSelection"
  "vtkSelectionAlgorithm"
  "vtkSimpleCellTessellator"
  "vtkSimpleImageToImageFilter"
  "vtkSimpleScalarTree"
  "vtkSmoothErrorMetric"
  "vtkSphere"
  "vtkSource"
  "vtkSpline"
  "vtkStreamingDemandDrivenPipeline"
  "vtkStructuredGrid"
  "vtkStructuredGridAlgorithm"
  "vtkStructuredGridSource"
  "vtkStructuredGridToPolyDataFilter"
  "vtkStructuredGridToStructuredGridFilter"
  "vtkStructuredPoints"
  "vtkStructuredPointsCollection"
  "vtkStructuredPointsSource"
  "vtkStructuredPointsToPolyDataFilter"
  "vtkStructuredPointsToStructuredPointsFilter"
  "vtkStructuredPointsToUnstructuredGridFilter"
  "vtkSuperquadric"
  "vtkTable"
  "vtkTableAlgorithm"
  "vtkTemporalDataSet"
  "vtkTemporalDataSetAlgorithm"
  "vtkTetra"
  "vtkThreadedImageAlgorithm"
  "vtkTree"
  "vtkTreeAlgorithm"
  "vtkTreeDFSIterator"
  "vtkTriangle"
  "vtkTriangleStrip"
  "vtkTriQuadraticHexahedron"
  "vtkTrivialProducer"
  "vtkUniformGrid"
  "vtkUnstructuredGrid"
  "vtkUnstructuredGridAlgorithm"
  "vtkUnstructuredGridSource"
  "vtkUnstructuredGridToPolyDataFilter"
  "vtkUnstructuredGridToUnstructuredGridFilter"
  "vtkVertex"
  "vtkVertexLinks"
  "vtkViewDependentErrorMetric"
  "vtkVoxel"
  "vtkWedge"
  "vtkViewport"
  "vtkGenericInterpolatedVelocityField")

# Abstract classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES_ABSTRACT
  "vtkAbstractGraph"
  "vtkAbstractMapper"
  "vtkCell"
  "vtkCell3D"
  "vtkCompositeDataIterator"
  "vtkCompositeDataSet"
  "vtkDataObjectSource"
  "vtkDataSet"
  "vtkDataSetSource"
  "vtkDataSetToDataSetFilter"
  "vtkDataSetToImageFilter"
  "vtkDataSetToPolyDataFilter"
  "vtkDataSetToStructuredGridFilter"
  "vtkDataSetToStructuredPointsFilter"
  "vtkDataSetToUnstructuredGridFilter"
  "vtkExecutive"
  "vtkExplicitCell"
  "vtkFilteringInformationKeyManager"
  "vtkGenericAdaptorCell"
  "vtkGenericAttribute"
  "vtkGenericCellIterator"
  "vtkGenericCellTessellator"
  "vtkGenericDataSet"
  "vtkGenericDataSetAlgorithm"
  "vtkGenericPointIterator"
  "vtkGenericSubdivisionErrorMetric"
  "vtkHierarchicalDataSetAlgorithm"
  "vtkHyperOctreeAlgorithm"
  "vtkHyperOctreeCursor"
  "vtkHyperOctreePointsGrabber"
  "vtkImageAlgorithm"
  "vtkImageInPlaceFilter"
  "vtkImageIterator"
  "vtkImageMultipleInputFilter"
  "vtkImageMultipleInputOutputFilter"
  "vtkImageProgressIterator"
  "vtkImageSource"
  "vtkImageToImageFilter"
  "vtkImageTwoInputFilter"
  "vtkInformationDataObjectKey"
  "vtkInformationDoubleKey"
  "vtkInformationDoubleVectorKey"
  "vtkInformationExecutivePortKey"
  "vtkInformationExecutivePortVectorKey"
  "vtkInformationIdTypeKey"
  "vtkInformationInformationKey"
  "vtkInformationInformationVectorKey"
  "vtkInformationIntegerKey"
  "vtkInformationIntegerPointerKey"
  "vtkInformationIntegerVectorKey"
  "vtkInformationKey"
  "vtkInformationKeyVectorKey"
  "vtkInformationObjectBaseKey"
  "vtkInformationRequestKey"
  "vtkInformationStringKey"
  "vtkInformationUnsignedLongKey"
  "vtkLocator"
  "vtkMapper2D"
  "vtkMultiGroupDataSetAlgorithm"
  "vtkNonLinearCell"
  "vtkPointSet"
  "vtkPointSetSource"
  "vtkPointSetToPointSetFilter"
  "vtkPolyDataSource"
  "vtkPolyDataToPolyDataFilter"
  "vtkProcessObject"
  "vtkRectilinearGridSource"
  "vtkRectilinearGridToPolyDataFilter"
  "vtkScalarTree"
  "vtkSimpleImageToImageFilter"
  "vtkSource"
  "vtkSpline"
  "vtkStructuredGridSource"
  "vtkStructuredGridToPolyDataFilter"
  "vtkStructuredGridToStructuredGridFilter"
  "vtkStructuredPointsSource"
  "vtkStructuredPointsToPolyDataFilter"
  "vtkStructuredPointsToStructuredPointsFilter"
  "vtkStructuredPointsToUnstructuredGridFilter"
  "vtkThreadedImageAlgorithm"
  "vtkUnstructuredGridSource"
  "vtkUnstructuredGridToPolyDataFilter"
  "vtkUnstructuredGridToUnstructuredGridFilter"
  "vtkViewport")

# Wrap-exclude classes in vtkFiltering.
SET(VTK_FILTERING_CLASSES_WRAP_EXCLUDE
  "vtkFilteringInformationKeyManager"
  "vtkHierarchicalDataIterator"
  "vtkImageIterator"
  "vtkImageProgressIterator")

# Set convenient variables to test each class.
FOREACH(class ${VTK_FILTERING_CLASSES})
  SET(VTK_CLASS_EXISTS_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_FILTERING_CLASSES_ABSTRACT})
  SET(VTK_CLASS_ABSTRACT_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_FILTERING_CLASSES_WRAP_EXCLUDE})
  SET(VTK_CLASS_WRAP_EXCLUDE_${class} 1)
ENDFOREACH(class)
