# Directory containing class headers.
SET(VTK_INFOVIS_HEADER_DIR "${VTK_INSTALL_PREFIX}/include/vtk-5.1")

# Classes in vtkInfovis.
SET(VTK_INFOVIS_CLASSES
  "vtkBoxLayoutStrategy"
  "vtkCircularLayoutStrategy"
  "vtkDataObjectToTable"
  "vtkDelimitedTextReader"
  "vtkExtractSelectedGraph"
  "vtkFast2DLayoutStrategy"
  "vtkFixedWidthTextReader"
  "vtkForceDirectedLayoutStrategy"
  "vtkGraphHierarchicalBundle"
  "vtkGraphLayout"
  "vtkGraphLayoutStrategy"
  "vtkGraphLayoutViewer"
  "vtkGraphToPolyData"
  "vtkGroupLeafVertices"
  "vtkInteractorStyleTreeMapHover"
  "vtkLabeledTreeMapDataMapper"
  "vtkMergeColumns"
  "vtkMergeTables"
  "vtkPruneTreeFilter"
  "vtkRandomGraphSource"
  "vtkRandomLayoutStrategy"
  "vtkSimple2DLayoutStrategy"
  "vtkSliceAndDiceLayoutStrategy"
  "vtkSquarifyLayoutStrategy"
  "vtkStringToNumeric"
  "vtkTableToGraphFilter"
  "vtkTableToTreeFilter"
  "vtkThresholdTable"
  "vtkTimePointUtility"
  "vtkTreeFieldAggregator"
  "vtkTreeLayoutStrategy"
  "vtkTreeLevelsFilter"
  "vtkTreeMapLayout"
  "vtkTreeMapLayoutStrategy"
  "vtkTreeMapToPolyData"
  "vtkTreeMapViewer"
  "vtkVertexDegree"
  "vtkXMLTreeReader"
  "vtkStringToTimePoint"
  "vtkTimePointToString")

# Abstract classes in vtkInfovis.
SET(VTK_INFOVIS_CLASSES_ABSTRACT
  "vtkGraphLayoutStrategy"
  "vtkTreeMapLayoutStrategy")

# Wrap-exclude classes in vtkInfovis.
SET(VTK_INFOVIS_CLASSES_WRAP_EXCLUDE)

# Set convenient variables to test each class.
FOREACH(class ${VTK_INFOVIS_CLASSES})
  SET(VTK_CLASS_EXISTS_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_INFOVIS_CLASSES_ABSTRACT})
  SET(VTK_CLASS_ABSTRACT_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_INFOVIS_CLASSES_WRAP_EXCLUDE})
  SET(VTK_CLASS_WRAP_EXCLUDE_${class} 1)
ENDFOREACH(class)
