# Directory containing class headers.
SET(VTK_COMMON_HEADER_DIR "${VTK_INSTALL_PREFIX}/include/vtk-5.1")

# Classes in vtkCommon.
SET(VTK_COMMON_CLASSES
  "vtkAbstractArray"
  "vtkAbstractTransform"
  "vtkAmoebaMinimizer"
  "vtkAnimationCue"
  "vtkAnimationScene"
  "vtkArrayIterator"
  "vtkAssemblyNode"
  "vtkAssemblyPath"
  "vtkAssemblyPaths"
  "vtkBitArray"
  "vtkBitArrayIterator"
  "vtkBoundingBox"
  "vtkBox"
  "vtkByteSwap"
  "vtkCallbackCommand"
  "vtkCharArray"
  "vtkCollection"
  "vtkCollectionIterator"
  "vtkCommand"
  "vtkContourValues"
  "vtkCriticalSection"
  "vtkCylindricalTransform"
  "vtkDataArray"
  "vtkDataArrayCollection"
  "vtkDataArrayCollectionIterator"
  "vtkDataArraySelection"
  "vtkDebugLeaks"
  "vtkDebugLeaksManager"
  "vtkDirectory"
  "vtkDoubleArray"
  "vtkDynamicLoader"
  "vtkEdgeTable"
  "vtkErrorCode"
  "vtkEventForwarderCommand"
  "vtkExtentSplitter"
  "vtkExtentTranslator"
  "vtkFastNumericConversion"
  "vtkFileOutputWindow"
  "vtkFloatArray"
  "vtkFunctionParser"
  "vtkFunctionSet"
  "vtkGarbageCollector"
  "vtkGarbageCollectorManager"
  "vtkGeneralTransform"
  "vtkHeap"
  "vtkHomogeneousTransform"
  "vtkIOStream"
  "vtkIdList"
  "vtkIdListCollection"
  "vtkIdTypeArray"
  "vtkIdentityTransform"
  "vtkImplicitFunction"
  "vtkImplicitFunctionCollection"
  "vtkIndent"
  "vtkInitialValueProblemSolver"
  "vtkInstantiator"
  "vtkIntArray"
  "vtkLargeInteger"
  "vtkLinearTransform"
  "vtkLogLookupTable"
  "vtkLongArray"
  "vtkLookupTable"
  "vtkMath"
  "vtkMatrix4x4"
  "vtkMatrixToHomogeneousTransform"
  "vtkMatrixToLinearTransform"
  "vtkMultiThreader"
  "vtkMutexLock"
  "vtkOStrStreamWrapper"
  "vtkOStreamWrapper"
  "vtkObject"
  "vtkObjectBase"
  "vtkObjectFactory"
  "vtkObjectFactoryCollection"
  "vtkOldStyleCallbackCommand"
  "vtkOnePieceExtentTranslator"
  "vtkOutputWindow"
  "vtkOverrideInformation"
  "vtkOverrideInformationCollection"
  "vtkParametricBoy"
  "vtkParametricConicSpiral"
  "vtkParametricCrossCap"
  "vtkParametricDini"
  "vtkParametricEllipsoid"
  "vtkParametricEnneper"
  "vtkParametricFigure8Klein"
  "vtkParametricFunction"
  "vtkParametricKlein"
  "vtkParametricMobius"
  "vtkParametricRandomHills"
  "vtkParametricRoman"
  "vtkParametricSuperEllipsoid"
  "vtkParametricSuperToroid"
  "vtkParametricTorus"
  "vtkPerspectiveTransform"
  "vtkPlane"
  "vtkPlaneCollection"
  "vtkPlanes"
  "vtkPoints"
  "vtkPriorityQueue"
  "vtkProp"
  "vtkPropCollection"
  "vtkProperty2D"
  "vtkQuadric"
  "vtkReferenceCount"
  "vtkRungeKutta2"
  "vtkRungeKutta4"
  "vtkRungeKutta45"
  "vtkScalarsToColors"
  "vtkShortArray"
  "vtkSignedCharArray"
  "vtkSmartPointerBase"
  "vtkSphericalTransform"
  "vtkStdString"
  "vtkStringArray"
  "vtkStructuredData"
  "vtkStructuredVisibilityConstraint"
  "vtkTableExtentTranslator"
  "vtkTensor"
  "vtkThreadMessager"
  "vtkTimeStamp"
  "vtkTimerLog"
  "vtkTransform"
  "vtkTransformCollection"
  "vtkUnsignedCharArray"
  "vtkUnsignedIntArray"
  "vtkUnsignedLongArray"
  "vtkUnsignedShortArray"
  "vtkVariant"
  "vtkVariantArray"
  "vtkVersion"
  "vtkVoidArray"
  "vtkWarpTransform"
  "vtkWindow"
  "vtkWindowLevelLookupTable"
  "vtkXMLFileOutputWindow"
  "vtkLongLongArray"
  "vtkUnsignedLongLongArray"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeInt8Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeInt16Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeInt32Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeInt64Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeUInt8Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeUInt16Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeUInt32Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeUInt64Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeFloat32Array"
  "/usr/pubsw/packages/vtk/5.1.0-CVS/src/VTK/Common/vtkTypeFloat64Array")

# Abstract classes in vtkCommon.
SET(VTK_COMMON_CLASSES_ABSTRACT
  "vtkAbstractArray"
  "vtkAbstractTransform"
  "vtkArrayIterator"
  "vtkCallbackCommand"
  "vtkCommand"
  "vtkDataArray"
  "vtkEventForwarderCommand"
  "vtkFunctionSet"
  "vtkHomogeneousTransform"
  "vtkImplicitFunction"
  "vtkInitialValueProblemSolver"
  "vtkLinearTransform"
  "vtkObjectBase"
  "vtkObjectFactory"
  "vtkOldStyleCallbackCommand"
  "vtkOverrideInformation"
  "vtkOverrideInformationCollection"
  "vtkParametricFunction"
  "vtkProp"
  "vtkScalarsToColors"
  "vtkStructuredData"
  "vtkWarpTransform"
  "vtkWindow")

# Wrap-exclude classes in vtkCommon.
SET(VTK_COMMON_CLASSES_WRAP_EXCLUDE
  "vtkBoundingBox"
  "vtkCallbackCommand"
  "vtkCommand"
  "vtkDebugLeaksManager"
  "vtkErrorCode"
  "vtkEventForwarderCommand"
  "vtkGarbageCollectorManager"
  "vtkIOStream"
  "vtkIndent"
  "vtkLargeInteger"
  "vtkOStrStreamWrapper"
  "vtkOStreamWrapper"
  "vtkOldStyleCallbackCommand"
  "vtkSmartPointerBase"
  "vtkStdString"
  "vtkTimeStamp"
  "vtkVariant")

# Set convenient variables to test each class.
FOREACH(class ${VTK_COMMON_CLASSES})
  SET(VTK_CLASS_EXISTS_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_COMMON_CLASSES_ABSTRACT})
  SET(VTK_CLASS_ABSTRACT_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_COMMON_CLASSES_WRAP_EXCLUDE})
  SET(VTK_CLASS_WRAP_EXCLUDE_${class} 1)
ENDFOREACH(class)
