#!/bin/csh

# Example for Group Analysis #
python ./MultivariateProcedures.py \
-d example_data/features_0.txt example_data/features_1.txt example_data/features_2.txt \
-g example_data/labels.txt \
-a example_data/ages.txt \
-t group \
-s 100 100 \
-o ./example_output/group_comparison_ \
-tfce 1 \
-fdr 1

# Example for Continuous Value Analysis #
python MultivariateProcedures.py \
-d example_data/features_0.txt example_data/features_1.txt example_data/features_2.txt \
-g example_data/labels.txt \
-a example_data/ages.txt \
-t aging \
-s 100 100 \
-o ./example_output/continuous_value_ \
-tfce 1 \
-fdr 1 \
-otype binary

# Example for Group Comparison with Regressing out continuous valued age#
python MultivariateProcedures.py \
-d example_data/features_0.txt example_data/features_1.txt example_data/features_2.txt \
-g example_data/labels.txt \
-a example_data/ages.txt \
-t regressing_out \
-s 100 100 \
-o ./example_output/group_comparison_minusAge_ \
-tfce 1 \
-fdr 1 \
-otype txt \
-nperm 1000

# Example for Effect Comparison #
python MultivariateProcedures.py \
-d example_data/features_0.txt example_data/features_1.txt example_data/features_2.txt \
-g example_data/labels.txt \
-a example_data/ages.txt \
-t effect_comparison \
-s 100 100 \
-o ./example_output/ \
-otype txt \
-nperm 1000 \
-rth 0.1
