var mypath ="";
var grid;
var myfacade;

var mydata;
var myhash = {};

function init() {
    grid.renderArray(mydata);
}

function callback(id, data) {
    mydata[id-1].value = data.value;
    myfacade.publish(mypath+"/callback", data);
}

function establishConnection(path) {
    mypath = path;
    var update = myfacade.subscribe(mypath+"/update", function (message) {
        var p = JSON.parse(message.data);
        mydata[p.id-1] = p;
        var w = dijit.registry.byId(p.name);
        if (w) {
            if (w.type == "checkbox") {
                w.set("checked", p.value, false);
            } else {
                w.set("value", p.value, false);
            }
            w.set("disabled", p.status != 0);
        }
    });
    
    var init = myfacade.subscribe(mypath+"/init", function (message) {
        mydata = JSON.parse(message.data);
        grid.refresh();
        grid.renderArray(mydata);
    });

    var refresh = myfacade.subscribe(mypath+"/refresh", function (message) {
        mydata = JSON.parse(message.data);
        var x = grid.bodyNode.scrollLef;
        var y = grid.bodyNode.scrollTop;
        grid.refresh();
        grid.renderArray(mydata);
        grid.scrollTo({x:x, y:y})
    });

    var destroy = myfacade.subscribe(mypath+"/destroy", function (message) {
        grid.refresh();
    });

    myfacade.publish(mypath, "ready");
    
}


require([
    "MW/facade/MatlabFacade",
    "dgrid/List", "dgrid/Grid","dojo/parser", "dgrid/extensions/ColumnResizer",
    "dijit/form/Select","dijit/form/TextBox","dijit/form/CheckBox", "dijit/form/NumberSpinner", "dijit/Tooltip","dijit/form/Textarea","dijit/form/SimpleTextarea",
    "dijit/layout/ContentPane","dijit/layout/BorderContainer","dijit/TitlePane",
    "dojo/domReady!"
], function(MatlabFacade, List, Grid, parser, ColumnResizer, Select, TextBox, CheckBox, NumberSpinner, ToolTip, Textarea, SimpleTextarea,ContentPane,BorderContainer){

    mypath = location.search.substring(1);
    myfacade = new MatlabFacade();

    function getTitle(object){
        var name = '<div class="name">' + object.id + ": " + object.name + '</div>';
        var w = new dijit.layout.ContentPane({id:object.name+"_name", content: name});
        return w;
    }

    function getValue(object){
        var w;
        switch (object.type) {
        case "enum":
            w = new dijit.form.Select({id:object.name, value:object.value, options:object.options,style:{width:'100px'}});
            dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
            break;
        case "int":
            w = new dijit.form.TextBox({id:object.name, value:object.value});
            dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
            break;
        case "boolean":
            w = new dijit.form.CheckBox({id:object.name, checked:object.value});
            dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.checked});});
            break;
        case "string":
            w = new dijit.form.TextBox({id:object.name, value:object.value});
            dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
            break;
        case "minmax":
            w = new dijit.form.NumberSpinner({id:object.name, value:object.value, constraints:{min:object.min, max:object.max}});
            dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
            break;
        default:
            w = new dijit.form.TextBox({id:object.name, value:"###"});
            dojo.connect(w, "onChange", function () {callback(object.id, {name:w.id, value:w.value});});
        }
        
        w.set("disabled", object.status != 0);


        return w;
    }

    function getBody(object) {
        var v = getValue(object);
        var l = dojo.create("div", {innerHTML:object.prompt+"&nbsp;&nbsp;&nbsp;"});
        v.placeAt(l);

        var t = dojo.create("div", {innerHTML:'<br><i>'+object.tooltip+'</i>'});
        var w = new dijit.layout.ContentPane({id:object.name+"_body", content:[l,t]});

        return w;
    }

    function createParamWidget(object) {
        var w = new dijit.layout.ContentPane({id:object.name+"_param"});
        var t = getTitle(object);
        var b = getBody(object);
        w.addChild(t);
        w.addChild(b);
        return w
    }
    

    function myRenderRow(object){
        var p = dijit.registry.byId(object.name+"_param")
        if (p) {

        }else {
            p = createParamWidget(object);
        }
        return p.domNode;
    }
    

    grid = new List({
        renderRow: myRenderRow
    }, "grid");

    
    establishConnection(mypath);

    
    
});



