/**
 * Dijit mixin which provides font styling to the Dijit.
 *
 * By default, this styles the dijit's 'domNode' property.
 */

define([
    //Dojo core
    "dojo/_base/declare",
    "dojo/dom-style"
], function (declare, domStyle) {

    return declare([], {

        // Constraints: any valid font family name
        fontFamily: "Helvetica",

        // Constraints: any positive number.
        //
        // Unit is interpreted as pixels
        fontSize : 12,

        // Constraints: 'normal' or 'bold'
        fontWeight: "normal",

        // Constraints: 'normal' or 'italic'
        fontStyle: "normal",

        /**
         * Overriden to apply font styling to the domNode when component is first created
         */
        postCreate: function () {
            this.inherited(arguments);

            // apply all default font values
            this._applyFontStyles();
        },

        // -----------------------------------------------------------------------------
        // Custom Setters
        //
        // Setters are ensuring that after the set happens... apply the font style
        // -----------------------------------------------------------------------------
        _setFontFamilyAttr: function (newValue) {

            // apply styling
            domStyle.set(this._getNodeToApplyFontProperties(), {
                "font-family": newValue
            });

            // storage
            this._set("fontFamily", newValue);
        },

        _setFontSizeAttr: function (newValue) {
            // apply styling
            domStyle.set(this._getNodeToApplyFontProperties(), {
                "font-size": newValue + "px",
            });

            // storage
            this._set("fontSize", newValue);
        },

        _setFontWeightAttr: function (newValue) {
            // apply styling
            domStyle.set(this._getNodeToApplyFontProperties(), {
                "font-weight": newValue
            });

            // storage
            this._set("fontWeight", newValue);
        },

        _setFontStyleAttr: function (newValue) {
            // apply styling
            domStyle.set(this._getNodeToApplyFontProperties(), {
                "font-style": newValue
            });

            // storage
            this._set("fontStyle", newValue);
        },

        /**
         * Use the
         * @returns {*}
         * @private
         */
        _getNodeToApplyFontProperties: function(){
            return this.domNode;
        },

        // -----------------------------------------------------------------------------
        // Private Functions
        // -----------------------------------------------------------------------------

        /**
         * Helper to apply ALL font - related styles to the DOM node
         * @private
         */
        _applyFontStyles: function () {
            var newStyle = {
                "font-family": this.get("fontFamily"),
                "font-size": this.get("fontSize") + "px",
                "font-weight": this.get("fontWeight"),
                "font-style": this.get("fontStyle")
            };
            domStyle.set(this.domNode, newStyle);
        }
    });
})
;