% Operators and special characters.
%
% Arithmetic operators.
%   plus       - Plus                               +    
%   uplus      - Unary plus                         +    
%   minus      - Minus                              -    
%   uminus     - Unary minus                        -    
%   mtimes     - Matrix multiply                    *    
%   times      - Array multiply                    .*    
%   mpower     - Matrix power                       ^    
%   power      - Array power                       .^    
%   mldivide   - Backslash or left matrix divide    \    
%   mrdivide   - Slash or right matrix divide       /    
%   ldivide    - Left array divide                 .\    
%   rdivide    - Right array divide                ./    
%   idivide    - Integer division with rounding option.
%   kron       - Kronecker tensor product   
%
% Relational operators.
%   eq         - Equal                             ==     
%   ne         - Not equal                         ~=     
%   lt         - Less than                          <      
%   gt         - Greater than                       >      
%   le         - Less than or equal                <=     
%   ge         - Greater than or equal             >=     
%
% Logical operators.
%   relop      - Short-circuit logical AND         &&     
%   relop      - Short-circuit logical OR          ||     
%   and        - Element-wise logical AND           &      
%   or         - Element-wise logical OR            |      
%   not        - Logical NOT                        ~      
%   punct      - Ignore function argument or output ~
%   xor        - Logical EXCLUSIVE OR
%   any        - True if any element of vector is nonzero
%   all        - True if all elements of vector are nonzero
%
% Special characters. 
%   colon      - Colon                              : 
%   paren      - Parentheses and subscripting      ( )              
%   paren      - Brackets                          [ ]     
%   paren      - Braces and subscripting           { }          
%   punct      - Function handle creation           @
%   punct      - Decimal point                      .      
%   punct      - Structure field access             .      
%   punct      - Parent directory                   ..     
%   punct      - Continuation                       ...    
%   punct      - Separator                          ,      
%   punct      - Semicolon                          ;      
%   punct      - Comment                            %      
%   punct      - Invoke operating system command    !            
%   punct      - Assignment                         =
%   punct      - Quote                              '      
%   transpose  - Transpose                         .'
%   ctranspose - Complex conjugate transpose        ' 
%   horzcat    - Horizontal concatenation          [,]     
%   vertcat    - Vertical concatenation            [;]     
%   subsasgn   - Subscripted assignment          ( ),{ },.   
%   subsref    - Subscripted reference           ( ),{ },.   
%   subsindex  - Subscript index
%   metaclass  - Metaclass for MATLAB class         ?
%
% Bitwise operators.
%   bitand     - Bit-wise AND.
%   bitcmp     - Complement bits.
%   bitor      - Bit-wise OR.
%   bitxor     - Bit-wise XOR.
%   bitset     - Set bit.
%   bitget     - Get bit.
%   bitshift   - Bit-wise shift.
%
% Set operators.
%   union      - Set union.
%   unique     - Set unique.
%   intersect  - Set intersection.
%   setdiff    - Set difference.
%   setxor     - Set exclusive-or.
%   ismember   - True for set member.
%
% See also ARITH, RELOP, SLASH, FUNCTION_HANDLE.

% Additional help files.
%   arith      - Arithmetic operators.
%   relop      - Relational operators.
%   slash      - Matrix division.

% Functions that will be removed.
%   bitmax     - Maximum floating point integer.

%   Copyright 1984-2014 The MathWorks, Inc. 
