% Data analysis and Fourier transforms.
%
% Basic operations.
%   max         - Largest component.
%   min         - Smallest component.
%   mean        - Average or mean value.
%   median      - Median value.
%   mode        - Mode, or most frequent value in a sample.
%   std         - Standard deviation.
%   var         - Variance.
%   sort        - Sort in ascending order. 
%   sortrows    - Sort rows in ascending order.
%   issorted    - TRUE for sorted vector and matrices.
%   sum         - Sum of elements.
%   prod        - Product of elements.
%   histogram   - Histogram.
%   histcounts  - Histogram bin counts.
%   trapz       - Trapezoidal numerical integration.
%   cumsum      - Cumulative sum of elements.
%   cumprod     - Cumulative product of elements.
%   cumtrapz    - Cumulative trapezoidal numerical integration.
%
% Finite differences.
%   diff        - Difference and approximate derivative.
%   gradient    - Approximate gradient.
%   del2        - Discrete Laplacian.
%
% Correlation.
%   corrcoef    - Correlation coefficients.
%   cov         - Covariance matrix.
%   subspace    - Angle between subspaces.
%
% Filtering and convolution.
%   filter      - One-dimensional digital filter.
%   filter2     - Two-dimensional digital filter.
%   conv        - Convolution and polynomial multiplication.
%   conv2       - Two-dimensional convolution.
%   convn       - N-dimensional convolution.
%   deconv      - Deconvolution and polynomial division.
%   detrend     - Linear trend removal.
%
% Fourier transforms.
%   fft         - Discrete Fourier transform.
%   fft2        - Two-dimensional discrete Fourier transform.
%   fftn        - N-dimensional discrete Fourier Transform.
%   ifft        - Inverse discrete Fourier transform.
%   ifft2       - Two-dimensional inverse discrete Fourier transform.
%   ifftn       - N-dimensional inverse discrete Fourier Transform.
%   fftshift    - Shift zero-frequency component to center of spectrum.
%   ifftshift   - Inverse FFTSHIFT.
%   fftw        - Interface to FFTW library run-time algorithm tuning control.

%   hist        - Histogram.
%   histc       - Histogram count.

%   Copyright 1984-2014 The MathWorks, Inc.
