/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer;

import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.peermodel.PeerModelManagerSyncable;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.PeerNodeSyncable;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observable;
import com.mathworks.peermodel.events.ObservableSyncable;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.impl.EventImpl;
import com.mathworks.peermodel.synchronizer.utils.ImageDifferencer;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class PeerSynchronizer
implements com.mathworks.peermodel.PeerSynchronizer,
Observer,
Subscriber {
    private static final Logger logger = Logger.getLogger(PeerSynchronizer.class.getName());
    public static String debugNamespace = "/change/me/to/debug";
    private String namespace;
    protected PeerModelManagerSyncable manager;
    protected MessageService messageService;
    private final AtomicInteger messageCount = new AtomicInteger(0);
    private final AtomicBoolean handshook = new AtomicBoolean(false);
    private boolean client = false;
    private String clientId = UUID.randomUUID().toString();
    private Map<String, Boolean> syncEnabled = new HashMap<String, Boolean>();
    private ConcurrentMap<String, Method> observerMethodMap = new ConcurrentHashMap<String, Method>();
    private ConcurrentMap<String, Method> subscriberMethodMap = new ConcurrentHashMap<String, Method>();
    protected final Object originator = new Object();
    protected List<Event> peerEventQueue = new ArrayList<Event>();
    private Lock eventLock = new ReentrantLock(true);
    private Lock messageLock = new ReentrantLock(true);

    public static void setDebugNamespace(String namespace) {
        debugNamespace = namespace;
    }

    public PeerSynchronizer(String namespace, PeerModelManagerSyncable manager, MessageService messageService) {
        this(namespace, manager, messageService, false);
    }

    public PeerSynchronizer(String namespace, PeerModelManagerSyncable manager, MessageService messageService, boolean isClient) {
        this.namespace = namespace;
        this.manager = manager;
        this.messageService = messageService;
        this.client = isClient;
        this.addManagerListeners();
        this.addMessageSubscriptions();
    }

    public void remove() {
        this.removeMessageSubscriptions();
        this.removeManagerListeners();
    }

    private void startHandshake() {
        this.log("Starting handshake");
        Map<String, Object> data = this.createNewMessage();
        data.put("clientId", this.clientId);
        data.put("syncEnabled", this.manager.isSyncEnabled());
        this.publish(this.getChannel("getStatus"), data);
    }

    private void handshakeComplete() {
        this.log("Handshake complete");
        this.handshook.set(true);
        this.processQueue();
    }

    private void processQueue() {
        List<Event> oldQueue = this.peerEventQueue;
        this.peerEventQueue = new ArrayList<Event>();
        this.log("Processing queue", oldQueue.toString());
        for (Event event : oldQueue) {
            this.publishPeerEventMessage(event);
        }
    }

    protected boolean isReady() {
        return this.handshook.get();
    }

    public void syncChangedObserver(Event event) {
        this.syncEnabled.put(this.clientId, this.manager.isSyncEnabled());
        if (this.manager.isSyncEnabled()) {
            this.addSyncMessageSubscriptions();
            this.addSyncManagerListeners();
            this.startHandshake();
        } else {
            this.removeSyncManagerListeners();
            this.removeSyncMessageSubscriptions();
            this.handshook.set(false);
        }
    }

    public void getStatusSubscriber(Message message) {
        Map<String, Object> status = this.createNewMessage();
        status.put("syncEnabled", this.manager.isSyncEnabled());
        status.put("isClient", this.isClient());
        status.put("clientId", this.clientId);
        this.publish(this.getChannel("status"), status);
        this.statusSubscriber(message);
    }

    public void statusSubscriber(Message message) {
        this.log("Status received", message.toString());
        Map data = (Map)message.getData();
        String clientId = (String)data.get("clientId");
        Boolean newSyncEnabled = (Boolean)data.get("syncEnabled");
        this.syncEnabled.put(clientId, newSyncEnabled);
        if (this.manager.isSyncEnabled() && this.isClient()) {
            this.publish(this.getChannel("getFullUpdate"), this.createNewMessage());
        }
    }

    public void getFullUpdateSubscriber(Message message) {
        this.log("getFullUpdate requested");
        if (this.manager.isSyncEnabled() && !this.isClient()) {
            HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
            if (this.manager.hasRoot()) {
                data.put("root", this.convertNodesRecursive(this.manager.getRoot(), 0));
            }
            this.publish(this.getChannel("fullUpdate"), data);
            this.handshakeComplete();
        }
    }

    public void fullUpdateSubscriber(Message message) {
        this.log("fullUpdate received", message.toString());
        if (this.shouldSync() && this.isClient()) {
            Map data = (Map)message.getData();
            Map root = (Map)data.get("root");
            if (!(!this.manager.hasRoot() || root != null && root.get("id").equals(this.manager.getRoot().getId()) && root.get("type").equals(this.manager.getRoot().getType()))) {
                this.manager.getRoot().destroy(this.originator);
            }
            this.handshakeComplete();
            if (root != null) {
                boolean updateProps = true;
                if (!this.manager.hasRoot() && root.get("properties") instanceof Map) {
                    updateProps = false;
                    this.manager.setRoot((String)root.get("id"), (String)root.get("type"), (Map)root.get("properties"), this.originator);
                } else if (!this.manager.hasRoot()) {
                    updateProps = false;
                    this.manager.setRoot((String)root.get("id"), (String)root.get("type"), new HashMap(), this.originator);
                }
                this.updateNodeRecursive((PeerNodeSyncable)this.manager.getRoot(), root, updateProps);
            }
        }
    }

    public void rootSetObserver(Event event) {
        this.addNodeListeners(event.getTarget());
        if (this.shouldSync(event) && this.isReady()) {
            this.publishRootSetMessage(event);
        }
    }

    public void publishRootSetMessage(Event event) {
        Map<String, Object> message = this.createNewMessage();
        message.put("target", this.convertNode(event.getTarget()));
        this.publish(this.getChannel(event.getType()), message);
    }

    public void rootSetSubscriber(Message message) {
        if (this.shouldSync()) {
            Map root = (Map)((Map)message.getData()).get("target");
            if (this.manager.hasRoot()) {
                this.manager.getRoot().destroy(this.originator);
            }
            if (root.get("properties") instanceof Map) {
                this.manager.setRoot((String)root.get("id"), (String)root.get("type"), (Map)root.get("properties"), this.originator);
            } else {
                this.manager.setRoot((String)root.get("id"), (String)root.get("type"), new HashMap(), this.originator);
            }
        }
    }

    public void rootDestroyedObserver(Event event) {
        if (this.shouldSync(event) && this.isReady()) {
            this.publishRootDestroyedMessage(event);
        }
    }

    public void publishRootDestroyedMessage(Event event) {
        Map<String, Object> message = this.createNewMessage();
        message.put("targetId", event.getTarget().getId());
        this.publish(this.getChannel(event.getType()), message);
    }

    public void rootDestroyedSubscriber(Message message) {
        if (this.shouldSync()) {
            if (this.manager.hasRoot() && this.manager.getRoot().getId().equals(((Map)message.getData()).get("targetId"))) {
                this.manager.getRoot().destroy(this.originator);
            } else {
                logger.severe("Tried to unset the wrong root. " + this.namespace);
            }
        }
    }

    public void childMovedObserver(Event event) {
        if (this.shouldSync(event) && this.isReady()) {
            this.publishChildMovedMessage(event);
        }
    }

    public void publishChildMovedMessage(Event event) {
        Map<String, Object> message = this.createNewMessage();
        message.put("targetId", event.getTarget().getId());
        message.put("oldParentId", ((PeerNode)event.getData().get("oldParent")).getId());
        message.put("oldIndex", event.getData().get("oldIndex"));
        message.put("newParentId", ((PeerNode)event.getData().get("newParent")).getId());
        message.put("newIndex", event.getData().get("newIndex"));
        this.publish(this.getChannel(event.getType()), message);
    }

    public void childMovedSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            PeerNode child = this.manager.getById((String)data.get("targetId"));
            PeerNode newParent = this.manager.getById((String)data.get("newParentId"));
            int newIndex = data.get("newIndex") instanceof Integer ? ((Integer)data.get("newIndex")).intValue() : ((Double)data.get("newIndex")).intValue();
            this.manager.move(child, newParent, newIndex, this.originator);
        }
    }

    public void childAddedObserver(Event event) {
        PeerNode child = (PeerNode)event.getData().get("child");
        this.addNodeListeners(child);
        if (this.shouldSync(event) && this.isReady()) {
            this.publishSubTreeAddedMessage(event);
        }
    }

    public void subTreeAddedSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            String parentId = (String)data.get("parentId");
            Map childData = (Map)data.get("child");
            PeerNodeSyncable node = (PeerNodeSyncable)this.manager.getById(parentId);
            int index = data.get("index") instanceof Double ? ((Double)data.get("index")).intValue() : ((Integer)data.get("index")).intValue();
            PeerNodeSyncable child = node.addChild((String)childData.get("id"), (String)childData.get("type"), this.getDataProperties(childData), index, this.originator);
            this.updateNodeRecursive(child, childData, false);
        }
    }

    public void publishSubTreeAddedMessage(Event event) {
        Map<String, Object> message = this.createNewMessage();
        PeerNode child = (PeerNode)event.getData().get("child");
        message.put("parentId", event.getTarget().getId());
        message.put("child", this.convertNodesRecursive(child, (Integer)event.getData().get("index")));
        message.put("index", event.getData().get("index"));
        this.messageService.publish(this.getChannel("subTreeAdded"), message);
    }

    public void childDetachedObserver(Event event) {
        if (this.shouldSync(event) && this.isReady()) {
            this.publishChildDetachedMessage(event);
        }
    }

    public void publishChildDetachedMessage(Event event) {
        PeerNode child = (PeerNode)event.getData().get("child");
        Map<String, Object> message = this.createNewMessage();
        message.put("parentId", event.getTarget().getId());
        message.put("childId", child.getId());
        this.publish(this.getChannel(event.getType()), message);
    }

    public void childDetachedSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            this.manager.getById((String)data.get("childId")).detach(this.originator);
        }
    }

    public void childReattachedObserver(Event event) {
        if (this.shouldSync(event) && this.isReady()) {
            this.publishChildReattachedMessage(event);
        }
    }

    public void publishChildReattachedMessage(Event event) {
        PeerNode child = (PeerNode)event.getData().get("child");
        Map<String, Object> message = this.createNewMessage();
        message.put("parentId", event.getTarget().getId());
        message.put("childId", child.getId());
        message.put("index", event.getData().get("index"));
        this.publish(this.getChannel(event.getType()), message);
    }

    public void childReattachedSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            String childId = (String)data.get("childId");
            this.manager.getById(childId).reattach(((Integer)data.get("index")).intValue(), this.originator);
        }
    }

    public void subTreeDestroyedObserver(Event event) {
        PeerNode child = (PeerNode)event.getData().get("child");
        this.removeNodeListenersRecursive(child);
        if (this.shouldSync(event) && this.isReady()) {
            this.publishSubTreeDestroyedMessage(event);
        }
    }

    public void publishSubTreeDestroyedMessage(Event event) {
        PeerNode child = (PeerNode)event.getData().get("child");
        Map<String, Object> message = this.createNewMessage();
        message.put("childId", child.getId());
        this.publish(this.getChannel(event.getType()), message);
    }

    public void subTreeDestroyedSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            String targetId = (String)data.get("childId");
            this.manager.getById(targetId).destroy(this.originator);
        }
    }

    public void propertiesSetObserver(Event event) {
        if (this.shouldSync(event) && this.isReady() && (event.getTarget().hasParent() || event.getTarget().equals(this.manager.getRoot()))) {
            Map oldValues = (Map)event.getData().get("oldValues");
            Map newValues = (Map)event.getData().get("newValues");
            for (Map.Entry entry : newValues.entrySet()) {
                Object newValue = entry.getValue();
                Object oldValue = oldValues.get(entry.getKey());
                if (entry.getValue() instanceof BufferedImage && oldValue != null && oldValue instanceof BufferedImage && ((BufferedImage)newValue).getType() == ((BufferedImage)oldValue).getType() && ((BufferedImage)newValue).getWidth() == ((BufferedImage)oldValue).getWidth() && ((BufferedImage)newValue).getHeight() == ((BufferedImage)oldValue).getHeight()) {
                    Collection<Map<String, Object>> diffImages = ImageDifferencer.computeImageDifferences((BufferedImage)oldValue, (BufferedImage)newValue);
                    if (diffImages.isEmpty()) continue;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("key", entry.getKey());
                    data.put("newValue", diffImages);
                    EventImpl imageUpdateEvent = new EventImpl("imageUpdate", this.originator, event.getTarget(), data);
                    this.publishImageUpdateMessage((Event)imageUpdateEvent);
                    continue;
                }
                this.publishPropertiesSetMessage(event);
            }
        }
    }

    public void publishImageUpdateMessage(Event event) {
        Map<String, Object> imageUpdateMessage = this.createNewMessage();
        imageUpdateMessage.put("targetId", event.getTarget().getId());
        imageUpdateMessage.putAll(event.getData());
        this.publish(this.getChannel("imageUpdate"), imageUpdateMessage);
    }

    public void publishPropertiesSetMessage(Event event) {
        if (this.manager.hasById(event.getTarget().getId())) {
            Map<String, Object> message = this.createNewMessage();
            message.put("targetId", event.getTarget().getId());
            message.put("properties", event.getData().get("newValues"));
            this.publish(this.getChannel(event.getType()), message);
        }
    }

    public void propertiesSetSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            String targetId = (String)data.get("targetId");
            PeerNode node = this.manager.getById(targetId);
            Map properties = (Map)data.get("properties");
            node.setProperties(properties, this.originator);
        }
    }

    public void imageUpdateSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            String targetId = (String)data.get("targetId");
            PeerNode node = this.manager.getById(targetId);
            Collection diffImages = (Collection)data.get("newValue");
            String key = (String)data.get("key");
            if (key != null && node.hasProperty(key)) {
                BufferedImage newImage = ImageDifferencer.applyImageDifferences((BufferedImage)node.getProperty(key), diffImages);
                node.setProperty(key, (Object)newImage, this.originator);
            }
        }
    }

    public void propertiesUnsetObserver(Event event) {
        if (this.shouldSync(event) && this.isReady()) {
            this.publishPropertiesUnsetMessage(event);
        }
    }

    public void publishPropertiesUnsetMessage(Event event) {
        if (this.manager.hasById(event.getTarget().getId())) {
            Map<String, Object> message = this.createNewMessage();
            message.put("targetId", event.getTarget().getId());
            Map oldValues = (Map)event.getData().get("oldValues");
            message.put("keys", oldValues.keySet().toArray());
            this.publish(this.getChannel(event.getType()), message);
        }
    }

    public void propertiesUnsetSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            String targetId = (String)data.get("targetId");
            PeerNode node = this.manager.getById(targetId);
            Object[] keysAsObjectArray = (Object[])data.get("keys");
            String[] keys = (String[])Arrays.copyOf(keysAsObjectArray, keysAsObjectArray.length, String[].class);
            node.unsetProperties(keys, this.originator);
        }
    }

    public void peerEventObserver(Event event) {
        if (this.shouldSync(event)) {
            if (this.isReady()) {
                this.publishPeerEventMessage(event);
            } else {
                this.peerEventQueue.add(event);
            }
        }
    }

    public void publishPeerEventMessage(Event event) {
        Map<String, Object> message = this.createNewMessage();
        message.put("targetId", event.getTarget().getId());
        message.put("data", event.getData());
        this.publish(this.getChannel(event.getType()), message);
    }

    public void peerEventSubscriber(Message message) {
        if (this.shouldSync()) {
            Map data = (Map)message.getData();
            String targetId = (String)data.get("targetId");
            if (this.manager.hasById(targetId)) {
                PeerNode node = this.manager.getById(targetId);
                node.dispatchEvent("peerEvent", this.originator, node, (Map)data.get("data"));
            } else {
                logger.info("Peer event ignored because node does not exist: " + targetId + ": " + data.get("data"));
            }
        }
    }

    protected void addMessageSubscriptions() {
        this.subscribe("status");
        this.subscribe("getStatus");
        if (this.manager.isSyncEnabled()) {
            this.addSyncMessageSubscriptions();
        }
    }

    protected void removeMessageSubscriptions() {
        this.unsubscribe("status");
        this.unsubscribe("getStatus");
        if (this.manager.isSyncEnabled()) {
            this.removeSyncMessageSubscriptions();
        }
    }

    protected void addSyncMessageSubscriptions() {
        this.subscribe("rootSet");
        this.subscribe("rootDestroyed");
        this.subscribe("getFullUpdate");
        this.subscribe("fullUpdate");
        this.subscribe("childMoved");
        this.subscribe("subTreeAdded");
        this.subscribe("childDetached");
        this.subscribe("childReattached");
        this.subscribe("subTreeDestroyed");
        this.subscribe("propertiesSet");
        this.subscribe("imageUpdate");
        this.subscribe("propertiesUnset");
        this.subscribe("peerEvent");
    }

    protected void removeSyncMessageSubscriptions() {
        this.unsubscribe("rootSet");
        this.unsubscribe("rootDestroyed");
        this.unsubscribe("getFullUpdate");
        this.unsubscribe("fullUpdate");
        this.unsubscribe("childMoved");
        this.unsubscribe("subTreeAdded");
        this.unsubscribe("childDetached");
        this.unsubscribe("childReattached");
        this.unsubscribe("subTreeDestroyed");
        this.unsubscribe("propertiesSet");
        this.unsubscribe("imageUpdate");
        this.unsubscribe("propertiesUnset");
        this.unsubscribe("peerEvent");
    }

    private void addManagerListeners() {
        this.addListener((Observable)this.manager, "syncChanged");
        if (this.manager.isSyncEnabled()) {
            this.addSyncManagerListeners();
        }
    }

    private void removeManagerListeners() {
        this.removeListener((Observable)this.manager, "syncChanged");
        if (this.manager.isSyncEnabled()) {
            this.removeSyncManagerListeners();
        }
    }

    protected void addSyncManagerListeners() {
        this.addListener((Observable)this.manager, "rootSet");
        this.addListener((Observable)this.manager, "rootDestroyed");
        this.addListener((Observable)this.manager, "childMoved");
        if (this.manager.hasRoot()) {
            this.addNodeListenersRecursive(this.manager.getRoot());
        }
    }

    protected void removeSyncManagerListeners() {
        this.removeListener((Observable)this.manager, "rootSet");
        this.removeListener((Observable)this.manager, "rootDestroyed");
        this.removeListener((Observable)this.manager, "childMoved");
        if (this.manager.hasRoot()) {
            this.removeNodeListenersRecursive(this.manager.getRoot());
        }
    }

    protected void addNodeListeners(PeerNode target) {
        this.addListener((Observable)target, "childAdded");
        this.addListener((Observable)target, "childDetached");
        this.addListener((Observable)target, "childReattached");
        this.addListener((Observable)target, "subTreeDestroyed");
        this.addListener((Observable)target, "propertiesSet");
        this.addListener((Observable)target, "propertiesUnset");
        this.addListener((Observable)target, "peerEvent");
    }

    protected void removeNodeListeners(PeerNode target) {
        this.removeListener((Observable)target, "childAdded");
        this.removeListener((Observable)target, "childDetached");
        this.removeListener((Observable)target, "childReattached");
        this.removeListener((Observable)target, "subTreeDestroyed");
        this.removeListener((Observable)target, "propertiesSet");
        this.removeListener((Observable)target, "propertiesUnset");
        this.removeListener((Observable)target, "peerEvent");
    }

    protected void addNodeListenersRecursive(PeerNode node) {
        this.addNodeListeners(node);
        for (PeerNode child : node.getChildren()) {
            this.addNodeListenersRecursive(child);
        }
    }

    protected void removeNodeListenersRecursive(PeerNode node) {
        this.removeNodeListeners(node);
        for (PeerNode child : node.getChildren()) {
            this.removeNodeListenersRecursive(child);
        }
    }

    protected void subscribe(String messageName) {
        this.messageService.subscribe(this.getChannel(messageName), (Subscriber)this);
    }

    protected void unsubscribe(String messageName) {
        this.messageService.unsubscribe(this.getChannel(messageName), (Subscriber)this);
    }

    protected void addListener(Observable observable, String eventName) {
        ((ObservableSyncable)observable).addSyncEventListener(eventName, (Observer)this);
    }

    protected void removeListener(Observable observable, String eventName) {
        ((ObservableSyncable)observable).removeSyncEventListener(eventName, (Observer)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Event event) {
        this.eventLock.lock();
        try {
            Method method;
            if (!this.observerMethodMap.containsKey(event.getType())) {
                try {
                    method = this.getClass().getMethod(event.getType() + "Observer", Event.class);
                    this.observerMethodMap.putIfAbsent(event.getType(), method);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Did not find an observer method for the specified method");
                }
            }
            method = (Method)this.observerMethodMap.get(event.getType());
            try {
                method.invoke((Object)this, event);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Event that caused error: " + event);
            }
        }
        finally {
            this.eventLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Message message) {
        this.messageLock.lock();
        try {
            if (!this.subscriberMethodMap.containsKey(message.getChannel())) {
                try {
                    String type = message.getChannel().substring(message.getChannel().lastIndexOf("/") + 1);
                    Method method = this.getClass().getMethod(type + "Subscriber", Message.class);
                    this.subscriberMethodMap.putIfAbsent(message.getChannel(), method);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Did not find a subscriber method for the specified method");
                }
            }
            Method method = (Method)this.subscriberMethodMap.get(message.getChannel());
            try {
                method.invoke((Object)this, message);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Message that caused error: " + message);
            }
        }
        finally {
            this.messageLock.unlock();
        }
    }

    protected boolean shouldSync() {
        return this.shouldSync(null);
    }

    protected boolean shouldSync(Event event) {
        return this.manager.isSyncEnabled() && (event == null || event.getOriginator() != this.originator);
    }

    protected void publish(String channel, Object message) {
        this.log("Publishing message", channel, message.toString());
        this.messageService.publish(channel, message);
    }

    protected String getChannel(String eventType) {
        return "/peermodel" + this.namespace + "/" + eventType;
    }

    protected Map<String, Object> createNewMessage() {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("message", this.messageCount.getAndIncrement());
        return message;
    }

    protected Map<String, Object> convertNodesRecursive(PeerNode node, int index) {
        Map<String, Object> data = this.convertNode(node, index);
        Object[] children = new Object[node.getNumberOfChildren()];
        int childIndex = 0;
        for (PeerNode child : node.getChildren()) {
            children[childIndex] = this.convertNodesRecursive(child, childIndex);
            ++childIndex;
        }
        data.put("children", children);
        return data;
    }

    protected Map<String, Object> convertNode(PeerNode node) {
        return this.convertNode(node, 0);
    }

    protected Map<String, Object> convertNode(PeerNode node, int index) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", node.getId());
        data.put("type", node.getType());
        data.put("properties", node.getProperties());
        data.put("index", Double.valueOf(index));
        return data;
    }

    protected void updateNodeRecursive(PeerNodeSyncable node, Map<String, Object> data, boolean replaceProps) {
        if (replaceProps) {
            Map properties = this.getDataProperties(data);
            node.replaceProperties(properties, this.originator);
        }
        this.destroyOldChildren((PeerNode)node, data);
        List<PeerNode> newChildren = this.addNewChildren(node, data);
        this.updateChildIndices((PeerNode)node, data);
        this.updateChildren((PeerNode)node, data, newChildren);
    }

    private void destroyOldChildren(PeerNode node, Map<String, Object> data) {
        List children = node.getChildren();
        for (PeerNode child : children) {
            if (this.dataHasChild(data, child)) continue;
            child.destroy(this.originator);
        }
    }

    private List<PeerNode> addNewChildren(PeerNodeSyncable node, Map<String, Object> data) {
        Object[] childrenData = this.getChildrenData(data);
        ArrayList<PeerNode> newChildren = new ArrayList<PeerNode>();
        if (childrenData != null) {
            for (int i = 0; i < childrenData.length; ++i) {
                Map child = (Map)childrenData[i];
                if (node.hasChild((String)child.get("id"))) continue;
                newChildren.add((PeerNode)node.addChild((String)child.get("id"), (String)child.get("type"), this.getDataProperties(child), i, this.originator));
            }
        }
        return newChildren;
    }

    private void updateChildIndices(PeerNode node, Map<String, Object> data) {
        Object[] childrenData = this.getChildrenData(data);
        if (childrenData != null) {
            for (int i = 0; i < childrenData.length; ++i) {
                Map child = (Map)childrenData[i];
                PeerNode childNode = node.getChild((String)child.get("id"));
                if (childNode == null || node.getChildIndex(childNode) == i) continue;
                this.manager.move(childNode, node, i, this.originator);
            }
        }
    }

    private void updateChildren(PeerNode node, Map<String, Object> data, List<PeerNode> newChildren) {
        List children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            PeerNodeSyncable childNode;
            Map childData = (Map)((Object[])data.get("children"))[i];
            this.updateNodeRecursive(childNode, childData, !newChildren.contains(childNode = (PeerNodeSyncable)children.get(i)));
        }
    }

    protected boolean dataHasChild(Map<String, Object> data, PeerNode childNode) {
        Object[] childrenData = this.getChildrenData(data);
        if (childrenData != null) {
            for (Object childData : childrenData) {
                Map child = (Map)childData;
                if (!child.get("id").equals(childNode.getId()) || !child.get("type").equals(childNode.getType())) continue;
                return true;
            }
        }
        return false;
    }

    protected Map getDataProperties(Map<String, Object> data) {
        Map properties = data.get("properties") instanceof Map ? (Map)data.get("properties") : new HashMap();
        return properties;
    }

    protected Object[] getChildrenData(Map<String, Object> data) {
        Object[] childrenData = null;
        if (data.get("children") != null) {
            childrenData = data.get("children") instanceof List ? ((List)data.get("children")).toArray() : (Object[])data.get("children");
        }
        return childrenData;
    }

    protected void log(String ... args) {
        if (this.namespace.equals(debugNamespace)) {
            logger.info("PeerSynchronizer(" + this.namespace + "): " + StringUtils.join((Object[])args, (String)", "));
        }
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Collection<String> getAllPeers() {
        return this.syncEnabled.keySet();
    }
}

