/*
 * Decompiled with CFR 0.152.
 */
package net.jini.url.httpmd;

import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.logging.Logger;
import net.jini.url.httpmd.HttpmdUtil;
import net.jini.url.httpmd.WrongMessageDigestException;

class MdInputStream
extends InputStream {
    private static final Logger logger = Logger.getLogger("net.jini.url.httpmd");
    private static final int SKIP_BUFFER_SIZE = 512;
    private final URL url;
    private final InputStream in;
    private final MessageDigest messageDigest;
    private final byte[] expectedDigest;
    private byte[] skipBuffer;
    private boolean checked;
    private String failed;

    MdInputStream(URL uRL, InputStream inputStream, MessageDigest messageDigest, byte[] byArray) {
        if (uRL == null || inputStream == null || messageDigest == null) {
            throw new NullPointerException();
        }
        this.url = uRL;
        this.in = inputStream;
        this.messageDigest = messageDigest;
        this.expectedDigest = (byte[])byArray.clone();
    }

    public synchronized int read() throws IOException {
        this.checkFailed();
        int n = this.in.read();
        if (n < 0) {
            this.checkDigest();
        } else {
            this.messageDigest.update((byte)n);
        }
        return n;
    }

    private void checkFailed() throws WrongMessageDigestException {
        if (this.failed != null) {
            WrongMessageDigestException wrongMessageDigestException = new WrongMessageDigestException(this.failed);
            logger.log(Levels.FAILED, "Incorrect message digest", wrongMessageDigestException);
            throw wrongMessageDigestException;
        }
    }

    private void checkDigest() throws WrongMessageDigestException {
        if (!this.checked) {
            byte[] byArray = this.messageDigest.digest();
            this.checked = true;
            if (!MessageDigest.isEqual(byArray, this.expectedDigest)) {
                this.failed = "Incorrect message digest for " + this.url + ": " + HttpmdUtil.digestString(byArray);
                this.checkFailed();
            }
        }
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkFailed();
        int n3 = this.in.read(byArray, n, n2);
        if (n3 < 0) {
            this.checkDigest();
        } else {
            this.messageDigest.update(byArray, n, n3);
        }
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        long l2;
        int n;
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[512];
        }
        for (l2 = l; l2 > 0L && (n = this.read(this.skipBuffer, 0, (int)Math.min(512L, l2))) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }

    public synchronized int available() throws IOException {
        this.checkFailed();
        return this.in.available();
    }

    public synchronized void close() throws IOException {
        this.checkFailed();
        this.in.close();
    }
}

