/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.mathworks.project.impl.logui.BufferedLogSource;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.workflowui.OutputTabDefinition;
import com.mathworks.project.impl.workflowui.OutputTabInstance;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

public final class OutputAreaModel {
    private final Project fProject;
    private final List<OutputTabInstance> fExtraTabs;
    private final BufferedLogSource fLogSource;
    private final PropertyChangeSupport fPropertySupport;
    private final boolean fLogSupported;
    private int fSelectedTabIndex;
    public static final String SELECTED_TAB_INDEX_PROPERTY = "selected-tab-index";
    public static final String EXTRA_TABS_PROPERTY = "extra-tabs";

    public OutputAreaModel(Project project, boolean bl) {
        this.fProject = project;
        this.fLogSource = new BufferedLogSource();
        this.fLogSupported = bl;
        this.fExtraTabs = new ArrayList<OutputTabInstance>();
        this.fPropertySupport = new PropertyChangeSupport(this);
    }

    public BufferedLogSource getLogSource() {
        return this.fLogSource;
    }

    public boolean isLogSupported() {
        return this.fLogSupported;
    }

    public void addExtraTab(OutputTabDefinition outputTabDefinition) {
        ArrayList<OutputTabInstance> arrayList = new ArrayList<OutputTabInstance>(this.fExtraTabs);
        this.fExtraTabs.add(new OutputTabInstance(outputTabDefinition, this.fProject));
        this.fPropertySupport.firePropertyChange(EXTRA_TABS_PROPERTY, arrayList, this.fExtraTabs);
    }

    public List<OutputTabInstance> getExtraTabs() {
        return new ArrayList<OutputTabInstance>(this.fExtraTabs);
    }

    public void dispose() {
        for (OutputTabInstance outputTabInstance : this.fExtraTabs) {
            outputTabInstance.dispose();
        }
    }

    public boolean hasExtraTabs() {
        return !this.fExtraTabs.isEmpty();
    }

    public int getSelectedTabIndex() {
        return this.fSelectedTabIndex;
    }

    public void setSelectedTabIndex(int n) {
        if (n > this.fExtraTabs.size() || n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        int n2 = this.fSelectedTabIndex;
        this.fSelectedTabIndex = n;
        this.fPropertySupport.firePropertyChange(SELECTED_TAB_INDEX_PROPERTY, n2, n);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }
}

