/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.textfield;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.project.impl.textfield.FormattedTextFieldPainter;
import com.mathworks.project.impl.textfield.Token;
import com.mathworks.services.ColorPrefs;
import com.mathworks.util.Holder;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class DefaultFormattedTextFieldPainter
implements FormattedTextFieldPainter {
    @Override
    public Map<Token, Rectangle> paint(FormattedTextField formattedTextField, final Graphics2D graphics2D) {
        Object object;
        String string;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        HashMap<Token, Rectangle> hashMap = new HashMap<Token, Rectangle>();
        final JComponent jComponent = formattedTextField.getTextComponent();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = ((Component)jComponent).getHeight() / 2 - (fontMetrics.getAscent() + fontMetrics.getDescent()) / 2 + fontMetrics.getAscent();
        int n2 = 1;
        Color color = formattedTextField.isEditable() ? ColorPrefs.getTextColor() : new Color(0xAAAAAA);
        graphics2D.setColor(UIManager.getColor("TextField.background"));
        graphics2D.fillRect(0, 0, ((Component)jComponent).getWidth(), ((Component)jComponent).getHeight());
        graphics2D.setFont(jComponent.getFont());
        if (formattedTextField.getText().length() == 0 && (string = formattedTextField.getPrompt()) != null) {
            graphics2D.setColor(new Color(100, 100, 100));
            graphics2D.drawString(string, n2, n);
        }
        graphics2D.setColor(ColorUtils.getTextSelectionBackgroundColor());
        if (!formattedTextField.isEditable() || formattedTextField.getSelectedFieldToken() == null || !this.hasBorder(formattedTextField.getSelectedFieldToken())) {
            graphics2D.fill(formattedTextField.getSelectionRect());
        }
        graphics2D.setColor(color);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        for (Token object2 : formattedTextField.getTokensWithCompletion()) {
            boolean bl;
            boolean bl3;
            boolean bl4 = bl3 = n4++ >= formattedTextField.getTokenCount();
            if (!bl2) {
                n5 = n2;
                bl2 = bl3;
            }
            object = this.maskPromptChars(object2.getText());
            final int n6 = (int)graphics2D.getFontMetrics().getStringBounds((String)object, graphics2D).getWidth();
            hashMap.put(object2, new Rectangle(n2, 0, n6, graphics2D.getFontMetrics().getHeight()));
            boolean bl5 = bl = formattedTextField.isEditable() && this.hasBorder(object2);
            if (bl) {
                final boolean bl6 = formattedTextField.isEditable() && formattedTextField.getSelectedFieldToken() == object2;
                final int n7 = n2;
                this.withAntialiasing(graphics2D, new Runnable(){

                    @Override
                    public void run() {
                        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n7, 1.0, n6 + 4, jComponent.getHeight() - 2, 10.0, 10.0);
                        graphics2D.setColor(ColorUtils.getTextSelectionBackgroundColor());
                        if (bl6) {
                            graphics2D.fill(double_);
                        }
                        graphics2D.setColor(new Color(0xAAAAAA));
                        graphics2D.draw(double_);
                    }
                });
                graphics2D.setColor(color);
                n2 += 2;
            }
            this.drawWithSelection(formattedTextField, graphics2D, color, n3, (String)object, bl3, n2, n);
            n3 += ((String)object).length();
            n2 += n6;
            if (!bl) continue;
            n2 += 4;
            ((Rectangle)hashMap.get((Object)object2)).width += 4;
        }
        if (!bl2) {
            n5 = n2;
        }
        if (formattedTextField.isEditable() && formattedTextField.getTextComponent().hasFocus() && formattedTextField.getCaret().isOn()) {
            graphics2D.setColor(color);
            Token token = formattedTextField.getTokenForCharIndex(formattedTextField.getInsertionPoint());
            if (token != null) {
                Token token2;
                String string2 = this.maskPromptChars(token.getText());
                int n8 = formattedTextField.getTokenOffsetAtCharIndex(formattedTextField.getInsertionPoint());
                object = (Rectangle)hashMap.get(token);
                String string3 = string2.substring(0, n8);
                n2 = (int)(((Rectangle)object).getX() + graphics2D.getFontMetrics().getStringBounds(string3, graphics2D).getWidth());
                if (formattedTextField.isEditable() && this.hasBorder(token)) {
                    n2 += 2;
                } else if (formattedTextField.getInsertionPoint() > 0 && (token2 = formattedTextField.getTokenForCharIndex(formattedTextField.getInsertionPoint() - 1)) != null && formattedTextField.isEditable() && this.hasBorder(token2)) {
                    n2 -= 4;
                }
            } else if (formattedTextField.getInsertionPoint() > 0) {
                Token token3 = formattedTextField.getTokenForCharIndex(formattedTextField.getInsertionPoint() - 1);
                n2 = token3 != null && formattedTextField.isEditable() && this.hasBorder(token3) ? n5 - 4 : n5;
            }
            graphics2D.drawLine(n2, 1, n2, ((Component)jComponent).getHeight() - 2);
        }
        return hashMap;
    }

    protected void drawWithSelection(FormattedTextField formattedTextField, Graphics2D graphics2D, Color color, int n, String string, boolean bl, int n2, int n3) {
        int n4 = Math.min(formattedTextField.getSelectionStart(), formattedTextField.getSelectionEnd());
        int n5 = Math.max(formattedTextField.getSelectionStart(), formattedTextField.getSelectionEnd());
        final LinkedList linkedList = new LinkedList();
        final TreeSet treeSet = new TreeSet();
        final StringBuilder stringBuilder = new StringBuilder();
        final Holder holder = new Holder((Object)false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (stringBuilder.length() > 0) {
                    linkedList.add(stringBuilder.toString());
                    if (((Boolean)holder.get()).booleanValue()) {
                        treeSet.add(stringBuilder.toString());
                    }
                    stringBuilder.setLength(0);
                }
            }
        };
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            boolean bl3 = bl2 = n + i >= n4 && n + i < n5;
            if (bl2 != (Boolean)holder.get()) {
                runnable.run();
                holder.set((Object)bl2);
            }
            stringBuilder.append(string.charAt(i));
        }
        runnable.run();
        for (String string2 : linkedList) {
            if (bl) {
                graphics2D.setColor(new Color(190, 190, 190));
            } else {
                graphics2D.setColor(treeSet.contains(string2) ? ColorUtils.getTextSelectionForegroundColor() : color);
            }
            graphics2D.drawString(string2, n2, n3);
            n2 += (int)graphics2D.getFontMetrics().getStringBounds(string2, graphics2D).getWidth();
        }
    }

    protected void withAntialiasing(Graphics2D graphics2D, Runnable runnable) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        runnable.run();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected boolean hasBorder(Token token) {
        return false;
    }

    protected boolean isPromptChar(char c) {
        return false;
    }

    protected String maskPromptChars(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (this.isPromptChar(string.charAt(i))) {
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }
}

