/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.RowPaintContext;
import com.mathworks.util.Converter;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public final class MutablePaintContext<T>
implements Cloneable {
    public Runnable deferredCode;
    public Component component;
    public Graphics2D graphics;
    public T value;
    public String text;
    public JComponent link;
    public Integer rowIndex;
    public Integer nestLevel;
    public Integer expansionPhase;
    public Integer columnCount;
    public Boolean isLeaf;
    public Boolean isExpandable;
    public Boolean isExpanded;
    public Boolean isSelectingExpandableRowsAllowed;
    public Boolean isDisabled;
    public Boolean isFocused;
    public Boolean isSelected;
    public Boolean isPressed;
    public Boolean isNonDefault;
    public Boolean isFiniteValue;
    public Boolean matchesSearch;
    public String searchText;
    public Integer markedRowIndex;
    public Integer lineHeight;
    public Double dataChangePhase;
    public Integer columnIndex;
    public Rectangle2D rowRect;
    public Rectangle2D cellRect;
    public PropertyTableColumn<T> column;
    public Converter<Integer, Rectangle2D> cellRects;
    public Map<PropertyTableHighlighter<T>, Double> highlighters;
    private ImmutableRowContext fRowContext = new ImmutableRowContext();
    private ImmutableCellContext fCellContext = new ImmutableCellContext();

    public RowPaintContext<T> getRowContext() {
        return this.fRowContext;
    }

    public CellPaintContext<T> getCellContext() {
        return this.fCellContext;
    }

    public MutablePaintContext<T> clone() {
        try {
            MutablePaintContext mutablePaintContext = (MutablePaintContext)super.clone();
            mutablePaintContext.fRowContext = new ImmutableRowContext();
            mutablePaintContext.fCellContext = new ImmutableCellContext();
            return mutablePaintContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    private class ImmutableCellContext
    extends ImmutableRowContext
    implements CellPaintContext<T> {
        private ImmutableCellContext() {
        }

        @Override
        public CellPaintContext<T> clone() {
            return ((MutablePaintContext)MutablePaintContext.this.clone()).getCellContext();
        }

        @Override
        public void afterTablePainted(final Runnable runnable) {
            final Runnable runnable2 = MutablePaintContext.this.deferredCode;
            MutablePaintContext.this.deferredCode = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                }
            };
        }

        @Override
        public String getText() {
            return MutablePaintContext.this.text;
        }

        @Override
        public JComponent getLink() {
            return MutablePaintContext.this.link;
        }

        @Override
        public boolean isDisabled() {
            return MutablePaintContext.this.isDisabled;
        }

        @Override
        public boolean isFiniteValue() {
            return MutablePaintContext.this.isFiniteValue;
        }

        @Override
        public boolean isNonDefault() {
            return MutablePaintContext.this.isNonDefault;
        }

        @Override
        public boolean matchesSearch() {
            return MutablePaintContext.this.matchesSearch;
        }

        @Override
        public String getSearchText() {
            return MutablePaintContext.this.searchText;
        }

        @Override
        public Rectangle2D getCellRect() {
            return MutablePaintContext.this.cellRect;
        }

        @Override
        public int getColumnIndex() {
            return MutablePaintContext.this.columnIndex;
        }

        @Override
        public double getDataChangePhase() {
            return MutablePaintContext.this.dataChangePhase;
        }

        @Override
        public PropertyTableColumn<T> getColumn() {
            return MutablePaintContext.this.column;
        }

        @Override
        public CellPaintContext<T> withoutHighlight() {
            Object object = MutablePaintContext.this.clone();
            ((MutablePaintContext)object).highlighters = new HashMap(0);
            return ((MutablePaintContext)object).getCellContext();
        }
    }

    private class ImmutableRowContext
    implements RowPaintContext<T> {
        private ImmutableRowContext() {
        }

        @Override
        public Component getComponent() {
            return MutablePaintContext.this.component;
        }

        @Override
        public Graphics2D getGraphics() {
            return MutablePaintContext.this.graphics;
        }

        @Override
        public T getValue() {
            return MutablePaintContext.this.value;
        }

        @Override
        public int getRowIndex() {
            return MutablePaintContext.this.rowIndex;
        }

        @Override
        public int getNestLevel() {
            return MutablePaintContext.this.nestLevel;
        }

        @Override
        public int getExpansionPhase() {
            return MutablePaintContext.this.expansionPhase;
        }

        @Override
        public int getColumnCount() {
            return MutablePaintContext.this.columnCount;
        }

        @Override
        public boolean isLeaf() {
            return MutablePaintContext.this.isLeaf;
        }

        @Override
        public boolean isExpandable() {
            return MutablePaintContext.this.isExpandable;
        }

        @Override
        public boolean isExpanded() {
            return MutablePaintContext.this.isExpanded;
        }

        @Override
        public boolean isSelectingExandableRowsAllowed() {
            return MutablePaintContext.this.isSelectingExpandableRowsAllowed;
        }

        @Override
        public boolean isFocused() {
            return MutablePaintContext.this.isFocused;
        }

        @Override
        public boolean isSelected() {
            return MutablePaintContext.this.isSelected;
        }

        @Override
        public boolean isPressed() {
            return MutablePaintContext.this.isPressed;
        }

        @Override
        public Rectangle2D getRowRect() {
            return MutablePaintContext.this.rowRect;
        }

        @Override
        public Rectangle2D getCellRect(int n) {
            return (Rectangle2D)MutablePaintContext.this.cellRects.convert((Object)n);
        }

        @Override
        public int getLineHeight() {
            return MutablePaintContext.this.lineHeight;
        }

        @Override
        public double getHighlightPhase(PropertyTableHighlighter<T> propertyTableHighlighter) {
            return MutablePaintContext.this.highlighters.get(propertyTableHighlighter);
        }

        @Override
        public Collection<PropertyTableHighlighter<T>> getHighlighters() {
            return MutablePaintContext.this.highlighters.keySet();
        }

        @Override
        public int getMarkedRowIndex() {
            return MutablePaintContext.this.markedRowIndex;
        }

        @Override
        public RowPaintContext<T> withoutHighlight() {
            Object object = MutablePaintContext.this.clone();
            ((MutablePaintContext)object).highlighters = new HashMap(0);
            return ((MutablePaintContext)object).getRowContext();
        }
    }
}

