/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.table;

import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.table.AbstractMacPopupCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;

public final class MacFiniteValueCellEditor
extends AbstractMacPopupCellEditor<Param> {
    private final PropertyTable<Param> fTable;
    private final Configuration fConfiguration;
    private final Param fParam;

    public MacFiniteValueCellEditor(PropertyTable<Param> propertyTable, int n, int n2, Configuration configuration, Param param) {
        super(propertyTable, n, n2);
        this.fConfiguration = configuration;
        this.fTable = propertyTable;
        this.fParam = param;
    }

    @Override
    protected List<JMenuItem> createFiniteValueItems() {
        LinkedList<JMenuItem> linkedList = new LinkedList<JMenuItem>();
        PropertyTableModel<Param> propertyTableModel = this.fTable.getModel();
        if (this.fParam.getType() == ParamType.BOOLEAN) {
            MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem(BuiltInResources.getString("param.boolean.true"));
            mJCheckBoxMenuItem.setName("value." + this.fParam.getKey() + ".true");
            mJCheckBoxMenuItem.setFont(this.fTable.getFont());
            mJCheckBoxMenuItem.setSelected(this.fConfiguration.getParamAsBoolean(this.fParam.getKey()));
            mJCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MacFiniteValueCellEditor.this.fConfiguration.setParamAsBoolean(MacFiniteValueCellEditor.this.fParam.getKey(), true);
                }
            });
            MJCheckBoxMenuItem mJCheckBoxMenuItem2 = new MJCheckBoxMenuItem(BuiltInResources.getString("param.boolean.false"));
            mJCheckBoxMenuItem2.setFont(this.fTable.getFont());
            mJCheckBoxMenuItem2.setName("value." + this.fParam.getKey() + ".false");
            mJCheckBoxMenuItem2.setSelected(!this.fConfiguration.getParamAsBoolean(this.fParam.getKey()));
            mJCheckBoxMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MacFiniteValueCellEditor.this.fConfiguration.setParamAsBoolean(MacFiniteValueCellEditor.this.fParam.getKey(), false);
                }
            });
            linkedList.add((JMenuItem)mJCheckBoxMenuItem);
            linkedList.add((JMenuItem)mJCheckBoxMenuItem2);
        } else if (this.fParam.getType() == ParamType.ENUM) {
            Map<String, String> map = this.fParam.getOptionExpression() != null ? this.fConfiguration.getParamOptions(this.fParam.getKey()).getOptions() : this.fParam.getOptions();
            for (final Map.Entry entry : map.entrySet()) {
                MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem((String)entry.getValue());
                mJCheckBoxMenuItem.setName("option." + this.fParam.getKey() + "." + (String)entry.getKey());
                mJCheckBoxMenuItem.setFont(this.fTable.getFont());
                mJCheckBoxMenuItem.setSelected(this.fConfiguration.getParamAsString(this.fParam.getKey()).equals(entry.getKey()));
                mJCheckBoxMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MacFiniteValueCellEditor.this.fConfiguration.setParamAsString(MacFiniteValueCellEditor.this.fParam.getKey(), (String)entry.getKey());
                    }
                });
                linkedList.add((JMenuItem)mJCheckBoxMenuItem);
            }
        }
        return linkedList;
    }
}

