/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.toolstrip.components.TSTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ToolstripTextFieldWidget
extends AbstractParamWidget<String> {
    private static final Color ERROR_COLOR = new Color(255, 200, 200);
    private TSTextField fTextField = new TSTextField(12){

        public Dimension getPreferredSize() {
            return new Dimension(180, 22);
        }
    };
    private String fTooltip;
    private boolean fHasError;

    public ToolstripTextFieldWidget(Param param, Project project) {
        this.fTextField.setFont(this.fTextField.getFont().deriveFont(12.0f));
        this.fTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ToolstripTextFieldWidget.this.fireListeners();
            }
        });
        this.fTextField.setName(param.getKey() + ".field");
        DetailedToolTip.install((Component)this.fTextField, project.getConfiguration(), param);
        this.fTooltip = this.fTextField.getToolTipText();
        this.fTextField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (ToolstripTextFieldWidget.this.fHasError) {
                    ToolstripTextFieldWidget.this.fTextField.setBackground(ERROR_COLOR);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (ToolstripTextFieldWidget.this.fHasError) {
                    ToolstripTextFieldWidget.this.fTextField.setBackground(ERROR_COLOR);
                }
            }
        });
    }

    @Override
    public boolean showValidationMessage(ValidationMessage validationMessage) {
        if (validationMessage.getSeverity().equals((Object)Severity.ERROR)) {
            this.fHasError = true;
            this.fTextField.setBackground(ERROR_COLOR);
            this.fTextField.setToolTipText(validationMessage.getText());
        }
        return this.fHasError;
    }

    @Override
    public void clearValidationMessage() {
        this.fHasError = false;
        this.fTextField.setBackground(new Color(248, 248, 248));
        this.fTextField.setToolTipText(this.fTooltip);
    }

    public void setEnabled(boolean bl) {
    }

    public void setData(String string) {
        this.fTextField.setText(string);
        this.fireListeners();
    }

    public String getData() {
        return this.fTextField.getText();
    }

    public Component getComponent() {
        return this.fTextField;
    }
}

