/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ProjectManager;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ResourceManager {
    public static final String RESOURCES = "_resources";
    private Configuration fConfig;
    private File fResourceDirectory;
    private Set<ChangeListener> fChangeListeners = new HashSet<ChangeListener>();
    private Set<String> fParamKeys = new HashSet<String>();

    public ResourceManager(Configuration configuration) {
        this.fConfig = configuration;
    }

    public void addListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    public void removeListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }

    private void changeEvent() {
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void addParam(String string) {
        if (string != null) {
            this.fParamKeys.add(string);
        }
    }

    public void removeParam(String string) {
        if (string != null) {
            this.fParamKeys.remove(string);
        }
    }

    public boolean isManaged(String string) {
        return string != null && this.fParamKeys.contains(string);
    }

    public synchronized File getResourceDirectory() {
        return this.fResourceDirectory;
    }

    public synchronized void createResourceDirectory() {
        ProjectManager.installAutoSave(this.fConfig.getProject());
        ProjectManager.forceSave(this.fConfig.getProject());
        this.getResourceDirectory().mkdir();
    }

    public synchronized void refreshResourceDirectory() throws Exception {
        File file = this.fConfig.getFile();
        String string = file.getName();
        if (string.indexOf(".prj") != -1) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        File file2 = new File(file.getParent(), string + RESOURCES);
        if (this.fResourceDirectory != null && this.fResourceDirectory.exists() && !this.fResourceDirectory.getName().equals(file2.getName())) {
            this.fResourceDirectory.renameTo(file2);
        }
        this.fResourceDirectory = file2;
        this.changeEvent();
    }

    public synchronized File getResource(String string) {
        return new File(this.fResourceDirectory, string);
    }
}

