/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestFilter;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ParamWidgetBinder {
    private final Stack<String> fChangingParamKeys = new Stack();
    private final Map<String, ParamWidget<?>> fWidgets;
    private final Map<String, MJLabel> fLabels;
    private final Project fProject;
    private final PropertyChangeListener fConfigurationListener;
    private final RequestFilter fValidator;
    private final boolean fInline;
    private volatile String fCurrentEdtChangeParam;

    public ParamWidgetBinder(Project project, boolean bl) {
        this.fProject = project;
        this.fWidgets = new HashMap();
        this.fLabels = new HashMap<String, MJLabel>();
        this.fInline = bl;
        this.fValidator = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                final Map map = ParamWidgetBinder.this.map(ParamWidgetBinder.this.fProject.getConfiguration().getTarget().validate(ParamWidgetBinder.this.fProject));
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry entry : ParamWidgetBinder.this.fWidgets.entrySet()) {
                            ValidationMessage validationMessage = (ValidationMessage)map.get(entry.getKey());
                            if (validationMessage != null) {
                                ((ParamWidget)entry.getValue()).showValidationMessage(validationMessage);
                                continue;
                            }
                            ((ParamWidget)entry.getValue()).clearValidationMessage();
                        }
                    }
                });
            }
        }, 200);
        this.fValidator.setName("Project param validator for binder " + this);
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                ParamWidgetBinder.this.fValidator.request();
                Param param = ParamWidgetBinder.this.fProject.getConfiguration().getChangedParam(propertyChangeEvent);
                if (param != null) {
                    ParamWidgetBinder.this.paramValueChanged(param, propertyChangeEvent.getNewValue());
                } else if (Configuration.isParamEnabledChange(propertyChangeEvent)) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MJLabel mJLabel;
                            Param param = ParamWidgetBinder.this.fProject.getConfiguration().getParamWithAffectedState(propertyChangeEvent);
                            ParamWidget paramWidget = (ParamWidget)ParamWidgetBinder.this.fWidgets.get(param.getKey());
                            if (paramWidget != null) {
                                paramWidget.setEnabled(propertyChangeEvent.getNewValue().equals(true));
                            }
                            if ((mJLabel = (MJLabel)ParamWidgetBinder.this.fLabels.get(param.getKey())) != null) {
                                mJLabel.setEnabled(propertyChangeEvent.getNewValue().equals(true));
                            }
                        }
                    });
                }
            }
        };
        this.fProject.getConfiguration().addPropertyChangeListener(this.fConfigurationListener);
    }

    private Map<String, ValidationMessage> map(List<ValidationMessage> list) {
        HashMap<String, ValidationMessage> hashMap = new HashMap<String, ValidationMessage>();
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.getParamKey() == null) continue;
            if (this.fProject.getConfiguration().getTarget().getParam(validationMessage.getParamKey()) == null) {
                throw new IllegalStateException("Validator generated message '" + validationMessage.getText() + "' directed to unrecognized param key: " + validationMessage.getParamKey() + ". This is probably a misspelling in the validation code.");
            }
            hashMap.put(validationMessage.getParamKey(), validationMessage);
        }
        return hashMap;
    }

    public void dispose() {
        this.fProject.getConfiguration().removePropertyChangeListener(this.fConfigurationListener);
        this.fValidator.cancelPendingRequests();
        this.disposeWidgets();
    }

    public void disposeWidgets() {
        for (ParamWidget<?> paramWidget : this.fWidgets.values()) {
            paramWidget.dispose();
        }
        this.fWidgets.clear();
    }

    public boolean hasWidget(Param param) {
        return this.fWidgets.containsKey(param.getKey());
    }

    public ParamWidget get(Param param) {
        return this.fWidgets.get(param.getKey());
    }

    public void register(final Param param, final ParamWidget paramWidget) {
        paramWidget.setData(this.fProject.getConfiguration().getParamAsObject(param.getKey()));
        paramWidget.setEnabled(this.fProject.getConfiguration().isParamEnabled(param.getKey()));
        paramWidget.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ParamWidgetBinder.this.fCurrentEdtChangeParam == null || !ParamWidgetBinder.this.fCurrentEdtChangeParam.equals(param.getKey())) {
                    ParamWidgetBinder.this.fChangingParamKeys.push(param.getKey());
                    ParamWidgetBinder.this.fProject.getConfiguration().setParamAsObject(param.getKey(), paramWidget.getData());
                    ParamWidgetBinder.this.fChangingParamKeys.pop();
                }
            }
        });
        this.fWidgets.put(param.getKey(), paramWidget);
        this.fValidator.cancelPendingRequests();
        this.fValidator.request();
    }

    public Component createAndRegister(Param param) {
        ParamWidget<?> paramWidget = param.getType().createWidget(param, this.fProject, this.fInline);
        this.fWidgets.put(param.getKey(), paramWidget);
        this.register(param, paramWidget);
        return paramWidget.getComponent();
    }

    public Component createWithLabelAndRegister(Param param) {
        Component component = this.createAndRegister(param);
        MJLabel mJLabel = this.createLabel(param);
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0, 3, 0));
        mJPanel.setOpaque(false);
        mJPanel.add((Component)mJLabel);
        mJPanel.add(component);
        return mJPanel;
    }

    public Component createOrGet(Param param) {
        ParamWidget<?> paramWidget = this.fWidgets.get(param.getKey());
        if (paramWidget != null) {
            return paramWidget.getComponent();
        }
        return this.createAndRegister(param);
    }

    public Component createWithLabelAboveAndRegister(Param param) {
        Component component = this.createAndRegister(param);
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(2, 1));
        mJPanel.setOpaque(false);
        MJLabel mJLabel = this.createLabel(param);
        mJPanel.add((Component)mJLabel);
        mJPanel.add(component);
        return mJPanel;
    }

    private MJLabel createLabel(Param param) {
        MJLabel mJLabel = new MJLabel(param.getName());
        if (PlatformInfo.isMacintosh()) {
            mJLabel.setBorder((Border)new EmptyBorder(0, 4, 0, 0));
        }
        mJLabel.setEnabled(this.fProject.getConfiguration().isParamEnabled(param.getKey()));
        this.fLabels.put(param.getKey(), mJLabel);
        return mJLabel;
    }

    private void paramValueChanged(final Param param, final Object object) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ParamWidgetBinder.this.fChangingParamKeys.contains(param.getKey())) {
                    ParamWidgetBinder.this.fCurrentEdtChangeParam = param.getKey();
                    ParamWidget paramWidget = (ParamWidget)ParamWidgetBinder.this.fWidgets.get(param.getKey());
                    if (paramWidget != null) {
                        paramWidget.setData(object);
                    }
                    ParamWidgetBinder.this.fCurrentEdtChangeParam = null;
                }
            }
        });
    }
}

