/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.settingsui.NavigationBar;
import com.mathworks.project.impl.settingsui.ParamSetPanel;
import com.mathworks.project.impl.settingsui.SettingsTabbedPane;
import com.mathworks.project.impl.settingsui.table.NameColumn;
import com.mathworks.project.impl.settingsui.table.SettingsTableUtils;
import com.mathworks.project.impl.settingsui.table.ValueColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.util.Converter;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SearchTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class NewSettingsDialog {
    private final MJFrame fFrame;
    private final WindowFocusListener fFocusListener;
    private final Project fProject;
    private final List<ParamSetPanel> fPanels;
    private final JPanel fButtons;
    private final Configuration fConfiguration;
    private final MainArea fMainArea;
    private final MJButton fHelpButton;
    private final Map<Component, ParamSet> fComponentParamSets;
    private final NavigationBar fNavigationBar;
    private final PropertyChangeListener fPropertyChangeListener;
    private final MulticastChangeListener fChangeListeners;
    private final ProjectComponent fExtraPanel;
    private final List<Runnable> fCloseCallbacks;
    private final Set<String> fSuppressedParamSets;
    private final SearchTextField fSearchTextField;
    private final SearchTextField.Listener fSearchListener;
    private MJPanel fTablePanel;
    private PropertyTable<Param> fAllSettingsTable;
    private int fMaxPreferredWidth;
    private int fMaxPreferredHeight;
    private Component fSelectedComponent;
    private ParamSet fCurrentParamSet;
    private boolean fDisposed;
    private static Map<Project, NewSettingsDialog> sOpenDialogs = new HashMap<Project, NewSettingsDialog>();
    private static NewSettingsDialog sActiveDialog;
    private static final Color MAC_BACKGROUND_COLOR;

    public static NewSettingsDialog invoke() {
        return NewSettingsDialog.invoke(ProjectGUI.getInstance().getCurrentProject());
    }

    public static NewSettingsDialog invoke(Project project) {
        NewSettingsDialog newSettingsDialog = sOpenDialogs.get(project);
        if (newSettingsDialog == null) {
            newSettingsDialog = new NewSettingsDialog(project, null, null);
            sOpenDialogs.put(project, newSettingsDialog);
        }
        newSettingsDialog.show();
        return newSettingsDialog;
    }

    public static void invokeAndSelect(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (sActiveDialog != null) {
                    sActiveDialog.fNavigationBar.select(string);
                }
            }
        });
    }

    public static NewSettingsDialog invokeTemporaryProject(Project project, String[] stringArray, String string, final String string2, final Object ... objectArray) {
        NewSettingsDialog newSettingsDialog = sOpenDialogs.get(project);
        if (newSettingsDialog == null) {
            DynamicTargetAttribute dynamicTargetAttribute;
            ProjectComponent projectComponent = null;
            if (string != null && string.length() > 0) {
                try {
                    projectComponent = (ProjectComponent)Class.forName(string).getConstructor(Configuration.class).newInstance(project.getConfiguration());
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
            newSettingsDialog = new NewSettingsDialog(project, projectComponent, stringArray);
            if (string2 != null) {
                newSettingsDialog.addCloseCallback(new Runnable(){

                    @Override
                    public void run() {
                        new Matlab().fevalConsoleOutput(string2, objectArray);
                    }
                });
            }
            if ((dynamicTargetAttribute = project.getConfiguration().getTarget().getProjectWindowTitle()) != null) {
                String string3 = project.getConfiguration().getProjectWindowTitle();
                newSettingsDialog.fFrame.setTitle(string3);
            }
        }
        newSettingsDialog.show();
        return newSettingsDialog;
    }

    private NewSettingsDialog(Project project, ProjectComponent projectComponent, String[] stringArray) {
        this.fProject = project;
        this.fExtraPanel = projectComponent;
        this.fPanels = new ArrayList<ParamSetPanel>();
        this.fChangeListeners = new MulticastChangeListener();
        this.fMainArea = new MainArea();
        this.fCloseCallbacks = new LinkedList<Runnable>();
        this.fSuppressedParamSets = new HashSet<String>();
        if (stringArray != null) {
            this.fSuppressedParamSets.addAll(Arrays.asList(stringArray));
        }
        if (PlatformInfo.isMacintosh()) {
            this.fMainArea.setBackground(MAC_BACKGROUND_COLOR);
            this.fMainArea.setOpaque(true);
        }
        this.fComponentParamSets = new HashMap<Component, ParamSet>();
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("@settings-dialog-height") || propertyChangeEvent.getPropertyName().equals("@settings-dialog-width")) {
                    NewSettingsDialog.this.autoResizeDialog();
                } else if (Configuration.isParamSetVisibilityChange(propertyChangeEvent)) {
                    NewSettingsDialog.this.updateNavigationBar();
                }
            }
        };
        this.fFocusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                sActiveDialog = NewSettingsDialog.this;
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                if (sActiveDialog == NewSettingsDialog.this) {
                    sActiveDialog = null;
                }
            }
        };
        this.fFrame = new MJFrame();
        this.fFrame.setName("settings.dialog");
        this.fFrame.setTitle(BuiltInResources.getString("projectsettings.title"));
        this.fFrame.addWindowFocusListener(this.fFocusListener);
        this.fConfiguration = project.getConfiguration();
        this.fNavigationBar = new NavigationBar(new ParameterRunnable<Component>(){

            public void run(Component component) {
                if (NewSettingsDialog.this.fAllSettingsTable != null) {
                    NewSettingsDialog.this.fAllSettingsTable.stopEditing(PlatformInfo.isMacintosh());
                }
                NewSettingsDialog.this.select(component);
            }
        });
        this.fSearchTextField = new SearchTextField("");
        this.fSearchTextField.getComponent().setName("settings.search.field");
        this.fSearchTextField.setPromptText(BuiltInResources.getString("settings.search.prompt"));
        this.buildNavigationBar();
        this.fSearchListener = new SearchTextField.Listener(){

            public void search(String string) {
            }

            public void searchTextChanged(String string) {
                NewSettingsDialog.this.fAllSettingsTable.stopEditing(PlatformInfo.isMacintosh());
                NewSettingsDialog.this.fAllSettingsTable.setSearchText(string);
                NewSettingsDialog.this.fAllSettingsTable.getComponent().revalidate();
                NewSettingsDialog.this.fAllSettingsTable.getComponent().repaint();
            }

            public void searchCleared() {
            }
        };
        this.fSearchTextField.addSearchTextFieldListener(this.fSearchListener);
        MJButton mJButton = new MJButton(BuiltInResources.getString("button.close"));
        mJButton.setName("settings.close");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewSettingsDialog.this.fAllSettingsTable.stopEditing(false);
                NewSettingsDialog.this.close();
            }
        });
        this.fHelpButton = new MJHelpButton();
        this.fHelpButton.setName("settings.help");
        this.fHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Target target = NewSettingsDialog.this.fConfiguration.getTarget();
                String string = PluginManager.resolveHelpMapPath(target.getHelpMapPath());
                String string2 = null;
                if (NewSettingsDialog.this.fCurrentParamSet != null) {
                    string2 = NewSettingsDialog.this.fConfiguration.evaluateString(NewSettingsDialog.this.fCurrentParamSet.getHelpTopicKey());
                }
                if (string2 == null && target.getSettingsHelpKeyGeneratorClassName() != null) {
                    try {
                        Class<?> clazz = Class.forName(target.getSettingsHelpKeyGeneratorClassName());
                        Constructor<?> constructor = clazz.getConstructor(Configuration.class);
                        Converter converter = (Converter)constructor.newInstance(NewSettingsDialog.this.fConfiguration);
                        string2 = (String)converter.convert((Object)NewSettingsDialog.this.fCurrentParamSet);
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                }
                MLHelpServices.cshDisplayTopic((Object)NewSettingsDialog.this.fFrame, (String)string, string2);
            }
        });
        if (PlatformInfo.isMacintosh()) {
            this.fHelpButton.putClientProperty((Object)"JButton.buttonType", (Object)"help");
            this.fButtons = new MJPanel((LayoutManager)new FlowLayout(2, 8, 8));
            this.fButtons.setBackground(MAC_BACKGROUND_COLOR);
            this.fButtons.setOpaque(true);
            this.fButtons.add((Component)this.fHelpButton);
        } else {
            this.fButtons = ButtonBarFactory.buildCloseHelpBar((JButton)mJButton, (JButton)this.fHelpButton);
        }
        if (PlatformInfo.isMacintosh()) {
            this.fFrame.add((Component)this.fNavigationBar.getComponent(), (Object)"North");
            this.fFrame.add(NewSettingsDialog.integrateExtraPanel((Component)((Object)this.fMainArea), projectComponent), (Object)"Center");
            this.fFrame.add((Component)this.fButtons, (Object)"South");
        } else {
            CellConstraints cellConstraints = new CellConstraints();
            this.fFrame.setLayout((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "fill:p, fill:d:grow, 3dlu, fill:d, 3dlu"));
            this.fFrame.add((Component)this.fNavigationBar.getComponent(), (Object)cellConstraints.xyw(1, 1, 3));
            this.fFrame.add(NewSettingsDialog.integrateExtraPanel((Component)((Object)this.fMainArea), projectComponent), (Object)cellConstraints.xyw(1, 2, 3));
            this.fFrame.add((Component)this.fButtons, (Object)cellConstraints.xy(2, 4));
        }
        this.fFrame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewSettingsDialog.this.fDisposed = true;
                sOpenDialogs.remove(NewSettingsDialog.this.fProject);
                NewSettingsDialog.this.fFrame.removeWindowFocusListener(NewSettingsDialog.this.fFocusListener);
                for (Object object : NewSettingsDialog.this.fPanels) {
                    ((ParamSetPanel)object).dispose();
                }
                NewSettingsDialog.this.fPanels.clear();
                if (NewSettingsDialog.this.fExtraPanel != null) {
                    NewSettingsDialog.this.fExtraPanel.dispose();
                }
                NewSettingsDialog.this.fNavigationBar.dispose();
                NewSettingsDialog.this.fComponentParamSets.clear();
                NewSettingsDialog.this.fConfiguration.removePropertyChangeListener(NewSettingsDialog.this.fPropertyChangeListener);
                NewSettingsDialog.this.fAllSettingsTable.dispose();
                for (Object object : NewSettingsDialog.this.fCloseCallbacks) {
                    object.run();
                }
                NewSettingsDialog.this.fCloseCallbacks.clear();
                NewSettingsDialog.this.fSearchTextField.removeSearchTextFieldListener(NewSettingsDialog.this.fSearchListener);
                Component component = NewSettingsDialog.this.fFrame.getFocusOwner();
                if (component != null && component instanceof JFormattedTextField && component.getParent() != null && component.getParent() instanceof JSpinner.DefaultEditor) {
                    try {
                        ((JSpinner.DefaultEditor)component.getParent()).commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (sActiveDialog == NewSettingsDialog.this) {
                    sActiveDialog = null;
                }
                NewSettingsDialog.this.fSelectedComponent = null;
                NewSettingsDialog.this.fFrame.dispose();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (!NewSettingsDialog.this.fDisposed) {
                    this.windowClosing(windowEvent);
                }
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                NewSettingsDialog.this.fFrame.repaint();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                NewSettingsDialog.this.fFrame.repaint();
            }
        });
        this.fConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        this.autoResizeDialog();
        this.fFrame.setLocationRelativeTo((Component)MatlabDesktopServices.getDesktop().getMainFrame());
        this.fFrame.setVisible(true);
    }

    public void close() {
        this.fFrame.removeWindowFocusListener(this.fFocusListener);
        this.fFrame.dispose();
    }

    public static void close(Project project) {
        NewSettingsDialog newSettingsDialog = sOpenDialogs.get(project);
        if (newSettingsDialog != null) {
            newSettingsDialog.close();
            sOpenDialogs.remove(project);
        }
    }

    public void show() {
        this.fFrame.show();
    }

    private static Component integrateExtraPanel(final Component component, final ProjectComponent projectComponent) {
        if (projectComponent == null) {
            return component;
        }
        MJPanel mJPanel = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                Dimension dimension = projectComponent.getComponent().getPreferredSize();
                component.setBounds(0, 0, this.getWidth(), this.getHeight() - dimension.height - 1);
                projectComponent.getComponent().setBounds(0, this.getHeight() - dimension.height, this.getWidth(), dimension.height);
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Dimension dimension = projectComponent.getComponent().getPreferredSize();
                graphics.setColor(new Color(175, 175, 175));
                graphics.drawLine(0, this.getHeight() - dimension.height - 1, this.getWidth(), this.getHeight() - dimension.height - 1);
            }
        };
        mJPanel.setLayout(null);
        if (PlatformInfo.isMacintosh()) {
            mJPanel.setBackground(MAC_BACKGROUND_COLOR);
            mJPanel.setOpaque(true);
        }
        mJPanel.add(component);
        mJPanel.add(projectComponent.getComponent());
        return mJPanel;
    }

    private void select(Component component) {
        Component component2 = this.fSelectedComponent;
        this.fCurrentParamSet = this.fComponentParamSets.get(component);
        this.fSelectedComponent = component;
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
        if (component2 != null) {
            this.fMainArea.remove(component2);
        }
        this.fMainArea.add(this.fSelectedComponent, "Center");
        this.fMainArea.revalidate();
        this.fMainArea.repaint();
    }

    private void autoResizeDialog() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Dimension dimension = NewSettingsDialog.this.fNavigationBar.getComponent().getPreferredSize();
                int n = (int)Math.max((double)(NewSettingsDialog.this.fMaxPreferredWidth + (PlatformInfo.isLinux() ? 16 : 10)), Math.max((double)NewSettingsDialog.this.fConfiguration.getSettingsDialogWidth(), dimension.getWidth()));
                int n2 = (int)Math.max((double)NewSettingsDialog.this.fConfiguration.getSettingsDialogHeight(), dimension.getHeight() + (double)NewSettingsDialog.this.fMaxPreferredHeight + NewSettingsDialog.this.fButtons.getPreferredSize().getHeight());
                if (NewSettingsDialog.this.fExtraPanel != null) {
                    n2 = (int)((double)n2 + (NewSettingsDialog.this.fExtraPanel.getComponent().getPreferredSize().getHeight() + (double)(PlatformInfo.isMacintosh() ? 5 : 20)));
                }
                NewSettingsDialog.this.fFrame.getContentPane().setPreferredSize(new Dimension(n, n2));
                NewSettingsDialog.this.fFrame.pack();
                NewSettingsDialog.this.fFrame.setMinimumSize(NewSettingsDialog.this.fFrame.getSize());
            }
        });
    }

    public void addCloseCallback(Runnable runnable) {
        this.fCloseCallbacks.add(runnable);
    }

    private List<ParamSet> buildNavigationBar() {
        Object object;
        ArrayList<ParamSet> arrayList = new ArrayList<ParamSet>();
        for (ParamSet object22 : this.fConfiguration.getTarget().getParamSets()) {
            if (this.fSuppressedParamSets.contains(object22.getKey()) || !this.fConfiguration.isParamSetVisible(object22.getKey())) continue;
            arrayList.add(object22);
            if (object22.getIcon() == null) continue;
            object = new ParamSetPanel(this.fProject, object22, false, false);
            this.fPanels.add((ParamSetPanel)object);
            Component component = ((ParamSetPanel)object).getComponent();
            Dimension dimension = component.getPreferredSize();
            this.fMaxPreferredWidth = (int)Math.max((double)this.fMaxPreferredWidth, dimension.getWidth());
            this.fMaxPreferredHeight = (int)Math.max((double)this.fMaxPreferredHeight, dimension.getHeight());
            this.fComponentParamSets.put(component, object22);
            this.fNavigationBar.addElement(-1, object22.getKey(), object22.getName(), object22.getIcon(), component);
        }
        NameColumn nameColumn = new NameColumn();
        ValueColumn valueColumn = new ValueColumn(this.fConfiguration);
        object = new CellConstraints();
        this.fAllSettingsTable = SettingsTableUtils.createTable(this.fProject, arrayList, Arrays.asList(nameColumn, valueColumn));
        this.fAllSettingsTable.getComponent().setName("settings.table");
        this.fTablePanel = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu, fill:d:grow"));
        this.fTablePanel.setOpaque(false);
        this.fTablePanel.add((Component)this.fAllSettingsTable.getComponent(), (Object)object.xyw(1, 4, 3));
        this.fTablePanel.add((Component)this.fSearchTextField.getComponent(), (Object)object.xy(2, 2));
        this.fNavigationBar.addElement(-1, "settings.all", BuiltInResources.getString("settings.all"), new ImageIcon(this.getClass().getResource("/com/mathworks/project/impl/resources/all_settings.png")), (Component)this.fTablePanel);
        return arrayList;
    }

    private ParamSetPanel findOrCreatePanel(ParamSet paramSet, int n) {
        for (ParamSetPanel paramSetPanel : this.fPanels) {
            if (!paramSetPanel.getParamSet().getKey().equals(paramSet.getKey())) continue;
            return paramSetPanel;
        }
        ParamSetPanel paramSetPanel = new ParamSetPanel(this.fProject, paramSet, false, false);
        this.fPanels.add(n, paramSetPanel);
        return paramSetPanel;
    }

    private boolean removePanel(ParamSet paramSet) {
        Iterator<ParamSetPanel> iterator = this.fPanels.iterator();
        while (iterator.hasNext()) {
            ParamSetPanel paramSetPanel = iterator.next();
            if (!paramSetPanel.getParamSet().getKey().equals(paramSet.getKey())) continue;
            iterator.remove();
            paramSetPanel.dispose();
            this.fComponentParamSets.remove(paramSetPanel.getComponent());
            return true;
        }
        return false;
    }

    private void updateNavigationBar() {
        this.fMaxPreferredWidth = 0;
        this.fMaxPreferredHeight = 0;
        LinkedList<Runnable> linkedList = new LinkedList<Runnable>();
        ArrayList<ParamSet> arrayList = new ArrayList<ParamSet>();
        int n = 0;
        for (final ParamSet paramSet : this.fConfiguration.getTarget().getParamSets()) {
            if (!this.fSuppressedParamSets.contains(paramSet.getKey()) && this.fConfiguration.isParamSetVisible(paramSet.getKey())) {
                arrayList.add(paramSet);
                if (paramSet.getIcon() == null) continue;
                ParamSetPanel paramSetPanel = this.findOrCreatePanel(paramSet, n);
                final Component component = paramSetPanel.getComponent();
                Dimension dimension = component.getPreferredSize();
                this.fMaxPreferredWidth = (int)Math.max((double)this.fMaxPreferredWidth, dimension.getWidth());
                this.fMaxPreferredHeight = (int)Math.max((double)this.fMaxPreferredHeight, dimension.getHeight());
                final int n2 = n;
                if (!this.fComponentParamSets.containsKey(component)) {
                    this.fComponentParamSets.put(component, paramSet);
                    linkedList.add(new Runnable(){

                        @Override
                        public void run() {
                            NewSettingsDialog.this.fNavigationBar.addElement(n2, paramSet.getKey(), paramSet.getName(), paramSet.getIcon(), component);
                        }
                    });
                }
                ++n;
                continue;
            }
            if (!this.removePanel(paramSet)) continue;
            linkedList.add(new Runnable(){

                @Override
                public void run() {
                    NewSettingsDialog.this.fNavigationBar.removeElement(paramSet.getKey());
                }
            });
        }
        this.updateAllSettings(arrayList);
        this.fNavigationBar.replaceElement("settings.all", (Component)this.fTablePanel);
        this.fNavigationBar.change(linkedList, new Runnable(){

            @Override
            public void run() {
                NewSettingsDialog.this.autoResizeDialog();
            }
        });
    }

    private void updateAllSettings(List<ParamSet> list) {
        int n = 0;
        String string = null;
        if (this.fAllSettingsTable != null) {
            this.fAllSettingsTable.dispose();
            string = this.fAllSettingsTable.getModel().getSearchText();
            n = this.fAllSettingsTable.getSelectionModel().getSelectedRow();
        }
        NameColumn nameColumn = new NameColumn();
        ValueColumn valueColumn = new ValueColumn(this.fConfiguration);
        CellConstraints cellConstraints = new CellConstraints();
        this.fAllSettingsTable = SettingsTableUtils.createTable(this.fProject, list, Arrays.asList(nameColumn, valueColumn));
        this.fAllSettingsTable.getComponent().setName("settings.table");
        this.fTablePanel = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu, fill:d:grow"));
        this.fTablePanel.setOpaque(false);
        this.fTablePanel.add((Component)this.fAllSettingsTable.getComponent(), (Object)cellConstraints.xyw(1, 4, 3));
        this.fTablePanel.add((Component)this.fSearchTextField.getComponent(), (Object)cellConstraints.xy(2, 2));
        if (string != null) {
            this.fAllSettingsTable.getModel().setSearchText(string);
        }
        if (n < this.fAllSettingsTable.getModel().getRowCount()) {
            this.fAllSettingsTable.scrollRowToVisible(n);
        }
    }

    static {
        MAC_BACKGROUND_COLOR = new Color(237, 237, 237);
    }

    private class MainArea
    extends MJPanel
    implements SettingsTabbedPane {
        MainArea() {
            super((LayoutManager)new BorderLayout());
        }

        @Override
        public Component getSelectedComponent() {
            return NewSettingsDialog.this.fSelectedComponent;
        }

        @Override
        public void addTabChangeListener(ChangeListener changeListener) {
            NewSettingsDialog.this.fChangeListeners.addChangeListener(changeListener);
        }

        @Override
        public void removeTabChangeListener(ChangeListener changeListener) {
            NewSettingsDialog.this.fChangeListeners.removeChangeListener(changeListener);
        }
    }
}

