/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public final class IconUtils {
    private static final String RES_PATH = "/com/mathworks/project/impl/resources/";

    private IconUtils() {
    }

    public static void writeIconToFile(File file, BufferedImage bufferedImage) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
    }

    public static BufferedImage readIconFromFile(File file) throws IOException {
        return ImageIO.read(file);
    }

    public static BufferedImage getIconFromResources(String string) throws IOException {
        InputStream inputStream = IconUtils.class.getResourceAsStream(RES_PATH + string);
        if (inputStream != null) {
            return ImageIO.read(inputStream);
        }
        return null;
    }

    public static void copyResourceIconToFile(File file, String string, String string2) throws IOException {
        URL uRL = IconUtils.class.getResource(RES_PATH + string + string2);
        if (uRL != null) {
            FileUtils.copyURLToFile((URL)uRL, (File)file);
        }
    }

    public static BufferedImage applyMask(BufferedImage bufferedImage) {
        return bufferedImage == null ? null : IconUtils.applyRoundedCorners(IconUtils.applyGradient(bufferedImage));
    }

    public static BufferedImage scaleIcon(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage scaleIcon(BufferedImage bufferedImage, int n) {
        return IconUtils.scaleIcon(bufferedImage, n, n);
    }

    private static BufferedImage applyRoundedCorners(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = IconUtils.getCornerRadius(n);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(new RoundRectangle2D.Float(0.0f, 0.0f, n, n2, n3, n3));
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage applyBorder(BufferedImage bufferedImage, boolean bl) {
        if (bufferedImage == null) {
            return null;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.setColor(new Color(50, 50, 50, 75));
        graphics2D.setStroke(new BasicStroke(1.0f));
        int n3 = n - 1;
        if (bl) {
            int n4 = IconUtils.getCornerRadius(n);
            graphics2D.drawRoundRect(0, 0, n3, n3, n4, n4);
        } else {
            graphics2D.drawRect(0, 0, n3, n3);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static int getCornerRadius(int n) {
        return n == 48 ? 22 : (n == 24 ? 8 : 6);
    }

    private static BufferedImage applyGradient(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 150), n2 / 4, n / 2, new Color(255, 255, 255, 255));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, n, n2));
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

