/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.desktop.DescriptionLabel;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;

public class CustomRadioListWidget
extends AbstractParamWidget<List<String>> {
    private MJPanel fRadioPanel = new MJPanel();
    private MJRadioButton fNoneButton = new MJRadioButton(BuiltInResources.getString("details.nowarning"));
    private MJRadioButton fWarningButton;
    private MJList fList;
    private DefaultListModel fModel;
    private ArrayList<String> fAllPlatforms;
    private Set<String> fSupportedPlatforms;
    public static final String PARAM_PLATFORMS = "param.platforms";

    public CustomRadioListWidget(Param param, final Project project) {
        this.fNoneButton.setOpaque(false);
        this.fWarningButton = new MJRadioButton(BuiltInResources.getString("details.platformwarning"));
        this.fWarningButton.setOpaque(false);
        this.fWarningButton.setEnabled(false);
        this.fNoneButton.setEnabled(false);
        JComponent jComponent = new DescriptionLabel(param.getName()).getComponent();
        this.fRadioPanel.setLayout((LayoutManager)new GridLayout(3, 1));
        this.fRadioPanel.add((Component)jComponent);
        this.fRadioPanel.add((Component)this.fNoneButton);
        this.fRadioPanel.add((Component)this.fWarningButton);
        this.fRadioPanel.setBackground(Color.WHITE);
        this.fRadioPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.fRadioPanel.setToolTipText(BuiltInResources.getString("details.platformwarning"));
        this.fModel = new DefaultListModel();
        this.fList = new MJList((ListModel)this.fModel);
        this.fAllPlatforms = new ArrayList();
        this.fAllPlatforms.add("win64");
        this.fAllPlatforms.add("win32");
        this.fAllPlatforms.add("glnxa64");
        this.fAllPlatforms.add("maci");
        this.fWarningButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomRadioListWidget.this.fWarningButton.isSelected()) {
                    CustomRadioListWidget.this.fNoneButton.setSelected(false);
                    project.getConfiguration().setParamAsStringList(CustomRadioListWidget.PARAM_PLATFORMS, new ArrayList<String>(CustomRadioListWidget.this.fSupportedPlatforms));
                } else {
                    CustomRadioListWidget.this.fNoneButton.setSelected(true);
                    project.getConfiguration().setParamAsStringList(CustomRadioListWidget.PARAM_PLATFORMS, new ArrayList<String>());
                }
            }
        });
        this.fNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomRadioListWidget.this.fNoneButton.isSelected()) {
                    CustomRadioListWidget.this.fWarningButton.setSelected(false);
                    project.getConfiguration().setParamAsStringList(CustomRadioListWidget.PARAM_PLATFORMS, new ArrayList<String>());
                } else {
                    CustomRadioListWidget.this.fWarningButton.setSelected(true);
                    project.getConfiguration().setParamAsStringList(CustomRadioListWidget.PARAM_PLATFORMS, new ArrayList<String>(CustomRadioListWidget.this.fSupportedPlatforms));
                }
            }
        });
    }

    public void setEnabled(boolean bl) {
        this.fRadioPanel.setEnabled(bl);
    }

    public void enableRadioButtons(boolean bl) {
        this.fNoneButton.setEnabled(bl);
        this.fWarningButton.setEnabled(bl);
    }

    public void changeRadioButtonBehavior(Set<String> set) {
        this.fSupportedPlatforms = set;
        String string = "( ";
        if (!this.fSupportedPlatforms.isEmpty()) {
            this.enableRadioButtons(true);
            for (String string2 : this.fSupportedPlatforms) {
                if (!this.fAllPlatforms.contains(string2)) continue;
                this.fAllPlatforms.remove(string2);
            }
            for (String string2 : this.fAllPlatforms) {
                string = string + string2.toUpperCase() + " ";
            }
            this.fWarningButton.setText(BuiltInResources.getString("details.platformwarning") + " " + string + ")");
            this.fWarningButton.setSelected(true);
            this.fNoneButton.setSelected(false);
        } else {
            this.fWarningButton.setText(BuiltInResources.getString("details.platformwarning"));
            this.fWarningButton.setSelected(false);
            this.fNoneButton.setSelected(true);
        }
    }

    public void setData(final List<String> list) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (list == null || list.isEmpty()) {
                    CustomRadioListWidget.this.fList.setModel(new DefaultListModel());
                } else {
                    for (String string : list) {
                        CustomRadioListWidget.this.fModel.addElement(string);
                    }
                    CustomRadioListWidget.this.fList.setModel((ListModel)CustomRadioListWidget.this.fModel);
                    CustomRadioListWidget.this.fList.revalidate();
                }
            }
        });
    }

    public List<String> getData() {
        Object[] objectArray = this.fModel.toArray();
        Vector<String> vector = new Vector<String>(objectArray.length);
        for (Object object : objectArray) {
            assert (object instanceof String);
            vector.add((String)object);
        }
        return vector;
    }

    public Component getComponent() {
        return this.fRadioPanel;
    }
}

