/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.ProfileManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultProfileManager
implements ProfileManager {
    private final Map<String, Map<String, Object>> fProfiles;
    private final Map<String, Set<String>> fProfileParams;
    private final Configuration fConfiguration;
    private final Object fLock;
    private final AtomicInteger fSwapIndex;

    public DefaultProfileManager(Configuration configuration) {
        this.fConfiguration = configuration;
        this.fLock = new Object();
        this.fSwapIndex = new AtomicInteger();
        this.fProfiles = new HashMap<String, Map<String, Object>>();
        this.fProfileParams = new HashMap<String, Set<String>>();
        for (ParamSet object : configuration.getTarget().getParamSets()) {
            boolean bl = !object.getProfileKeys().isEmpty();
            for (Param param : object.getParams()) {
                if (!bl && param.getProfileKeys().isEmpty()) continue;
                Set<String> set = param.getProfileKeys();
                if (set.isEmpty()) {
                    set = object.getProfileKeys();
                }
                for (String string : set) {
                    Set<String> set2 = this.fProfileParams.get(string);
                    if (set2 == null) {
                        set2 = new HashSet<String>();
                        this.fProfileParams.put(string, set2);
                    }
                    set2.add(param.getKey());
                }
            }
        }
        for (Profile profile : configuration.getTarget().getProfiles()) {
            this.fProfiles.put(profile.getKey(), new HashMap());
        }
        if (!this.fProfiles.isEmpty()) {
            this.fConfiguration.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DefaultProfileManager.this.update(propertyChangeEvent);
                }
            });
        }
    }

    @Override
    public void loadingFinished() {
        Profile profile = this.fConfiguration.getActiveProfile();
        if (profile != null) {
            this.swapInProfile(profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(PropertyChangeEvent propertyChangeEvent) {
        Param param = this.fConfiguration.getTarget().getParam(propertyChangeEvent.getPropertyName());
        Profile profile = this.fConfiguration.getActiveProfile();
        if (param != null && this.hasProfileSupport(profile, param)) {
            if (this.fConfiguration.isParamExplicitlySet(param.getKey())) {
                Object object = this.fLock;
                synchronized (object) {
                    this.fProfiles.get(profile.getKey()).put(param.getKey(), propertyChangeEvent.getNewValue());
                }
            } else {
                Object object = this.fLock;
                synchronized (object) {
                    this.fProfiles.get(profile.getKey()).remove(param.getKey());
                }
            }
        } else if (propertyChangeEvent.getPropertyName().equals("__selected_profile")) {
            this.swapInProfile((Profile)propertyChangeEvent.getNewValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapInProfile(Profile profile) {
        Map<String, Object> map;
        int n = this.fSwapIndex.incrementAndGet();
        Iterator<String> iterator = this.fLock;
        synchronized (iterator) {
            map = this.fProfiles.get(profile.getKey());
        }
        for (String string : this.fProfileParams.get(profile.getKey())) {
            boolean bl;
            Object object = null;
            Object object2 = this.fLock;
            synchronized (object2) {
                bl = map.containsKey(string);
                if (bl) {
                    object = map.get(string);
                }
            }
            if (!bl) {
                this.fConfiguration.setParamAsObject(string, this.fConfiguration.getParamDefaultValue(string));
                continue;
            }
            this.fConfiguration.setParamAsObject(string, object);
        }
        assert (this.fSwapIndex.intValue() == n);
    }

    @Override
    public boolean hasAnyProfileSupport(Param param) {
        for (Set<String> set : this.fProfileParams.values()) {
            if (!set.contains(param.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasProfileSupport(Profile profile, Param param) {
        return this.fProfileParams.get(profile.getKey()).contains(param.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProfileValue(Profile profile, Param param) {
        Object object = this.fLock;
        synchronized (object) {
            return this.hasProfileSupport(profile, param) && this.fProfiles.get(profile.getKey()).containsKey(param.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProfileValue(Profile profile, Param param) {
        if (!this.hasProfileSupport(profile, param)) {
            throw new IllegalArgumentException("The param " + param.getKey() + " does not have profile support");
        }
        Object object = this.fLock;
        synchronized (object) {
            return this.fProfiles.get(profile.getKey()).get(param.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProfileValue(Profile profile, Param param, Object object) {
        if (!this.hasProfileSupport(profile, param)) {
            throw new IllegalArgumentException("The param " + param.getKey() + " does not have profile support");
        }
        Object object2 = this.fConfiguration.getParamDefaultValue(param.getKey());
        if (!(object2 == null && object == null || object.equals(object2))) {
            Object object3 = this.fLock;
            synchronized (object3) {
                this.fProfiles.get(profile.getKey()).put(param.getKey(), object);
            }
        }
    }
}

