/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponentWithSelection;
import com.mathworks.project.impl.DataTransferSupport;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;

public class FileSetEditorGroup {
    private final DataTransferSupport fDataTransferSupport;
    private final List<FileSetEditor> fEditors;
    private final PropertyChangeListener fFocusListener;
    private final Map<FileSetEditor, List<ProjectComponentWithSelection>> fChildren;
    private final List<ProjectComponentWithSelection> fPeers;

    public FileSetEditorGroup(DataTransferSupport dataTransferSupport) {
        this.fDataTransferSupport = dataTransferSupport;
        this.fEditors = new ArrayList<FileSetEditor>();
        this.fChildren = new HashMap<FileSetEditor, List<ProjectComponentWithSelection>>();
        this.fPeers = new ArrayList<ProjectComponentWithSelection>();
        this.fFocusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() != null) {
                    Iterator iterator = new ArrayList();
                    iterator.addAll(FileSetEditorGroup.this.fPeers);
                    for (List list : FileSetEditorGroup.this.fChildren.values()) {
                        iterator.addAll(list);
                    }
                    Object object = iterator.iterator();
                    while (object.hasNext()) {
                        List list;
                        list = (ProjectComponentWithSelection)object.next();
                        if (!SwingUtilities.isDescendingFrom((Component)propertyChangeEvent.getNewValue(), list.getComponent())) continue;
                        FileSetEditorGroup.this.toggleSelectionInto((ProjectComponentWithSelection)list);
                        break;
                    }
                }
                if (FileSetEditorGroup.this.hasFocus()) {
                    if (propertyChangeEvent.getNewValue() == null) {
                        return;
                    }
                    for (Object object : FileSetEditorGroup.this.fPeers) {
                        if (SwingUtilities.isDescendingFrom((Component)propertyChangeEvent.getNewValue(), object.getComponent())) continue;
                        object.clearSelection();
                    }
                    for (Object object : FileSetEditorGroup.this.fEditors) {
                        if (!SwingUtilities.isDescendingFrom((Component)propertyChangeEvent.getNewValue(), ((FileSetEditor)object).getComponent())) continue;
                        return;
                    }
                    FileSetEditorGroup.this.revalidateAndRepaintAll();
                } else if (propertyChangeEvent.getNewValue() == null) {
                    FileSetEditorGroup.this.revalidateAndRepaintAll();
                } else {
                    for (Object object : FileSetEditorGroup.this.fEditors) {
                        if (!SwingUtilities.isDescendingFrom((Component)propertyChangeEvent.getNewValue(), ((FileSetEditor)object).getComponent())) continue;
                        FileSetEditorGroup.this.revalidateAndRepaintAll();
                    }
                }
            }
        };
        FocusManager.getCurrentManager().addPropertyChangeListener("focusOwner", this.fFocusListener);
    }

    public DataTransferSupport getDataTransferSupport() {
        return this.fDataTransferSupport;
    }

    public void removeAll() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FileSetEditorGroup.this.fEditors.clear();
                FileSetEditorGroup.this.fChildren.clear();
                FileSetEditorGroup.this.fPeers.clear();
            }
        });
    }

    public FileSetEditor getFocusedEditor() {
        for (FileSetEditor fileSetEditor : this.fEditors) {
            if (!fileSetEditor.hasFocus()) continue;
            return fileSetEditor;
        }
        return null;
    }

    public void destroy() {
        FocusManager.getCurrentManager().removePropertyChangeListener(this.fFocusListener);
    }

    public void addEditor(FileSetEditor fileSetEditor) {
        this.fEditors.add(fileSetEditor);
    }

    public void addChild(FileSetEditor fileSetEditor, ProjectComponentWithSelection projectComponentWithSelection) {
        List<ProjectComponentWithSelection> list = this.fChildren.get(fileSetEditor);
        if (list == null) {
            list = new ArrayList<ProjectComponentWithSelection>();
            this.fChildren.put(fileSetEditor, list);
        }
        list.add(projectComponentWithSelection);
    }

    public void removeChild(FileSetEditor fileSetEditor, ProjectComponentWithSelection projectComponentWithSelection) {
        List<ProjectComponentWithSelection> list = this.fChildren.get(fileSetEditor);
        if (list != null) {
            list.remove(projectComponentWithSelection);
        }
    }

    public void addPeer(ProjectComponentWithSelection projectComponentWithSelection) {
        this.fPeers.add(projectComponentWithSelection);
    }

    public void removePeer(ProjectComponentWithSelection projectComponentWithSelection) {
        this.fPeers.remove(projectComponentWithSelection);
    }

    public boolean isFirst(FileSetEditor fileSetEditor) {
        return !this.fEditors.isEmpty() && this.fEditors.get(0).equals(fileSetEditor);
    }

    public boolean hasFocus() {
        for (FileSetEditor fileSetEditor : this.fEditors) {
            if (!fileSetEditor.hasFocus()) continue;
            return true;
        }
        return false;
    }

    public List<File> getSelectedFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (FileSetEditor fileSetEditor : this.fEditors) {
            arrayList.addAll(fileSetEditor.getSelectedFiles());
        }
        return arrayList;
    }

    public List<File> getSelectedOpenableFiles() {
        List<File> list = this.getSelectedFiles();
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.getName().endsWith(".bin") && !file.getName().endsWith(".dmg")) continue;
            iterator.remove();
        }
        return list;
    }

    public List<File> getSelectedExplicitFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (FileSetEditor fileSetEditor : this.fEditors) {
            Set<File> set = fileSetEditor.getFileSet().getNonSubsetFiles();
            for (File file : fileSetEditor.getSelectedFiles()) {
                if (!set.contains(file)) continue;
                arrayList.add(file);
            }
        }
        return arrayList;
    }

    public void toggleSelectionInto(FileSetEditor fileSetEditor) {
        for (FileSetEditor object : this.fEditors) {
            if (object.equals(fileSetEditor)) continue;
            object.clearSelection();
        }
        for (ProjectComponentWithSelection projectComponentWithSelection : this.fPeers) {
            projectComponentWithSelection.clearSelection();
        }
        for (List list : this.fChildren.values()) {
            for (ProjectComponentWithSelection projectComponentWithSelection : list) {
                projectComponentWithSelection.clearSelection();
            }
        }
    }

    public void toggleSelectionInto(ProjectComponentWithSelection projectComponentWithSelection) {
        for (FileSetEditor object : this.fEditors) {
            object.clearSelection();
        }
        for (ProjectComponentWithSelection projectComponentWithSelection2 : this.fPeers) {
            if (projectComponentWithSelection2.equals(projectComponentWithSelection)) continue;
            projectComponentWithSelection2.clearSelection();
        }
        for (List list : this.fChildren.values()) {
            for (ProjectComponentWithSelection projectComponentWithSelection3 : list) {
                if (projectComponentWithSelection3.equals(projectComponentWithSelection)) continue;
                projectComponentWithSelection3.clearSelection();
            }
        }
    }

    public List<FileSetEditor> getEditors() {
        return new ArrayList<FileSetEditor>(this.fEditors);
    }

    public void revalidateAndRepaintAll() {
        for (FileSetEditor fileSetEditor : this.fEditors) {
            fileSetEditor.getComponent().revalidate();
            fileSetEditor.getComponent().repaint();
        }
    }
}

