/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.DataTransferSupport;
import com.mathworks.project.impl.SectionedProjectTab;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectTabDefinition;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plaf.DeploymentTabbedPaneUI;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public final class ProjectTabbedPane {
    private static final int TITLE_FONT_SIZE = 13;
    private final MJTabbedPane fTabbedPane;
    private final List<ProjectComponent> fTabs;
    private final List<ProjectTabDefinition> fTabDefinitions;
    private final DataTransferSupport fDataTransferSupport = new DataTransferSupport();

    public ProjectTabbedPane() {
        this.fTabs = new ArrayList<ProjectComponent>();
        this.fTabDefinitions = new ArrayList<ProjectTabDefinition>();
        this.fTabbedPane = new TabbedPane();
        this.fTabbedPane.setUI((TabbedPaneUI)new DeploymentTabbedPaneUI());
        this.fTabbedPane.setName("deploytool.tabs");
        this.fTabbedPane.setFont(this.fTabbedPane.getFont());
    }

    public void activateDefaultTab() {
        this.fTabbedPane.setSelectedIndex(0);
    }

    public void activatePackageTab() {
        for (int i = 0; i < this.fTabs.size(); ++i) {
            if (!this.fTabDefinitions.get(i).requiresPackageScript()) continue;
            this.fTabbedPane.setSelectedIndex(i);
            break;
        }
    }

    public FileSetEditorGroup getActiveGroup() {
        int n = this.fTabbedPane.getSelectedIndex();
        ProjectComponent projectComponent = this.fTabs.get(n);
        if (projectComponent instanceof SectionedProjectTab) {
            return ((SectionedProjectTab)projectComponent).getFileSetGroup();
        }
        return null;
    }

    public void setConfiguration(final Project project) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectTabbedPane.this.reset();
                Target target = project.getConfiguration().getTarget();
                List list = ProjectTabbedPane.getApplicableTabs(target);
                for (int i = 0; i < list.size(); ++i) {
                    ProjectTabDefinition projectTabDefinition = (ProjectTabDefinition)list.get(i);
                    ProjectComponent projectComponent = ProjectTabbedPane.this.instantiateTab(project, projectTabDefinition);
                    if (projectComponent instanceof SectionedProjectTab) {
                        SectionedProjectTab sectionedProjectTab = (SectionedProjectTab)projectComponent;
                        ProjectTabbedPane.this.fDataTransferSupport.installDropSupport(sectionedProjectTab.getFileSetGroup(), (Component)ProjectTabbedPane.this.fTabbedPane, (Predicate<Point>)ProjectTabbedPane.this.createTabHitTester(i));
                        FileSetEditor fileSetEditor = sectionedProjectTab.getLastEditor();
                        if (fileSetEditor != null) {
                            ProjectTabbedPane.this.fDataTransferSupport.installDropSupport(fileSetEditor, sectionedProjectTab.getComponent());
                        }
                    }
                    ProjectTabbedPane.this.fTabDefinitions.add(projectTabDefinition);
                    ProjectTabbedPane.this.fTabs.add(projectComponent);
                    ProjectTabbedPane.this.fTabbedPane.addTab(projectTabDefinition.getName(), projectComponent.getComponent());
                }
            }
        });
    }

    public void reset() {
        this.fDataTransferSupport.uninstall((Component)this.fTabbedPane);
        for (ProjectComponent projectComponent : this.fTabs) {
            projectComponent.dispose();
        }
        this.fDataTransferSupport.dispose();
        this.fTabbedPane.removeAll();
        this.fTabs.clear();
        this.fTabDefinitions.clear();
        while (this.fTabbedPane.getTabCount() != 0) {
            this.fTabbedPane.removeTabAt(0);
        }
        this.fTabbedPane.setUI((TabbedPaneUI)new DeploymentTabbedPaneUI());
    }

    private static List<ProjectTabDefinition> getApplicableTabs(Target target) {
        ArrayList<ProjectTabDefinition> arrayList = new ArrayList<ProjectTabDefinition>();
        for (ProjectTabDefinition projectTabDefinition : target.getProjectTabs()) {
            if (projectTabDefinition.requiresPackageScript() && target.getPackageScript() == null) continue;
            arrayList.add(projectTabDefinition);
        }
        return arrayList;
    }

    private ProjectComponent instantiateTab(Project project, ProjectTabDefinition projectTabDefinition) {
        try {
            Class<?> clazz = Class.forName(projectTabDefinition.getImplementationClassName());
            for (Constructor<?> constructor : clazz.getConstructors()) {
                List<Class<?>> list = Arrays.asList(constructor.getParameterTypes());
                if (list.equals(Arrays.asList(DataTransferSupport.class, WritableConfiguration.class))) {
                    return (ProjectComponent)constructor.newInstance(this.fDataTransferSupport, project.getConfiguration());
                }
                if (list.equals(Arrays.asList(Project.class, List.class))) {
                    return (ProjectComponent)constructor.newInstance(project, projectTabDefinition.getSections());
                }
                if (!list.equals(Arrays.asList(DataTransferSupport.class, Project.class, List.class))) continue;
                return (ProjectComponent)constructor.newInstance(this.fDataTransferSupport, project, projectTabDefinition.getSections());
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        throw new IllegalArgumentException("No supported constructor in class: " + projectTabDefinition.getImplementationClassName());
    }

    private Predicate<Point> createTabHitTester(final int n) {
        return new Predicate<Point>(){

            public boolean accept(Point point) {
                return ProjectTabbedPane.this.fTabbedPane.getUI().getTabBounds((JTabbedPane)ProjectTabbedPane.this.fTabbedPane, n).contains(point);
            }
        };
    }

    public FileSetEditor getFileSetEditor(String string) {
        for (ProjectComponent projectComponent : this.fTabs) {
            FileSetEditor fileSetEditor;
            if (!(projectComponent instanceof SectionedProjectTab) || (fileSetEditor = ((SectionedProjectTab)projectComponent).getFileSetEditor(string)) == null) continue;
            return fileSetEditor;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.fTabbedPane;
    }

    private static class TabbedPane
    extends MJTabbedPane {
        TabbedPane() {
            super(1);
        }

        public void setFont(Font font) {
            String string = FontUtils.getSystemUIFont().getFontName();
            if (LanguageUtils.isEnglish()) {
                if (PlatformInfo.isMacintosh()) {
                    string = "Lucida Grande";
                } else if (PlatformInfo.isWindows()) {
                    string = "Segoe UI";
                }
            }
            super.setFont(new Font(string, 0, 13));
        }
    }
}

