/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.richeditor;

import com.mathworks.mde.richeditor.ActionID;
import com.mathworks.mde.richeditor.widget.rtc.ActionDataService;
import com.mathworks.mde.richeditor.widget.rtc.DocumentEvent;
import com.mathworks.mde.richeditor.widget.rtc.DocumentListener;
import com.mathworks.mde.richeditor.widget.rtc.RichDocument;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.util.PlatformInfo;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class ActionManager {
    private final RichDocument fRichDocument;
    private final DocumentListener fDocumentListener;
    private final ActionDataService fActionDataService;
    private Map<ActionID, MJAbstractAction> fActionMap;
    private Map<ActionID, Observer> fActionObserver;
    private ActionDataService.ActionDataServiceListener fActionDataServiceListener;
    private static final String ACTION_DATA_SERVICE_CHANNEL = "/actions/richeditor/";

    ActionManager(RichDocument richDocument) {
        this(richDocument, new ActionDataService(ACTION_DATA_SERVICE_CHANNEL + richDocument.getUniqueKey()));
    }

    public ActionManager(RichDocument richDocument, ActionDataService actionDataService) {
        this.fRichDocument = richDocument;
        this.fActionMap = this.createActionMap();
        this.disableAllActions();
        this.fActionObserver = new HashMap<ActionID, Observer>();
        this.fDocumentListener = new DocumentListener(){

            @Override
            public void eventFired(DocumentEvent documentEvent) {
                ActionManager.this.handleDocumentInitialized();
            }
        };
        this.fRichDocument.addDocumentListener(DocumentEvent.EventType.INITIALIZED, this.fDocumentListener);
        this.fActionDataService = actionDataService;
        this.addActionDataServiceListener();
    }

    private void addActionDataServiceListener() {
        this.fActionDataServiceListener = new ActionDataService.ActionDataServiceListener(){

            @Override
            public void onActionChange(ActionDataService.ActionChangeEvent actionChangeEvent) {
                ActionID actionID = ActionManager.this.findActionID(actionChangeEvent.getActionID());
                if (actionID == null) {
                    return;
                }
                if (actionChangeEvent.getPropertyName().equals("enabled")) {
                    ActionManager.this.getAction(actionID).setEnabled(((Boolean)actionChangeEvent.getNewValue()).booleanValue());
                }
                if (actionChangeEvent.getPropertyName().equals("selected")) {
                    ActionManager.this.getAction(actionID).setSelected(((Boolean)actionChangeEvent.getNewValue()).booleanValue());
                }
            }

            @Override
            public void onActionAdded(String string) {
                ActionID actionID = ActionManager.this.findActionID(string);
                if (actionID == null) {
                    return;
                }
                Map<String, Object> map = ActionManager.this.fActionDataService.getProperties(string);
                if (map.containsKey("enabled")) {
                    ActionManager.this.getAction(actionID).setEnabled(((Boolean)map.get("enabled")).booleanValue());
                }
                if (map.containsKey("selected")) {
                    ActionManager.this.getAction(actionID).setSelected(((Boolean)map.get("selected")).booleanValue());
                }
            }

            @Override
            public void onActionDeleted(String string) {
            }
        };
        this.fActionDataService.addActionDataServiceListener(this.fActionDataServiceListener);
    }

    private ActionID findActionID(String string) {
        ActionID actionID = null;
        for (ActionID actionID2 : ActionID.values()) {
            if (!actionID2.getJavaScriptId().equals(string)) continue;
            actionID = actionID2;
        }
        return actionID;
    }

    private void handleDocumentInitialized() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ActionID actionID : ActionID.values()) {
                    if (!actionID.getJavaScriptId().isEmpty()) continue;
                    ((MJAbstractAction)ActionManager.this.fActionMap.get((Object)actionID)).setEnabled(true);
                }
            }
        });
    }

    void setObserver(ActionID actionID, Observer observer) {
        assert (!this.fActionObserver.containsKey((Object)actionID)) : "There is observer already assocaited with this action " + (Object)((Object)actionID);
        this.fActionObserver.put(actionID, observer);
    }

    public MJAbstractAction getAction(ActionID actionID) {
        return this.fActionMap.get((Object)actionID);
    }

    private Map<ActionID, MJAbstractAction> createActionMap() {
        HashMap<ActionID, MJAbstractAction> hashMap = new HashMap<ActionID, MJAbstractAction>();
        int n = PlatformInfo.isMacintosh() ? 256 : 128;
        this.createObservableAction(hashMap, ActionID.NEW);
        ((MJAbstractAction)hashMap.get((Object)ActionID.NEW)).setAccelerator(KeyStroke.getKeyStroke(78, n));
        this.createObservableAction(hashMap, ActionID.NEW_RICH_SCRIPT);
        this.createObservableAction(hashMap, ActionID.OPEN);
        ((MJAbstractAction)hashMap.get((Object)ActionID.OPEN)).setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.createObservableAction(hashMap, ActionID.OPEN_AS_RICH_CODE);
        this.createObservableAction(hashMap, ActionID.SAVE);
        ((MJAbstractAction)hashMap.get((Object)ActionID.SAVE)).setAccelerator(KeyStroke.getKeyStroke(83, n));
        this.createObservableAction(hashMap, ActionID.SAVE_AS);
        this.createObservableAction(hashMap, ActionID.FIND_FILES);
        ((MJAbstractAction)hashMap.get((Object)ActionID.FIND_FILES)).setAccelerator(KeyStroke.getKeyStroke(70, n + 64));
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.find();
            }
        };
        mJAbstractAction.setAccelerator(KeyStroke.getKeyStroke(70, n));
        MJAbstractAction mJAbstractAction2 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.findNext();
            }
        };
        mJAbstractAction2.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        MJAbstractAction mJAbstractAction3 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.findPrevious();
            }
        };
        mJAbstractAction3.setAccelerator(KeyStroke.getKeyStroke(114, 64));
        MJAbstractAction mJAbstractAction4 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.findSelection();
            }
        };
        mJAbstractAction4.setAccelerator(KeyStroke.getKeyStroke(114, n));
        MJAbstractAction mJAbstractAction5 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.indent();
            }
        };
        mJAbstractAction5.setAccelerator(KeyStroke.getKeyStroke(93, n));
        MJAbstractAction mJAbstractAction6 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.unIndent();
            }
        };
        mJAbstractAction6.setAccelerator(KeyStroke.getKeyStroke(91, n));
        MJAbstractAction mJAbstractAction7 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.smartIndent();
            }
        };
        mJAbstractAction7.setAccelerator(KeyStroke.getKeyStroke(73, n));
        MJAbstractAction mJAbstractAction8 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.comment();
            }
        };
        mJAbstractAction8.setAccelerator(KeyStroke.getKeyStroke(82, n));
        MJAbstractAction mJAbstractAction9 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.uncomment();
            }
        };
        mJAbstractAction9.setAccelerator(KeyStroke.getKeyStroke(84, n));
        MJAbstractAction mJAbstractAction10 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.undo();
            }
        };
        mJAbstractAction10.setAccelerator(KeyStroke.getKeyStroke(90, n));
        MJAbstractAction mJAbstractAction11 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.redo();
            }
        };
        mJAbstractAction11.setAccelerator(KeyStroke.getKeyStroke(89, n));
        MJAbstractAction mJAbstractAction12 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.setBold(((AbstractButton)actionEvent.getSource()).isSelected());
            }
        };
        mJAbstractAction12.setAccelerator(KeyStroke.getKeyStroke(66, n));
        MJAbstractAction mJAbstractAction13 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.setItalics(((AbstractButton)actionEvent.getSource()).isSelected());
            }
        };
        mJAbstractAction13.setAccelerator(KeyStroke.getKeyStroke(73, n));
        MJAbstractAction mJAbstractAction14 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.setUnderline(((AbstractButton)actionEvent.getSource()).isSelected());
            }
        };
        mJAbstractAction14.setAccelerator(KeyStroke.getKeyStroke(85, n));
        MJAbstractAction mJAbstractAction15 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.setMonospace(((AbstractButton)actionEvent.getSource()).isSelected());
            }
        };
        mJAbstractAction15.setAccelerator(KeyStroke.getKeyStroke(77, n));
        MJAbstractAction mJAbstractAction16 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.formatParagraphAsCode();
            }
        };
        mJAbstractAction16.setAccelerator(KeyStroke.getKeyStroke(69, n));
        MJAbstractAction mJAbstractAction17 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.formatParagraphAsText();
            }
        };
        mJAbstractAction17.setAccelerator(KeyStroke.getKeyStroke(69, n));
        MJAbstractAction mJAbstractAction18 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.formatParagraphAsHeading();
            }
        };
        mJAbstractAction18.setAccelerator(KeyStroke.getKeyStroke(72, n + 512));
        MJAbstractAction mJAbstractAction19 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.formatParagraphAsTitle();
            }
        };
        mJAbstractAction19.setAccelerator(KeyStroke.getKeyStroke(76, n + 512));
        MJAbstractAction mJAbstractAction20 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.hyperlink();
            }
        };
        mJAbstractAction20.setAccelerator(KeyStroke.getKeyStroke(72, n));
        MJAbstractAction mJAbstractAction21 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.formatParagraphAsBulletedList();
            }
        };
        MJAbstractAction mJAbstractAction22 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.formatParagraphAsNumberedList();
            }
        };
        MJAbstractAction mJAbstractAction23 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.getAction(ActionID.RUN).setSelected(true);
                ActionManager.this.getAction(ActionID.LIVE).setSelected(false);
                ActionManager.this.fRichDocument.setLive(false);
            }
        };
        MJAbstractAction mJAbstractAction24 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.getAction(ActionID.RUN).setSelected(false);
                ActionManager.this.getAction(ActionID.LIVE).setSelected(true);
                ActionManager.this.fRichDocument.setLive(true);
            }
        };
        MJAbstractAction mJAbstractAction25 = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.this.fRichDocument.refreshOutputs();
            }
        };
        mJAbstractAction24.setSelected(true);
        mJAbstractAction23.setSelected(false);
        mJAbstractAction25.setEnabled(true);
        hashMap.put(ActionID.FIND, mJAbstractAction);
        hashMap.put(ActionID.FIND_NEXT, mJAbstractAction2);
        hashMap.put(ActionID.FIND_PREVIOUS, mJAbstractAction3);
        hashMap.put(ActionID.FIND_SELECTION, mJAbstractAction4);
        hashMap.put(ActionID.INDENT, mJAbstractAction5);
        hashMap.put(ActionID.UNINDENT, mJAbstractAction6);
        hashMap.put(ActionID.SMART_INDENT, mJAbstractAction7);
        hashMap.put(ActionID.COMMENT, mJAbstractAction8);
        hashMap.put(ActionID.UNCOMMENT, mJAbstractAction9);
        hashMap.put(ActionID.UNDO, mJAbstractAction10);
        hashMap.put(ActionID.REDO, mJAbstractAction11);
        hashMap.put(ActionID.MONOSPACE, mJAbstractAction15);
        hashMap.put(ActionID.UNDERLINE, mJAbstractAction14);
        hashMap.put(ActionID.ITALIC, mJAbstractAction13);
        hashMap.put(ActionID.BOLD, mJAbstractAction12);
        hashMap.put(ActionID.HYPERLINK, mJAbstractAction20);
        hashMap.put(ActionID.CODE, mJAbstractAction16);
        hashMap.put(ActionID.TEXT, mJAbstractAction17);
        hashMap.put(ActionID.HEADING, mJAbstractAction18);
        hashMap.put(ActionID.TITLE, mJAbstractAction19);
        hashMap.put(ActionID.BULLETED_LIST, mJAbstractAction21);
        hashMap.put(ActionID.NUMBERED_LIST, mJAbstractAction22);
        hashMap.put(ActionID.RUN, mJAbstractAction23);
        hashMap.put(ActionID.LIVE, mJAbstractAction24);
        hashMap.put(ActionID.RUN_REFRESH_NOW, mJAbstractAction25);
        return hashMap;
    }

    private void createObservableAction(Map<ActionID, MJAbstractAction> map, final ActionID actionID) {
        map.put(actionID, new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Observer observer = (Observer)ActionManager.this.fActionObserver.get((Object)actionID);
                assert (observer != null) : "There should be an observer is action was called.";
                observer.update(null, actionEvent);
            }
        });
    }

    public void dispose() {
        this.fActionObserver = null;
        this.fActionDataService.removeActionDataServiceListener(this.fActionDataServiceListener);
        this.fActionDataService.dispose();
        this.fRichDocument.removeDocumentListener(DocumentEvent.EventType.INITIALIZED, this.fDocumentListener);
    }

    private void disableAllActions() {
        for (ActionID actionID : ActionID.values()) {
            this.fActionMap.get((Object)actionID).setEnabled(false);
        }
    }
}

