/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.SearchHighlight;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.search.SearchKeywordsVisitor;
import com.mathworks.search.SearchVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HighlightProvider {
    private static final int MAX_HIGHLIGHTS = 10;
    private static final String SUBSTITUTION_CHAR = "\u001a";
    private static final String BEFORE_MATCH = "(?<=[^\\p{L}\\d]|^)";
    private static final String AFTER_MATCH = "(?=[^\\p{L}\\d]|$)";
    private static final String SNIPPET_FIRST_CHAR = "[\\p{L}\\d\\(]";
    private static final String SNIPPET_LAST_CHAR = "[\\p{L}\\d\\)]";
    private static final String SNIPPET_INTERNAL_CHAR = "[^\\x1A\\n]";
    private static final String SNIPPET_PREFIX = "(?<=[^\\p{L}\\d]|^)(?:[\\p{L}\\d\\(][^\\x1A\\n]{0,34})?";
    private static final String SNIPPET_SUFFIX = "(?:[^\\x1A\\n]{0,34}[\\p{L}\\d\\)])?(?=[^\\p{L}\\d]|$)";
    private final Pattern fSnippetPattern;
    private final Pattern fKeywordsPattern;

    public HighlightProvider(SearchCriteria searchCriteria) {
        Collection<Object> collection;
        SearchKeywordsVisitor searchKeywordsVisitor = new SearchKeywordsVisitor();
        try {
            searchCriteria.getExpression().accept((SearchVisitor)searchKeywordsVisitor);
            collection = searchKeywordsVisitor.getSearchKeywords();
        }
        catch (Exception exception) {
            collection = Collections.emptyList();
        }
        Pattern pattern = null;
        Pattern pattern2 = null;
        if (collection != null && !collection.isEmpty()) {
            String string = HighlightProvider.createKeywordsRegexp(collection);
            pattern = Pattern.compile(string, 2);
            pattern2 = HighlightProvider.createHighlightPattern(string);
        }
        this.fKeywordsPattern = pattern;
        this.fSnippetPattern = pattern2;
    }

    public List<SearchHighlight> getHighlights(String string) throws Exception {
        if (this.fSnippetPattern == null || this.fKeywordsPattern == null) {
            return Collections.emptyList();
        }
        ArrayList<SearchHighlight> arrayList = new ArrayList<SearchHighlight>();
        String string2 = string.replaceAll("\\.\\s+", SUBSTITUTION_CHAR);
        Matcher matcher = this.fSnippetPattern.matcher(string2);
        for (int i = 0; i < 10 && matcher.find(); ++i) {
            String string3 = HighlightProvider.adjustHighlightText(matcher.group(0));
            Matcher matcher2 = this.fKeywordsPattern.matcher(string3);
            ArrayList<SearchHighlight.Extent> arrayList2 = new ArrayList<SearchHighlight.Extent>();
            while (matcher2.find()) {
                arrayList2.add(new SearchHighlight.Extent(matcher2.start(1), matcher2.end(1)));
            }
            arrayList.add(new SearchHighlight(string3, arrayList2));
        }
        return arrayList;
    }

    private static String adjustHighlightText(String string) {
        String string2 = string.trim().replaceAll("\\s+", " ").replaceAll("\\x1A", ". ");
        if (string2.charAt(0) == '(' && string2.indexOf(41) < 0) {
            string2 = string2.substring(1);
        }
        if (string2.charAt(string2.length() - 1) == ')' && string2.indexOf(40) < 0) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private static String createKeywordsRegexp(Collection<String> collection) {
        boolean bl = HTMLUtils.isLocaleNoWordBreak();
        StringBuilder stringBuilder = new StringBuilder(bl ? "" : BEFORE_MATCH).append('(');
        for (String string : collection) {
            stringBuilder.append(HighlightProvider.createRegexpForKeyword(string, bl)).append('|');
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        stringBuilder.append(')');
        if (!bl) {
            stringBuilder.append(AFTER_MATCH);
        }
        return stringBuilder.toString();
    }

    private static String createRegexpForKeyword(String string, boolean bl) {
        String string2 = string;
        string2 = string2.replaceAll("\\*", "\\\\w*");
        string2 = string2.replaceAll("\\s+", "[\\\\W_]+");
        if (bl && HighlightProvider.useEnglishRegexpForNoWordBreak(string)) {
            return BEFORE_MATCH + string2 + AFTER_MATCH;
        }
        return string2;
    }

    private static boolean useEnglishRegexpForNoWordBreak(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            if (c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    private static Pattern createHighlightPattern(String string) {
        String string2 = string + "(?:" + SNIPPET_INTERNAL_CHAR + "{0,45}" + string + ")*";
        String string3 = SNIPPET_PREFIX + string2 + SNIPPET_SUFFIX;
        return Pattern.compile(string3, 2);
    }
}

