/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.help.HelpBrowserBridge;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.MLHelpBrowserActiveTab;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTGroupBase;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class MLHelpBrowserGroup
extends DTGroupBase {
    static final String ML_DOC_CENTER_BROWSER_GROUP_NAME = "Doc Center";
    static final String NEW_ML_DOC_CENTER_ACTION_NAME = "New Doc Center";
    private static MLHelpBrowserGroup sInstance = null;
    private static int sNextClientNum = 0;

    public static synchronized MLHelpBrowserGroup getInstance() {
        if (sInstance == null) {
            sInstance = new MLHelpBrowserGroup();
        }
        return sInstance;
    }

    private MLHelpBrowserGroup() {
        this.setGroupName(ML_DOC_CENTER_BROWSER_GROUP_NAME);
        this.setAppendDocumentTitle(false);
        this.setTitle(HelpBrowserUtils.getString((String)"helpbrowser.dtgroup.title"));
        this.setOfferToolBarToggles(false);
        this.setDontMergeMenu(true);
        this.setNeverReopenEmpty(true);
        this.setShowSingleEntryDocumentBar(true);
        this.setWillSupplyToolstripTabs(false);
        this.setPlaceToolBarsWithDocumentBar(true);
        this.setNewAction((Action)((Object)new NewTabAction()));
        if (PlatformInfo.isWindows()) {
            this.setIcon(IconUtils.createBadgedIcon((ImageIcon)CommonIcon.HELP_32x32.getIcon(), (ImageIcon)ApplicationIcon.MATLAB.getIcon(), (int)15, (int)15, (int)18, (int)18));
        } else {
            this.setIcon(IconUtils.createBadgedIcon((ImageIcon)CommonIcon.HELP_48x48.getIcon(), (ImageIcon)ApplicationIcon.MATLAB_32x32.getIcon(), (int)18, (int)20));
        }
        this.setSmallIcon(IconUtils.createBadgedIcon((ImageIcon)CommonIcon.HELP.getIcon(), (ImageIcon)ApplicationIcon.MATLAB.getIcon(), (int)5, (int)6, (int)11, (int)11));
        MLHelpBrowserGroup.addDesktopListeners();
    }

    private static void addDesktopListeners() {
        MLDesktop mLDesktop = MLDesktop.getInstance();
        mLDesktop.addClientListener(ML_DOC_CENTER_BROWSER_GROUP_NAME, (DTClientListener)new DTClientAdapter(){

            public void clientActivated(DTClientEvent dTClientEvent) {
                MLHelpBrowserGroup.setActiveHelpBrowserTab((MLHelpBrowser)((Object)dTClientEvent.getClient()));
            }

            public void clientClosed(DTClientEvent dTClientEvent) {
                MLHelpBrowser mLHelpBrowser = (MLHelpBrowser)((Object)dTClientEvent.getClient());
                MLHelpBrowserGroup.removeHelpBrowserTab(mLHelpBrowser);
                MLHelpBrowserGroup.disposeHelpBrowser(mLHelpBrowser);
                mLHelpBrowser = null;
            }
        });
    }

    private static void setActiveHelpBrowserTab(MLHelpBrowser mLHelpBrowser) {
        MLHelpBrowserActiveTab.setActiveHelpBrowserTab(mLHelpBrowser);
    }

    private static void removeHelpBrowserTab(MLHelpBrowser mLHelpBrowser) {
        MLHelpBrowserActiveTab.removeHelpBrowserTab(mLHelpBrowser);
    }

    private static void disposeHelpBrowser(MLHelpBrowser mLHelpBrowser) {
        mLHelpBrowser.dispose();
    }

    static int getNextClientNum() {
        assert (SwingUtilities.isEventDispatchThread()) : "MLHelpBrowserGroup.getNextClientNum must be called on the EDT.";
        return ++sNextClientNum;
    }

    private static class NewTabAction
    extends MJAbstractAction {
        NewTabAction() {
            super(HelpBrowserUtils.getString((String)"helpbrowser.dtgroup.newaction.tooltiptext"));
            this.setButtonOnlyIcon(MiscellaneousIcon.ADD_ENTRY.getIcon());
            this.setTip(HelpBrowserUtils.getString((String)"helpbrowser.dtgroup.newaction.tooltiptext"));
            this.setComponentName(MLHelpBrowserGroup.NEW_ML_DOC_CENTER_ACTION_NAME);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowserBridge.getInstance().openInNewBrowser(DocCenterDocConfig.getInstance().getDocRoot().buildGlobalLandingPageUrl());
        }
    }
}

