/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.html.CharsetDetectionStrategy;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.HelpBrowser;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.DemoInfoItem;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeUtils;
import com.mathworks.xml.XMLUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FileUtils;

public class DemoUtils {
    private static Matlab sMatlab = new Matlab();

    private DemoUtils() {
    }

    public static boolean displayDemoAndHighlightKeywords(DemoInfoItem demoInfoItem, Component component, String[] stringArray) {
        return DemoUtils.displayDemo(demoInfoItem, null, component, stringArray);
    }

    public static boolean displayDemo(DemoInfoItem demoInfoItem, Component component) {
        return DemoUtils.displayDemo(demoInfoItem, null, component, null);
    }

    public static boolean displayDemo(DemoInfoItem demoInfoItem, String string, Component component) {
        return DemoUtils.displayDemo(demoInfoItem, string, component, null);
    }

    private static boolean displayDemo(DemoInfoItem demoInfoItem, String string, Component component, String[] stringArray) {
        String string2;
        String string3 = string2 = string != null ? string : demoInfoItem.getCallback();
        if (DemoUtils.isNotEmpty(demoInfoItem.getType())) {
            if (DemoUtils.isNotEmpty(demoInfoItem.getFilename())) {
                DemoUtils.displayFileInHelpBrowser(demoInfoItem.getFilename(), stringArray);
            } else if ("M-file".equals(demoInfoItem.getType())) {
                String string4 = DemoUtils.getDemosroot(demoInfoItem.getXmlFilename());
                String string5 = string4 + "/html/" + demoInfoItem.getSource() + ".html";
                String string6 = DemoInfoUtils.getLocalizedDemoFilename((String)string5);
                DemoUtils.displayFileInHelpBrowser(string6, stringArray);
            } else {
                String string7 = demoInfoItem.getSource();
                if (DemoUtils.isNotEmpty(string2)) {
                    string7 = string2;
                }
                if (component != null) {
                    DemoUtils.setWaitCursor(component, true);
                }
                sMatlab.fevalConsoleOutput("demowin", new Object[]{string7, demoInfoItem.getProduct(), demoInfoItem.getLabel(), "", "", stringArray}, 0, (CompletionObserver)new ExplorerCompletionObserver(component));
            }
            DemoUtils.setCurrentDemoId(demoInfoItem);
            return true;
        }
        if (DemoUtils.isNotEmpty(string2)) {
            String string8 = demoInfoItem.getTextDescription();
            DemoUtils.setWaitCursor(component, true);
            if (DemoUtils.isNotEmpty(demoInfoItem.getFilename())) {
                string8 = DemoUtils.readFileIntoDescription(demoInfoItem.getFilename());
            }
            String string9 = DemoUtils.isNotEmpty(demoInfoItem.getFilename()) ? XMLUtils.filePathAsUrl((String)demoInfoItem.getFilename()) : "";
            sMatlab.fevalConsoleOutput("demowin", new Object[]{string2, demoInfoItem.getProduct(), demoInfoItem.getLabel(), string8, string9, stringArray}, 0, (CompletionObserver)new ExplorerCompletionObserver(component));
            DemoUtils.setCurrentDemoId(demoInfoItem);
            return true;
        }
        return false;
    }

    private static void displayFileInHelpBrowser(String string, String[] stringArray) {
        CharsetDetectionStrategy charsetDetectionStrategy = DemoUtils.getStrategyForFile(string);
        HelpBrowser.setCurrentLocationAndHighlightKeywords(string, charsetDetectionStrategy, stringArray, false);
    }

    private static CharsetDetectionStrategy getStrategyForFile(String string) {
        if (string.matches(".*\\.html?$")) {
            return CharsetDetectionStrategy.getAutoDetectStrategy();
        }
        return CharsetDetectionStrategy.getDefaultCharsetStrategy();
    }

    private static void setCurrentDemoId(DemoInfoItem demoInfoItem) {
        if (!(demoInfoItem instanceof DemoTreeItem) || HelpTreeUtils.isValidTreeNode((TreeNode)((HelpTreeItem)demoInfoItem).getTreeNode())) {
            HelpBrowser.setCurrentDemoId(DemoInfoUtils.getIdentifier((DemoInfoItem)demoInfoItem));
        }
    }

    static void setWaitCursor(Component component, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new CursorHandler(component, bl));
        } else {
            Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
            component.setCursor(cursor);
        }
    }

    static String getDemosroot(String string) {
        return DemoUtils.getDemosroot(string, HelpUtils.getDemosDirectoryName());
    }

    private static String getDemosroot(String string, String[] stringArray) {
        return DemoInfoUtils.getDemosroot((String)string, (String[])stringArray);
    }

    private static String readFileIntoDescription(String string) {
        String string2;
        File file;
        boolean bl = false;
        if (string.startsWith("$docroot")) {
            string = DemoUtils.resolveDocrootPrefix(string);
            bl = true;
        }
        if ((file = new File(string)).exists()) {
            try {
                string2 = FileUtils.readFileToString((File)new File(string));
            }
            catch (IOException iOException) {
                string2 = null;
            }
        } else if (bl) {
            Object[] objectArray = new Object[]{"file:/" + DemoUtils.getHelpErrPage()};
            string2 = MessageFormat.format("<p><p>" + HelpUtils.getLocalizedString((String)"demos.cantfinddemoinhelp") + "<p>", objectArray);
        } else {
            Object[] objectArray = new Object[]{string};
            string2 = MessageFormat.format("<p><p>" + HelpUtils.getLocalizedString((String)"demos.cantfinddemo") + "<p>", objectArray);
        }
        return string2;
    }

    private static String resolveDocrootPrefix(String string) {
        return HelpUtils.getLocalizedFilename((String)MLHelpServices.getDocRoot()) + "/" + string.substring(8);
    }

    private static String getHelpErrPage() {
        return Matlab.matlabRoot() + "/toolbox/local/helperr.html";
    }

    private static boolean isEmptyOrNull(String string) {
        return string == null || string.length() == 0;
    }

    private static boolean isNotEmpty(String string) {
        return !DemoUtils.isEmptyOrNull(string);
    }

    private static class ExplorerCompletionObserver
    implements CompletionObserver {
        private Component fComp;

        private ExplorerCompletionObserver(Component component) {
            this.fComp = component;
        }

        public void completed(int n, Object object) {
            if (this.fComp != null) {
                DemoUtils.setWaitCursor(this.fComp, false);
            }
        }
    }

    private static class CursorHandler
    implements Runnable {
        private Component fComp;
        private boolean fOn;

        private CursorHandler(Component component, boolean bl) {
            this.fComp = component;
            this.fOn = bl;
        }

        @Override
        public void run() {
            DemoUtils.setWaitCursor(this.fComp, this.fOn);
        }
    }
}

