/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.matlab.api.debug.ExecutionDisplayAdapter;
import com.mathworks.matlab.api.debug.LineDebugState;
import com.mathworks.mde.editor.MatlabExecutionDisplayAdapter;
import com.mathworks.services.editordataservice.Document;
import com.mathworks.services.editordataservice.EditorFeature;
import com.mathworks.services.editordataservice.EditorNode;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ExecutionArrowFeature
extends EditorFeature {
    private String fFileName = "";
    private int fCurrentNumberOfLines = 0;
    private ExecutionDisplayAdapter.RepaintListener fRepaintListener;
    private MatlabExecutionDisplayAdapter fDisplayAdaptor;

    public ExecutionArrowFeature(EditorNode editorNode) {
        super(editorNode);
    }

    void updateExecutionArrowData(MatlabExecutionDisplayAdapter matlabExecutionDisplayAdapter) {
        Map<String, Object> map = ExecutionArrowFeature.getExecutionArrowData(matlabExecutionDisplayAdapter, this.fCurrentNumberOfLines);
        this.updateFeatureData(map);
    }

    public static Map<String, Object> getExecutionArrowData(MatlabExecutionDisplayAdapter matlabExecutionDisplayAdapter, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 1; i <= n; ++i) {
            EnumSet enumSet = matlabExecutionDisplayAdapter.getLineDebugState(i);
            int n2 = i - 1;
            if (enumSet.contains(LineDebugState.TOP_OF_STACK)) {
                arrayList.add(n2);
            }
            if (enumSet.contains(LineDebugState.IN_STACK)) {
                arrayList2.add(n2);
            }
            if (!enumSet.contains(LineDebugState.EXITING_STACK)) continue;
            arrayList3.add(n2);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(LineDebugState.TOP_OF_STACK.toString(), arrayList);
        hashMap.put(LineDebugState.IN_STACK.toString(), arrayList2);
        hashMap.put(LineDebugState.EXITING_STACK.toString(), arrayList3);
        return hashMap;
    }

    public void documentChanged(Document document) {
        this.fCurrentNumberOfLines = document.getNumberOfLines();
        if (this.fFileName.isEmpty() && !document.getText().isEmpty()) {
            this.fFileName = document.getUniqueId();
            this.initializeExecutionAdaptor();
        }
    }

    private void initializeExecutionAdaptor() {
        this.fDisplayAdaptor = new MatlabExecutionDisplayAdapter(new File(this.fFileName));
        this.fRepaintListener = this.createRepaintListener(this.fDisplayAdaptor);
        this.fDisplayAdaptor.addListener(this.fRepaintListener);
        this.updateExecutionArrowData(this.fDisplayAdaptor);
    }

    private ExecutionDisplayAdapter.RepaintListener createRepaintListener(final MatlabExecutionDisplayAdapter matlabExecutionDisplayAdapter) {
        return new ExecutionDisplayAdapter.RepaintListener(){

            public void repaintNeeded() {
                ExecutionArrowFeature.this.updateExecutionArrowData(matlabExecutionDisplayAdapter);
            }
        };
    }

    public String getFeatureId() {
        return "matlab.debug.executionarrow";
    }

    public void dispose() {
        if (this.fDisplayAdaptor != null) {
            this.fDisplayAdaptor.removeListener(this.fRepaintListener);
            this.fDisplayAdaptor.dispose();
        }
    }
}

