/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.editordataservice;

import com.mathworks.services.editordataservice.Document;
import com.mathworks.services.editordataservice.EditorFeature;
import com.mathworks.services.editordataservice.EditorNode;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;

public class EditorMatlabFunctionsFeature
extends EditorFeature {
    public EditorMatlabFunctionsFeature(EditorNode editorNode) {
        super(editorNode);
    }

    public void documentChanged(Document document) {
        final String string = document.getText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> map = null;
                try {
                    map = EditorMatlabFunctionsFeature.buildFunctionsMap(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                EditorMatlabFunctionsFeature.this.updateFeatureData(map);
            }
        });
    }

    public static Map<String, Object> buildFunctionsMap(String string) throws BadLocationException {
        int[] nArray;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList arrayList = new ArrayList();
        BaseDocument baseDocument = new BaseDocument(new MLanguage().createDefaultKit().getClass(), false);
        baseDocument.insertString(0, string, null);
        for (int n : nArray = MDocumentUtils.getZeroBasedLineNumbersOfFunctions((BaseDocument)baseDocument)) {
            String string2 = MDocumentUtils.getFunctionName((BaseDocument)baseDocument, (int)n);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("functionName", string2);
            hashMap2.put("lineNumber", Integer.toString(n));
            arrayList.add(hashMap2);
            Collections.sort(arrayList, EditorMatlabFunctionsFeature.createFunctionsComparator());
        }
        hashMap.put("functions", arrayList);
        return hashMap;
    }

    private static Comparator<Map<String, String>> createFunctionsComparator() {
        return new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> map, Map<String, String> map2) {
                String string = map.get("functionName");
                String string2 = map2.get("functionName");
                if (string == null || string2 == null) {
                    return 0;
                }
                return string.compareTo(string2);
            }
        };
    }

    public String getFeatureId() {
        return "matlab.code.functions";
    }
}

