/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.codepad;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.MatlabEditorApplication;
import com.mathworks.mde.editor.codepad.Codepad;
import com.mathworks.mde.editor.codepad.CodepadAction;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolSet;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;

public final class CodepadActionManager {
    private static final String CODEPAD_INC_FIELD_KEY = "codepad-increment-field";
    private static final String CODEPAD_MULT_FIELD_KEY = "codepad-multiply-field";
    private static final String ENABLE_CODEPAD = EditorUtils.lookup("menuitem.Codepad.CodepadModeOff");
    private static final String DISABLE_CODEPAD = EditorUtils.lookup("menuitem.Codepad.CodepadModeOn");
    private static final EditorAction.ObservableAction sCodepadEvalCellAction = CodepadAction.CODEPAD_EVALUATE_CELL.getAction();
    private static final EditorAction.ObservableAction sCodepadEvalCellAdvanceAction = CodepadAction.CODEPAD_EVALUATE_CELL_ADVANCE.getAction();
    private final ChildAction fCodepadEvalCellInstanceAction = new ChildAction((Action)((Object)sCodepadEvalCellAction), false);
    private final ChildAction fCodepadEvalCellAdvanceInstanceAction = new ChildAction((Action)((Object)sCodepadEvalCellAdvanceAction), false);
    private final EditorAction.ObservableAction fCodepadEvalFileAction = CodepadAction.CODEPAD_EVALUATE_FILE.getAction();
    private final EditorAction.ObservableAction fCodepadNextAction = CodepadAction.CODEPAD_NEXT_CELL.getAction();
    private final EditorAction.ObservableAction fCodepadPrevAction = CodepadAction.CODEPAD_PREVIOUS_CELL.getAction();
    private final EditorAction.ObservableAction fCodepadPlusAction = CodepadAction.CODEPAD_PLUS.getAction();
    private final EditorAction.ObservableAction fCodepadMinusAction = CodepadAction.CODEPAD_MINUS.getAction();
    private final EditorAction.ObservableAction fCodepadMultiplyAction = CodepadAction.CODEPAD_MULTIPLY.getAction();
    private final EditorAction.ObservableAction fCodepadDivideAction = CodepadAction.CODEPAD_DIVIDE.getAction();
    private final EditorAction.ObservableAction fCodepadIncreaseAddAction = CodepadAction.CODEPAD_INCREASE_ADD.getAction();
    private final EditorAction.ObservableAction fCodepadDecreaseAddAction = CodepadAction.CODEPAD_DECREASE_ADD.getAction();
    private final EditorAction.ObservableAction fCodepadIncreaseMultAction = CodepadAction.CODEPAD_INCREASE_MULT.getAction();
    private final EditorAction.ObservableAction fCodepadDecreaseMultAction = CodepadAction.CODEPAD_DECREASE_MULT.getAction();
    private final EditorAction.ObservableAction fCodepadAddDividerAction = CodepadAction.CODEPAD_ADD_DIVIDER.getAction();
    private final EditorAction.ObservableAction fCodepadCreateCellAction = CodepadAction.CODEPAD_CREATE_CELL.getAction();
    private final EditorAction.ObservableAction fCodepadCellTitleAction = CodepadAction.CODEPAD_SHOW_CELL_TITLES.getAction();
    private final EditorAction.ObservableAction fCodepadCreateTitleAction = CodepadAction.CODEPAD_CREATE_TITLE.getAction();
    private final EditorAction.ObservableAction fCodepadCreateTitleNoCellBreakAction = CodepadAction.CODEPAD_CREATE_TITLE_NO_CELL_BREAK.getAction();
    private final EditorAction.ObservableAction fCodepadDocumentTitleAction = CodepadAction.CODEPAD_DOCUMENT_TITLE.getAction();
    private final EditorAction.ObservableAction fCodepadForceSnapshotAction = CodepadAction.CODEPAD_FORCE_SNAPSHOT.getAction();
    private final EditorAction.ObservableAction fCodepadHyperlinkAction = CodepadAction.CODEPAD_HYPERLINK.getAction();
    private final EditorAction.ObservableAction fCodepadBoldTextAction = CodepadAction.CODEPAD_BOLD_TEXT.getAction();
    private final EditorAction.ObservableAction fCodepadItalicTextAction = CodepadAction.CODEPAD_ITALIC_TEXT.getAction();
    private final EditorAction.ObservableAction fCodepadMonoTextAction = CodepadAction.CODEPAD_MONO_TEXT.getAction();
    private final EditorAction.ObservableAction fCodepadBulletListAction = CodepadAction.CODEPAD_BULLET_LIST.getAction();
    private final EditorAction.ObservableAction fCodepadPreformattedAction = CodepadAction.CODEPAD_PREFORMATTED.getAction();
    private final EditorAction.ObservableAction fCodepadSampleCodeAction = CodepadAction.CODEPAD_SAMPLE_CODE.getAction();
    private final EditorAction.ObservableAction fCodepadTexEqAction = CodepadAction.CODEPAD_TEX_EQUATION.getAction();
    private final EditorAction.ObservableAction fCodepadHtmlMarkupAction = CodepadAction.CODEPAD_HTML_MARKUP.getAction();
    private final EditorAction.ObservableAction fCodepadImageTextAction = CodepadAction.CODEPAD_IMAGE.getAction();
    private final EditorAction.ObservableAction fCodepadLatexMarkupAction = CodepadAction.CODEPAD_LATEX_MARKUP.getAction();
    private final EditorAction.ObservableAction fCodepadLatexInlineMathAction = CodepadAction.CODEPAD_LATEX_INLINE_MATH.getAction();
    private final EditorAction.ObservableAction fCodepadNumberedListAction = CodepadAction.CODEPAD_NUMBERED_LIST.getAction();
    private final EditorAction.ObservableAction fCodepadDemoAction = CodepadAction.CODEPAD_DEMO.getAction();
    private final MJTextField fIncField = CodepadActionManager.createTextField(1.0);
    private final MJTextField fMultField;
    private MInputMap fCodepadInputMap;
    private MInputMap fEmptyInputMap;

    public static void groupOpened(Desktop desktop) {
        desktop.addAction((Action)((Object)sCodepadEvalCellAction));
        desktop.addAction((Action)((Object)sCodepadEvalCellAdvanceAction));
    }

    public static void groupClosed(Desktop desktop) {
        desktop.removeAction((Action)((Object)sCodepadEvalCellAction));
        desktop.removeAction((Action)((Object)sCodepadEvalCellAdvanceAction));
    }

    public CodepadActionManager() {
        this.fIncField.setName("CodepadIncrementTextField");
        this.fIncField.getAccessibleContext().setAccessibleName(EditorUtils.lookup("editor.acc.CodepadIncrement"));
        this.fMultField = CodepadActionManager.createTextField(1.1);
        this.fMultField.setName("CodepadMultiplyTextField");
        this.fMultField.getAccessibleContext().setAccessibleName(EditorUtils.lookup("editor.acc.CodepadMultiply"));
    }

    public void cleanup() {
        this.fCodepadEvalCellInstanceAction.setParent(null);
        this.fCodepadEvalCellAdvanceInstanceAction.setParent(null);
    }

    private static MJTextField createTextField(double d) {
        return CodepadActionManager.createTextField(Double.toString(d), true);
    }

    private static MJTextField createTextField(String string, boolean bl) {
        MJTextField mJTextField = new MJTextField(string){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 40;
                return dimension;
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        mJTextField.setEnabled(bl);
        return mJTextField;
    }

    void enableCodepadValueActions(boolean bl) {
        this.fCodepadPlusAction.setEnabled(bl);
        this.fCodepadMinusAction.setEnabled(bl);
        this.fCodepadMultiplyAction.setEnabled(bl);
        this.fCodepadDivideAction.setEnabled(bl);
    }

    private Collection<MJAbstractAction> getCodepadInputActions() {
        LinkedList<MJAbstractAction> linkedList = new LinkedList<MJAbstractAction>();
        linkedList.add(this.fCodepadPrevAction);
        linkedList.add(this.fCodepadNextAction);
        linkedList.add(this.fCodepadIncreaseAddAction);
        linkedList.add(this.fCodepadDecreaseAddAction);
        linkedList.add(this.fCodepadIncreaseMultAction);
        linkedList.add(this.fCodepadDecreaseMultAction);
        linkedList.add(this.fCodepadPlusAction);
        linkedList.add(this.fCodepadMinusAction);
        linkedList.add(this.fCodepadMultiplyAction);
        linkedList.add(this.fCodepadDivideAction);
        if (MLDesktop.getInstance().useToolstrip()) {
            MJAbstractAction[] mJAbstractActionArray;
            for (MJAbstractAction mJAbstractAction : mJAbstractActionArray = this.getInsertActions()) {
                if (mJAbstractAction == null) continue;
                linkedList.add(mJAbstractAction);
            }
            linkedList.add((MJAbstractAction)this.fCodepadEvalCellInstanceAction);
        }
        return linkedList;
    }

    void observeCodepadActions(Observer observer) {
        this.fCodepadEvalFileAction.setObserver(observer);
        this.fCodepadNextAction.setObserver(observer);
        this.fCodepadPrevAction.setObserver(observer);
        this.fCodepadPlusAction.setObserver(observer);
        this.fCodepadMinusAction.setObserver(observer);
        this.fCodepadMultiplyAction.setObserver(observer);
        this.fCodepadDivideAction.setObserver(observer);
        this.fCodepadIncreaseAddAction.setObserver(observer);
        this.fCodepadDecreaseAddAction.setObserver(observer);
        this.fCodepadIncreaseMultAction.setObserver(observer);
        this.fCodepadDecreaseMultAction.setObserver(observer);
        this.fCodepadAddDividerAction.setObserver(observer);
        this.fCodepadCreateCellAction.setObserver(observer);
        this.fCodepadCellTitleAction.setObserver(observer);
        this.fCodepadCreateTitleAction.setObserver(observer);
        this.fCodepadCreateTitleNoCellBreakAction.setObserver(observer);
        this.fCodepadDocumentTitleAction.setObserver(observer);
        this.fCodepadForceSnapshotAction.setObserver(observer);
        this.fCodepadHyperlinkAction.setObserver(observer);
        this.fCodepadBoldTextAction.setObserver(observer);
        this.fCodepadItalicTextAction.setObserver(observer);
        this.fCodepadMonoTextAction.setObserver(observer);
        this.fCodepadBulletListAction.setObserver(observer);
        this.fCodepadPreformattedAction.setObserver(observer);
        this.fCodepadSampleCodeAction.setObserver(observer);
        this.fCodepadTexEqAction.setObserver(observer);
        this.fCodepadHtmlMarkupAction.setObserver(observer);
        this.fCodepadImageTextAction.setObserver(observer);
        this.fCodepadLatexMarkupAction.setObserver(observer);
        this.fCodepadLatexInlineMathAction.setObserver(observer);
        this.fCodepadNumberedListAction.setObserver(observer);
        this.fCodepadDemoAction.setObserver(observer);
    }

    void enableCodepadSelectionDependentActions(boolean bl) {
        this.fCodepadCreateCellAction.setEnabled(bl);
        this.fCodepadAddDividerAction.setEnabled(!bl);
    }

    static void codepadModeToggled(boolean bl) {
        sCodepadEvalCellAction.setEnabled(bl);
        sCodepadEvalCellAdvanceAction.setEnabled(bl);
    }

    void enableCodepadActions(boolean bl, boolean bl2, boolean bl3) {
        this.fCodepadEvalCellInstanceAction.setEnabled(bl);
        this.fCodepadEvalCellAdvanceInstanceAction.setEnabled(bl);
        this.fCodepadEvalFileAction.setEnabled(bl);
        this.fCodepadNextAction.setEnabled(bl);
        this.fCodepadPrevAction.setEnabled(bl);
        this.fCodepadPlusAction.setEnabled(bl && bl3);
        this.fCodepadMinusAction.setEnabled(bl && bl3);
        this.fCodepadMultiplyAction.setEnabled(bl && bl3);
        this.fCodepadDivideAction.setEnabled(bl && bl3);
        this.fCodepadIncreaseAddAction.setEnabled(bl);
        this.fCodepadDecreaseAddAction.setEnabled(bl);
        this.fCodepadIncreaseMultAction.setEnabled(bl);
        this.fCodepadDecreaseMultAction.setEnabled(bl);
        this.fCodepadAddDividerAction.setEnabled(bl && !bl2);
        this.fCodepadCreateCellAction.setEnabled(bl && bl2);
        this.fCodepadCellTitleAction.setEnabled(bl);
        this.fCodepadCreateTitleAction.setEnabled(bl);
        this.fCodepadCreateTitleNoCellBreakAction.setEnabled(bl);
        this.fCodepadDocumentTitleAction.setEnabled(bl);
        this.fCodepadForceSnapshotAction.setEnabled(bl);
        this.fCodepadHyperlinkAction.setEnabled(bl);
        this.fCodepadBoldTextAction.setEnabled(bl);
        this.fCodepadItalicTextAction.setEnabled(bl);
        this.fCodepadMonoTextAction.setEnabled(bl);
        this.fCodepadBulletListAction.setEnabled(bl);
        this.fCodepadPreformattedAction.setEnabled(bl);
        this.fCodepadSampleCodeAction.setEnabled(bl);
        this.fCodepadTexEqAction.setEnabled(bl);
        this.fCodepadHtmlMarkupAction.setEnabled(bl);
        this.fCodepadImageTextAction.setEnabled(bl);
        this.fCodepadLatexMarkupAction.setEnabled(bl);
        this.fCodepadLatexInlineMathAction.setEnabled(bl);
        this.fCodepadNumberedListAction.setEnabled(bl);
        this.fCodepadDemoAction.setEnabled(bl);
        this.fIncField.setEnabled(bl);
        this.fMultField.setEnabled(bl);
        if (this.fEmptyInputMap != null && this.fCodepadInputMap != null) {
            this.fEmptyInputMap.setParent((InputMap)(bl ? this.fCodepadInputMap : this.fCodepadInputMap.getParent()));
        }
    }

    public void enableCodepadMFileActions(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl2) {
            this.enableCodepadActions(bl, bl3, bl4);
        } else {
            this.enableCodepadActions(false, bl3, bl4);
        }
    }

    public void addComponentActions(MInputMap mInputMap, ActionMap actionMap) {
        this.fEmptyInputMap = mInputMap;
        Collection<MJAbstractAction> collection = this.getCodepadInputActions();
        this.createInputMaps(!collection.isEmpty());
        for (MJAbstractAction mJAbstractAction : collection) {
            actionMap.put(mJAbstractAction.getValue("ActionCommandKey"), (Action)mJAbstractAction);
            MatlabKeyBindings.getManager().addKeyBindings("MATLABEditor", mJAbstractAction.getActionID(), (ExtendedInputMap)this.fCodepadInputMap);
        }
    }

    private void createInputMaps(boolean bl) {
        if (bl) {
            this.fCodepadInputMap = new MInputMap();
            this.fCodepadInputMap.setParent(this.fEmptyInputMap.getParent());
        } else {
            this.fCodepadInputMap = null;
        }
    }

    public static void addToToolBar(List<DTToolBarInfo> list, CodepadActionManager codepadActionManager) {
        DTToolSet dTToolSet = CodepadActionManager.buildToolSet(codepadActionManager);
        DTToolBarConfiguration dTToolBarConfiguration = CodepadActionManager.buildToolBarConfiguration();
        list.add(1, new DTToolBarInfo("Codepad", EditorUtils.lookup("codepad.toolbarName"), dTToolSet, dTToolBarConfiguration));
    }

    private static DTToolSet buildToolSet(CodepadActionManager codepadActionManager) {
        DTToolSet dTToolSet = new DTToolSet(){

            public boolean includeLabelOnBar(String string) {
                return false;
            }
        };
        dTToolSet.add(CodepadAction.CODEPAD_NEXT_CELL.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_NEXT_CELL.createDummyAction() : codepadActionManager.fCodepadNextAction));
        dTToolSet.add(CodepadAction.CODEPAD_PREVIOUS_CELL.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_PREVIOUS_CELL.createDummyAction() : codepadActionManager.fCodepadPrevAction));
        dTToolSet.add(CodepadAction.CODEPAD_EVALUATE_CELL.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_EVALUATE_CELL.createDummyAction() : codepadActionManager.fCodepadEvalCellInstanceAction));
        dTToolSet.add(CodepadAction.CODEPAD_EVALUATE_CELL_ADVANCE.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_EVALUATE_CELL_ADVANCE.createDummyAction() : codepadActionManager.fCodepadEvalCellAdvanceInstanceAction));
        dTToolSet.add(CodepadAction.CODEPAD_EVALUATE_FILE.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_EVALUATE_FILE.createDummyAction() : codepadActionManager.fCodepadEvalFileAction));
        dTToolSet.add(CodepadAction.CODEPAD_MINUS.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_MINUS.createDummyAction() : codepadActionManager.fCodepadMinusAction));
        dTToolSet.add(CODEPAD_INC_FIELD_KEY, EditorUtils.lookup("codepad.inc-field.name"), (Component)(codepadActionManager == null ? CodepadActionManager.createTextField("", false) : codepadActionManager.fIncField), null);
        dTToolSet.add(CodepadAction.CODEPAD_PLUS.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_PLUS.createDummyAction() : codepadActionManager.fCodepadPlusAction));
        dTToolSet.add(CodepadAction.CODEPAD_DIVIDE.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_DIVIDE.createDummyAction() : codepadActionManager.fCodepadDivideAction));
        dTToolSet.add(CODEPAD_MULT_FIELD_KEY, EditorUtils.lookup("codepad.mult-field.name"), (Component)(codepadActionManager == null ? CodepadActionManager.createTextField("", false) : codepadActionManager.fMultField), null);
        dTToolSet.add(CodepadAction.CODEPAD_MULTIPLY.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_MULTIPLY.createDummyAction() : codepadActionManager.fCodepadMultiplyAction));
        dTToolSet.add(CodepadAction.CODEPAD_ADD_DIVIDER.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_ADD_DIVIDER.createDummyAction() : codepadActionManager.fCodepadAddDividerAction));
        dTToolSet.add(CodepadAction.CODEPAD_SHOW_CELL_TITLES.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_SHOW_CELL_TITLES.createDummyAction() : codepadActionManager.fCodepadCellTitleAction));
        dTToolSet.add(CodepadAction.CODEPAD_DEMO.getActionId(), (Action)(codepadActionManager == null ? CodepadAction.CODEPAD_DEMO.createDummyAction() : codepadActionManager.fCodepadDemoAction));
        return dTToolSet;
    }

    private static DTToolBarConfiguration buildToolBarConfiguration() {
        List<String> list = Arrays.asList(CodepadAction.CODEPAD_EVALUATE_CELL.getActionId(), CodepadAction.CODEPAD_EVALUATE_CELL_ADVANCE.getActionId(), "Tool Bar Separator Key", CodepadAction.CODEPAD_MINUS.getActionId(), CODEPAD_INC_FIELD_KEY, CodepadAction.CODEPAD_PLUS.getActionId(), "Tool Bar Separator Key", CodepadAction.CODEPAD_DIVIDE.getActionId(), CODEPAD_MULT_FIELD_KEY, CodepadAction.CODEPAD_MULTIPLY.getActionId(), "Tool Bar Separator Key", CodepadAction.CODEPAD_ADD_DIVIDER.getActionId(), CodepadAction.CODEPAD_SHOW_CELL_TITLES.getActionId(), "Tool Bar Separator Key", CodepadAction.CODEPAD_DEMO.getActionId());
        return new DTToolBarConfiguration(list);
    }

    MJMenu createCodepadInsertMenu() {
        MJMenu mJMenu = new MJMenu(EditorUtils.lookup("menu.Codepad.InsertMenu"));
        mJMenu.add((Action)((Object)this.fCodepadDocumentTitleAction));
        mJMenu.add((Action)((Object)this.fCodepadCreateTitleAction));
        mJMenu.add((Action)((Object)this.fCodepadCreateTitleNoCellBreakAction));
        mJMenu.addSeparator();
        mJMenu.add((Action)((Object)this.fCodepadBoldTextAction));
        mJMenu.add((Action)((Object)this.fCodepadItalicTextAction));
        mJMenu.add((Action)((Object)this.fCodepadMonoTextAction));
        mJMenu.add((Action)((Object)this.fCodepadHyperlinkAction));
        mJMenu.add((Action)((Object)this.fCodepadLatexInlineMathAction));
        mJMenu.addSeparator();
        mJMenu.add((Action)((Object)this.fCodepadPreformattedAction));
        mJMenu.add((Action)((Object)this.fCodepadSampleCodeAction));
        mJMenu.add((Action)((Object)this.fCodepadImageTextAction));
        mJMenu.add((Action)((Object)this.fCodepadBulletListAction));
        mJMenu.add((Action)((Object)this.fCodepadNumberedListAction));
        mJMenu.add((Action)((Object)this.fCodepadHtmlMarkupAction));
        mJMenu.add((Action)((Object)this.fCodepadLatexMarkupAction));
        mJMenu.add((Action)((Object)this.fCodepadTexEqAction));
        mJMenu.addSeparator();
        mJMenu.add((Action)((Object)this.fCodepadForceSnapshotAction));
        return mJMenu;
    }

    public MJAbstractAction[] getInsertActions() {
        return new MJAbstractAction[]{this.fCodepadAddDividerAction, this.fCodepadCreateCellAction, this.fCodepadDocumentTitleAction, this.fCodepadCreateTitleAction, this.fCodepadCreateTitleNoCellBreakAction, null, this.fCodepadBoldTextAction, this.fCodepadItalicTextAction, this.fCodepadMonoTextAction, this.fCodepadHyperlinkAction, this.fCodepadLatexInlineMathAction, null, this.fCodepadPreformattedAction, this.fCodepadSampleCodeAction, this.fCodepadImageTextAction, this.fCodepadBulletListAction, this.fCodepadNumberedListAction, this.fCodepadHtmlMarkupAction, this.fCodepadLatexMarkupAction, this.fCodepadTexEqAction, null, this.fCodepadForceSnapshotAction};
    }

    double getIncrementValue() throws ParseException {
        return Codepad.NUMERIC_FORMAT.parse(this.fIncField.getText()).doubleValue();
    }

    Action getPlusAction() {
        return this.fCodepadPlusAction;
    }

    Action getMinusAction() {
        return this.fCodepadMinusAction;
    }

    MJTextField getIncrementField() {
        return this.fIncField;
    }

    double getMultiplyValue() throws ParseException {
        return Codepad.NUMERIC_FORMAT.parse(this.fMultField.getText()).doubleValue();
    }

    Action getDivideAction() {
        return this.fCodepadDivideAction;
    }

    Action getMultiplyAction() {
        return this.fCodepadMultiplyAction;
    }

    MJTextField getMultiplyField() {
        return this.fMultField;
    }

    void increaseAddInc() {
        try {
            double d = 2.0 * Codepad.NUMERIC_FORMAT.parse(this.fIncField.getText()).doubleValue();
            this.fIncField.setText(Codepad.NUMERIC_FORMAT.format(d));
            this.fIncField.revalidate();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    void decreaseAddInc() {
        try {
            double d = 0.5 * Codepad.NUMERIC_FORMAT.parse(this.fIncField.getText()).doubleValue();
            this.fIncField.setText(Codepad.NUMERIC_FORMAT.format(d));
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    void increaseMultInc() {
        try {
            double d = 0.1 + Codepad.NUMERIC_FORMAT.parse(this.fMultField.getText()).doubleValue();
            this.fMultField.setText(Codepad.NUMERIC_FORMAT.format(d));
            this.fMultField.revalidate();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    void decreaseMultInc() {
        try {
            double d = Codepad.NUMERIC_FORMAT.parse(this.fMultField.getText()).doubleValue() - 0.1;
            this.fMultField.setText(Codepad.NUMERIC_FORMAT.format(d));
            this.fMultField.revalidate();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    public Action getEvaluateCellAction() {
        return this.fCodepadEvalCellInstanceAction;
    }

    public Action getEvaluateCellAdvanceAction() {
        return this.fCodepadEvalCellAdvanceInstanceAction;
    }

    public Action getEvaluateFileAction() {
        return this.fCodepadEvalFileAction;
    }

    public Action getAddDividerAction() {
        return this.fCodepadAddDividerAction;
    }

    Action getCreateCellAction() {
        return this.fCodepadCreateCellAction;
    }

    public Action getNextAction() {
        return this.fCodepadNextAction;
    }

    public Action getPreviousAction() {
        return this.fCodepadPrevAction;
    }

    public Action getDocumentTitleAction() {
        return this.fCodepadDocumentTitleAction;
    }

    public Action getSectionTitleAction() {
        return this.fCodepadCreateTitleAction;
    }

    public Action getSectionTitleNoBreakAction() {
        return this.fCodepadCreateTitleNoCellBreakAction;
    }

    public Action getBoldTextAction() {
        return this.fCodepadBoldTextAction;
    }

    public Action getItalicTextAction() {
        return this.fCodepadItalicTextAction;
    }

    public Action getMonospacedTextAction() {
        return this.fCodepadMonoTextAction;
    }

    public Action getLatexInlineMathAction() {
        return this.fCodepadLatexInlineMathAction;
    }

    public Action getHyperlinkTextAction() {
        return this.fCodepadHyperlinkAction;
    }

    public Action getPreformattedTextAction() {
        return this.fCodepadPreformattedAction;
    }

    public Action getSampleCodeAction() {
        return this.fCodepadSampleCodeAction;
    }

    public Action getImageAction() {
        return this.fCodepadImageTextAction;
    }

    public Action getBulletedListAction() {
        return this.fCodepadBulletListAction;
    }

    public Action getNumberedListAction() {
        return this.fCodepadNumberedListAction;
    }

    public Action getHtmlMarkupAction() {
        return this.fCodepadHtmlMarkupAction;
    }

    public Action getLatexMarkupAction() {
        return this.fCodepadLatexMarkupAction;
    }

    public Action getLatexDisplayMath() {
        return this.fCodepadTexEqAction;
    }

    public Action getForceSnapshotAction() {
        return this.fCodepadForceSnapshotAction;
    }

    public static CodepadActionManager getCodepadActionManager(Editor editor) {
        return CodepadActionManager.getCodepad(editor).getActionManager();
    }

    private static Codepad getCodepad(Editor editor) {
        Codepad codepad = (Codepad)editor.getProperty((Object)"Codepad");
        assert (codepad != null) : "Codepad was not properly installed";
        return codepad;
    }

    static {
        Observer observer = new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                ActionEvent actionEvent = (ActionEvent)object;
                int n = actionEvent.getID();
                Editor editor = MatlabEditorApplication.getInstance().getActiveEditor();
                if (editor != null && editor.isMCode()) {
                    CodepadActionManager.getCodepad(editor).evalCurrentCell(n == CodepadAction.CODEPAD_EVALUATE_CELL_ADVANCE.getId());
                }
            }
        };
        sCodepadEvalCellAction.setObserver(observer);
        sCodepadEvalCellAdvanceAction.setObserver(observer);
    }
}

