/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.EditorToolSetFactory;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.dialog.PathChange;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.ToolTipProvider;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;

public class ProfilerButton {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(ProfilerButton.class.getPackage().getName() + ".resources.RES_Editor_Toolstrip");
    private final TSToolSet fToolSet;
    private final Editor fEditor;

    public ProfilerButton(@NotNull TSToolSet tSToolSet, @NotNull Editor editor) {
        this.fToolSet = tSToolSet;
        this.fEditor = editor;
    }

    public void populate() {
        Action action = this.createAction();
        action.putValue("toolTipProvider", this.createToolTipProvider());
        this.fToolSet.addDecorator("run_and_time", EditorToolSetFactory.createToolTipRegistrationDecorator());
        this.fToolSet.configureAndAdd("run_and_time", action);
    }

    private ToolTipProvider createToolTipProvider() {
        return new ToolTipProvider(){

            public String getToolTipText() {
                if (ProfilerButton.this.fEditor.getStorageLocation() instanceof FileStorageLocation) {
                    return MessageFormat.format(BUNDLE.getString("profiler.tooltip"), ProfilerButton.this.getExpressionToRun());
                }
                return BUNDLE.getString("Tool.run_and_time.Description");
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return this.getToolTipText();
            }
        };
    }

    private Action createAction() {
        return new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProfilerButton.this.fEditor.negotiateSave() && ProfilerButton.this.fEditor.getStorageLocation() instanceof FileStorageLocation) {
                    File file = MatlabPluginUtils.getBackingFile(ProfilerButton.this.fEditor);
                    new PathChange(EditorUiUtils.getParentFrame(ProfilerButton.this.fEditor.getComponent()), EditorUtils.EDITOR_TITLE, EditorUtils.lookup("msg.ToRun"), file.getAbsolutePath(), file, new CompletionObserver(){

                        public void completed(int n, Object object) {
                            ProfilerButton.this.runProfiler();
                        }
                    }, "ml_env_ed");
                }
            }
        };
    }

    private void runProfiler() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerButton.runProfiler(ProfilerButton.this.getExpressionToRun());
            }
        });
    }

    private String getExpressionToRun() {
        File file = MatlabPluginUtils.getBackingFile(this.fEditor);
        RunConfiguration runConfiguration = (RunConfiguration)ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(file, RunConfiguration.TYPE);
        return runConfiguration.getMatlabExpressionToRun();
    }

    private static void runProfiler(String string) {
        final Matlab matlab = new Matlab();
        matlab.evalConsoleOutput("profile on");
        MLExecuteServices.executeCommand((String)string);
        matlab.eval("profile viewer", new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
                if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) != 0) {
                    matlab.evalConsoleOutput("profile off");
                }
            }
        });
    }
}

