/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.debug.ExecutionArrowMargin;
import com.mathworks.matlab.api.debug.ExecutionDisplayAdapter;
import com.mathworks.matlab.api.debug.LineDebugState;
import com.mathworks.matlab.api.debug.ViewProvider;
import com.mathworks.matlab.api.debug.ViewProviderKey;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.MWEditorUIUtils;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.ViewHierarchyChangeEvent;
import com.mathworks.widgets.text.ViewHierarchyChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.EditorUI;

public class ExecutionArrowDisplay
implements ViewProvider,
ExecutionArrowMargin {
    private List<Integer> fBookmarks = new ArrayList<Integer>();
    private STPInterface fSyntaxPane;
    private TextEventHandler fTextListener = new TextEventHandler();
    private GutterClicker fGutterClicker = new GutterClicker();
    private static Color sArrowColor = Color.green;
    private static Color sBookmarkColor = Color.cyan;
    private static Color sBorderColor = Color.black;
    private Color fBackgroundColor;
    private Map<ViewProviderKey, ExecutionPanel> fExecutionPanels = new HashMap<ViewProviderKey, ExecutionPanel>();
    private ViewHierarchyChangeListener viewHierarchyChangeListener;
    private final ExecutionDisplayAdapter.RepaintListener fRepaintListener = this.createRepaintListener();
    private Map<Class<? extends ExecutionDisplayAdapter>, ExecutionDisplayAdapter> fExecutionDisplayAdapterDecorations = new HashMap<Class<? extends ExecutionDisplayAdapter>, ExecutionDisplayAdapter>();

    public ExecutionArrowDisplay(STPInterface sTPInterface, ExecutionDisplayAdapter executionDisplayAdapter) {
        Validate.notNull((Object)sTPInterface, (String)"STPInterface should not be null");
        Validate.notNull((Object)executionDisplayAdapter, (String)"debugAdapter should not be null");
        this.fSyntaxPane = sTPInterface;
        this.fSyntaxPane.getDocument().addDocumentListener(this.fTextListener);
        this.addExecutionDisplayAdapter(executionDisplayAdapter);
        this.registerViewHierarchyListener();
    }

    private void registerViewHierarchyListener() {
        if (this.viewHierarchyChangeListener == null) {
            this.viewHierarchyChangeListener = new ViewHierarchyChangeListener(){

                public void viewHierarchyChanged(ViewHierarchyChangeEvent viewHierarchyChangeEvent) {
                    Component component = (Component)ExecutionArrowDisplay.this.fExecutionPanels.get(viewHierarchyChangeEvent.getSource());
                    if (component != null) {
                        component.repaint(5L);
                    }
                }
            };
        }
        this.fSyntaxPane.addViewHierarchyChangeListener(this.viewHierarchyChangeListener);
    }

    private void cleanUpViewHierarchyListener() {
        if (this.fSyntaxPane != null) {
            this.fSyntaxPane.removeViewHierarchyChangeListener(this.viewHierarchyChangeListener);
            this.viewHierarchyChangeListener = null;
        }
    }

    public Component getView(ViewProviderKey viewProviderKey) {
        if (this.fExecutionPanels.containsKey(viewProviderKey)) {
            return (Component)((Object)this.fExecutionPanels.get(viewProviderKey));
        }
        ExecutionPanel executionPanel = new ExecutionPanel(viewProviderKey, this.fExecutionPanels.size());
        this.fExecutionPanels.put(viewProviderKey, executionPanel);
        return executionPanel;
    }

    public Component clearView(ViewProviderKey viewProviderKey) {
        ExecutionPanel executionPanel = this.fExecutionPanels.remove(viewProviderKey);
        if (executionPanel instanceof ExecutionPanel) {
            executionPanel.cleanup();
        }
        return (Component)((Object)executionPanel);
    }

    public void setColors(Color color, Color color2) {
        this.fBackgroundColor = color;
        sBorderColor = color2;
        for (ExecutionPanel executionPanel : this.fExecutionPanels.values()) {
            executionPanel.setBackground(color);
            executionPanel.repaint();
        }
    }

    private void repaintAll(int n) {
        for (ExecutionPanel executionPanel : this.fExecutionPanels.values()) {
            executionPanel.repaint(n);
        }
    }

    public void dispose() {
        this.cleanUpViewHierarchyListener();
        this.cleanAllExecutionDisplayAdapterDecorations();
        if (this.fSyntaxPane != null) {
            this.fSyntaxPane.getDocument().removeDocumentListener(this.fTextListener);
            this.fTextListener = null;
        }
        for (ExecutionPanel executionPanel : this.fExecutionPanels.values()) {
            executionPanel.cleanup();
        }
        this.fExecutionPanels.clear();
        this.fGutterClicker = null;
    }

    public void setBookmarks(List<Integer> list) {
        this.fBookmarks = new ArrayList<Integer>();
        for (int i = 0; i != list.size(); ++i) {
            int n = this.fSyntaxPane.getNumLines();
            Integer n2 = list.get(i);
            if (n2 >= n) continue;
            this.fBookmarks.add(n2);
        }
        this.repaintAll(5);
    }

    public List<Integer> getBookmarks() {
        return Collections.unmodifiableList(this.fBookmarks);
    }

    private void adjustBookmarks(DocumentEvent documentEvent, boolean bl) {
        if (this.fBookmarks != null && !this.fBookmarks.isEmpty()) {
            int n = this.fSyntaxPane.getMinLineFromDocEvent(documentEvent);
            int n2 = this.fSyntaxPane.getMaxLineFromDocEvent(documentEvent);
            int n3 = n2 - n;
            if (n3 == 0) {
                return;
            }
            if (bl) {
                int n4;
                for (int i = this.fBookmarks.size() - 1; i >= 0 && (n4 = this.fBookmarks.get(i).intValue()) >= n; --i) {
                    int n5;
                    int n6;
                    block13: {
                        n6 = 0;
                        n5 = 0;
                        try {
                            if (documentEvent.getLength() == 1) {
                                n6 = this.fSyntaxPane.getCharAt(documentEvent.getOffset() + documentEvent.getLength());
                                n5 = this.fSyntaxPane.getCharAt(documentEvent.getOffset());
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block13;
                            badLocationException.printStackTrace();
                        }
                    }
                    if (n2 < n4) {
                        this.fBookmarks.set(i, n4 + n3);
                        continue;
                    }
                    if (n6 == 10 && n5 == 10 && n2 != n4) continue;
                    this.fBookmarks.set(i, n4 + n3);
                }
            } else {
                n3 = -n3;
                for (int i = 0; i < this.fBookmarks.size(); ++i) {
                    int n7 = this.fBookmarks.get(i);
                    if (n7 < n) continue;
                    if (n7 >= n && n7 < n2 && n3 != -1) {
                        this.fBookmarks.remove(i);
                        --i;
                        continue;
                    }
                    if (n3 == -1 && n7 == n) continue;
                    int n8 = -999;
                    if (i > 0) {
                        n8 = this.fBookmarks.get(i - 1);
                    }
                    if (n8 == n7 + n3) {
                        this.fBookmarks.remove(i);
                        --i;
                        continue;
                    }
                    this.fBookmarks.set(i, n7 + n3);
                }
            }
            this.repaintAll(5);
        }
    }

    public void clearBookmarks() {
        if (this.fBookmarks != null) {
            this.fBookmarks.clear();
        }
    }

    public int prevBookmark(int n) {
        int n2;
        int n3 = -1;
        if (this.fBookmarks != null && (n2 = this.fBookmarks.size()) > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                int n4 = this.fBookmarks.get(i);
                if (n <= n4) continue;
                n3 = n4;
                break;
            }
            if (n3 == -1) {
                n3 = this.fBookmarks.get(n2 - 1);
            }
        }
        return n3;
    }

    public int nextBookmark(int n) {
        int n2;
        int n3 = -1;
        if (this.fBookmarks != null && (n2 = this.fBookmarks.size()) > 0) {
            for (int i = 0; i < n2; ++i) {
                int n4 = this.fBookmarks.get(i);
                if (n >= n4) continue;
                n3 = n4;
                break;
            }
            if (n3 == -1) {
                n3 = this.fBookmarks.get(0);
            }
        }
        return n3;
    }

    public void toggleBookmark(int n) {
        int n2 = this.fBookmarks.size();
        if (n2 == 0) {
            this.fBookmarks.add(n);
        } else {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.fBookmarks.get(n3);
                if (n > n4) continue;
                if (n4 == n) {
                    this.fBookmarks.remove(n3);
                    break;
                }
                this.fBookmarks.add(n3, n);
                break;
            }
            if (n3 == n2) {
                this.fBookmarks.add(n);
            }
        }
        this.repaintAll(5);
    }

    public void addExecutionDisplayAdapter(ExecutionDisplayAdapter executionDisplayAdapter) {
        if (this.hasExecutionDisplayAdapterDecoration(executionDisplayAdapter.getClass())) {
            throw new IllegalStateException("ExecutionArrowDisplay is already decorated with ExecutionDisplayAdapter of type: " + executionDisplayAdapter.getClass());
        }
        this.fExecutionDisplayAdapterDecorations.put(executionDisplayAdapter.getClass(), executionDisplayAdapter);
        this.registerRepaintListener(executionDisplayAdapter);
    }

    public void replaceExecutionDisplayAdapter(ExecutionDisplayAdapter executionDisplayAdapter) throws IllegalStateException {
        if (!this.hasExecutionDisplayAdapterDecoration(executionDisplayAdapter.getClass())) {
            throw new IllegalStateException("ExecutionArrowDisplay is not yet decorated with ExecutionDisplayAdapter of type: " + executionDisplayAdapter.getClass());
        }
        this.fExecutionDisplayAdapterDecorations.get(executionDisplayAdapter.getClass()).dispose();
        this.fExecutionDisplayAdapterDecorations.put(executionDisplayAdapter.getClass(), executionDisplayAdapter);
        this.registerRepaintListener(executionDisplayAdapter);
    }

    public boolean hasExecutionDisplayAdapterDecoration(Class<? extends ExecutionDisplayAdapter> clazz) {
        return this.fExecutionDisplayAdapterDecorations.containsKey(clazz);
    }

    public void cleanAllExecutionDisplayAdapterDecorations() {
        for (ExecutionDisplayAdapter executionDisplayAdapter : this.getExecutionAdapters()) {
            executionDisplayAdapter.dispose();
        }
        this.fExecutionDisplayAdapterDecorations.clear();
    }

    private ExecutionDisplayAdapter.RepaintListener createRepaintListener() {
        return new ExecutionDisplayAdapter.RepaintListener(){

            public void repaintNeeded() {
                ExecutionArrowDisplay.this.repaintAll(5);
            }
        };
    }

    private void registerRepaintListener(ExecutionDisplayAdapter executionDisplayAdapter) {
        executionDisplayAdapter.addListener(this.fRepaintListener);
    }

    public List<ExecutionDisplayAdapter> getExecutionAdapters() {
        return new ArrayList<ExecutionDisplayAdapter>(this.fExecutionDisplayAdapterDecorations.values());
    }

    private class ExecutionPanel
    extends MJPanel {
        private ViewProviderKey iKey;

        private ExecutionPanel(ViewProviderKey viewProviderKey, int n) {
            this.iKey = viewProviderKey;
            this.getAccessibleContext().setAccessibleName(EditorUtils.lookup("editor.acc.executionArrow"));
            if (n == 0) {
                this.setName("ExecutionArrowDisplay");
            } else {
                this.setName("ExecutionArrowDisplay" + (n + 1));
            }
            this.addMouseListener(ExecutionArrowDisplay.this.fGutterClicker);
            this.addMouseMotionListener(ExecutionArrowDisplay.this.fGutterClicker);
            if (ExecutionArrowDisplay.this.fBackgroundColor != null) {
                this.setBackground(ExecutionArrowDisplay.this.fBackgroundColor);
            }
        }

        public ViewProviderKey getiKey() {
            return this.iKey;
        }

        private void cleanup() {
            this.removeMouseListener(ExecutionArrowDisplay.this.fGutterClicker);
            this.removeMouseMotionListener(ExecutionArrowDisplay.this.fGutterClicker);
        }

        private int getArrowWidth() {
            assert (ExecutionArrowDisplay.this.fSyntaxPane != null);
            int n = ExecutionArrowDisplay.this.fSyntaxPane.getLineHeight() / 2;
            n = n % 2 == 0 ? n : n + 1;
            return Math.max(10, n);
        }

        public Dimension getPreferredSize() {
            int n = this.getArrowWidth() + 4;
            Dimension dimension = new Dimension();
            dimension.setSize((double)n, super.getPreferredSize().getHeight());
            return dimension;
        }

        private void drawArrowAt(Graphics graphics, int n, EnumSet<LineDebugState> enumSet, int n2) {
            int n3;
            int n4 = (n2 - this.getArrowWidth()) / 2;
            try {
                n3 = MWEditorUIUtils.convertLineNbrToY((int)n, (EditorUI)this.iKey.getEditorUI());
                n3 += ExecutionArrowDisplay.this.fSyntaxPane.getLineHeight();
            }
            catch (BadLocationException badLocationException) {
                Log.logThrowable((Throwable)badLocationException);
                n3 = n * ExecutionArrowDisplay.this.fSyntaxPane.getLineHeight();
            }
            if (n3 == -1) {
                return;
            }
            for (LineDebugState lineDebugState : enumSet) {
                this.drawArrow(graphics, n4, n3, lineDebugState);
            }
        }

        private void drawArrow(Graphics graphics, int n, int n2, LineDebugState lineDebugState) {
            int[] nArray;
            int[] nArray2;
            int n3 = this.getArrowWidth() / 4;
            int[] nArray3 = new int[]{0, n3 * 2, n3 * 2, n3 * 4, n3 * 2, n3 * 2, 0, 0};
            int[] nArray4 = new int[]{-n3 * 2, -n3 * 2, -n3, -n3 * 3, -n3 * 5, -n3 * 4, -n3 * 4, -n3 * 2};
            int[] nArray5 = new int[]{0, n3, n3, n3 * 3, n3 * 3, n3 * 4, n3 * 2, 0};
            int[] nArray6 = new int[]{n3 * 2, n3 * 2, n3 / 2, n3 / 2, n3 * 2, n3 * 2, n3 * 4 + n3 / 2, n3 * 2};
            if (lineDebugState == LineDebugState.EXITING_STACK) {
                n2 -= ExecutionArrowDisplay.this.fSyntaxPane.getLineHeight() / 2 - 4;
                nArray2 = nArray5;
                nArray = nArray6;
            } else {
                n2 -= (ExecutionArrowDisplay.this.fSyntaxPane.getLineHeight() - this.getArrowWidth()) / 2 - 1;
                nArray2 = nArray3;
                nArray = nArray4;
            }
            if (n == 0) {
                ++n;
            }
            int[] nArray7 = new int[nArray2.length];
            int[] nArray8 = new int[nArray.length];
            int n4 = nArray7.length;
            for (int i = 0; i < n4; ++i) {
                nArray7[i] = nArray2[i] + n;
                nArray8[i] = nArray[i] + n2;
            }
            if (lineDebugState == LineDebugState.IN_STACK) {
                graphics.setColor(sBorderColor);
                graphics.drawPolygon(nArray7, nArray8, nArray7.length);
            } else {
                graphics.setColor(sArrowColor);
                graphics.fillPolygon(nArray7, nArray8, nArray7.length);
                graphics.setColor(sBorderColor);
                graphics.drawPolygon(nArray7, nArray8, nArray7.length);
            }
        }

        private void drawBookmarkAt(Graphics graphics, int n, int n2) {
            int n3;
            RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
            Object object = RenderingHints.VALUE_ANTIALIAS_ON;
            try {
                n3 = MWEditorUIUtils.convertLineNbrToY((int)n, (EditorUI)this.iKey.getEditorUI());
            }
            catch (BadLocationException badLocationException) {
                Log.logThrowable((Throwable)badLocationException);
                n3 = n * ExecutionArrowDisplay.this.fSyntaxPane.getLineHeight();
            }
            if (n3 == -1) {
                return;
            }
            int n4 = n2 - 1;
            int n5 = n2 * 3 >> 2;
            int n6 = ExecutionArrowDisplay.this.fSyntaxPane.getLineHeight();
            if (n5 > n6) {
                n5 = n6;
            }
            n3 += (n6 - n5 + 1) / 2;
            graphics.setColor(sBookmarkColor);
            Object object2 = null;
            if (!PlatformInfo.isMacintosh() && (object2 = ((Graphics2D)graphics).getRenderingHint(key)) != null) {
                ((Graphics2D)graphics).setRenderingHint(key, object);
            }
            int n7 = 6;
            int n8 = 0;
            graphics.fillRoundRect(n8, n3, n4, n5, n7, n7);
            graphics.setColor(sBorderColor);
            graphics.drawRoundRect(n8, n3, n4, n5, n7, n7);
            if (!PlatformInfo.isMacintosh() && object2 != null) {
                ((Graphics2D)graphics).setRenderingHint(key, object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(Graphics graphics) {
            JTextComponent jTextComponent;
            View view;
            super.paintComponent(graphics);
            graphics.setFont(this.getFont());
            Rectangle rectangle = graphics.getClipBounds();
            MWEditorUI mWEditorUI = (MWEditorUI)this.iKey.getEditorUI();
            if (mWEditorUI != null && mWEditorUI.getComponent() != null && (view = MWEditorUIUtils.getRootView((JTextComponent)(jTextComponent = mWEditorUI.getComponent()))) != null) {
                Element element = view.getElement();
                AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
                abstractDocument.readLock();
                try {
                    int n;
                    Rectangle rectangle2 = null;
                    try {
                        n = MWEditorUIUtils.getViewIndexFromY((int)rectangle.y, (EditorUI)this.iKey.getEditorUI());
                        rectangle2 = jTextComponent.getUI().modelToView(jTextComponent, view.getView(n).getStartOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logThrowable((Throwable)badLocationException);
                        n = 0;
                    }
                    int n2 = view.getViewCount();
                    int n3 = rectangle2 == null ? 0 : rectangle2.y;
                    int n4 = rectangle.y + rectangle.height;
                    for (int i = n; i < n2; ++i) {
                        View view2 = view.getView(i);
                        int n5 = element.getElementIndex(view2.getStartOffset());
                        if (this.isBookMarkExist(n5)) {
                            this.drawBookmarkAt(graphics, n5, this.getWidth());
                        }
                        for (ExecutionDisplayAdapter executionDisplayAdapter : ExecutionArrowDisplay.this.getExecutionAdapters()) {
                            if (executionDisplayAdapter.getLineDebugState(n5 + 1).contains(LineDebugState.NOT_ON_STACK)) continue;
                            this.drawArrowAt(graphics, n5, executionDisplayAdapter.getLineDebugState(n5 + 1), this.getWidth());
                        }
                        if ((n3 += this.iKey.getEditorUI().getLineHeight()) < n4) continue;
                        break;
                    }
                }
                finally {
                    abstractDocument.readUnlock();
                }
            }
        }

        private boolean isBookMarkExist(int n) {
            return ExecutionArrowDisplay.this.fBookmarks.contains(n);
        }
    }

    private class GutterClicker
    extends MouseAdapter {
        private GutterClicker() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ExecutionPanel executionPanel = (ExecutionPanel)((Object)mouseEvent.getSource());
            executionPanel.getiKey().requestFocusInWindow();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                final MouseEvent mouseEvent2 = mouseEvent;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (mouseEvent2.isShiftDown()) {
                                ExecutionArrowDisplay.this.fSyntaxPane.getCaret().moveDot(GutterClicker.this.rowEndWithEOLFromEvent(mouseEvent2));
                            } else {
                                ExecutionArrowDisplay.this.fSyntaxPane.getCaret().setDot(GutterClicker.this.rowStartFromEvent(mouseEvent2));
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                try {
                    ExecutionArrowDisplay.this.fSyntaxPane.getCaret().moveDot(this.rowEndWithEOLFromEvent(mouseEvent));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                try {
                    ExecutionArrowDisplay.this.fSyntaxPane.getCaret().moveDot(this.rowEndWithEOLFromEvent(mouseEvent));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ExecutionArrowDisplay.this.fSyntaxPane.requestFocus();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private int rowStartFromEvent(MouseEvent mouseEvent) throws BadLocationException {
            return MWEditorUIUtils.getRowStartFromPoint((Point)mouseEvent.getPoint(), (JTextComponent)ExecutionArrowDisplay.this.fSyntaxPane.getActiveTextComponent());
        }

        private int rowEndWithEOLFromEvent(MouseEvent mouseEvent) throws BadLocationException {
            return MWEditorUIUtils.getRowEndWithEOLFromPoint((Point)mouseEvent.getPoint(), (JTextComponent)ExecutionArrowDisplay.this.fSyntaxPane.getActiveTextComponent());
        }
    }

    private class TextEventHandler
    implements DocumentListener {
        private TextEventHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ExecutionArrowDisplay.this.adjustBookmarks(documentEvent, true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ExecutionArrowDisplay.this.adjustBookmarks(documentEvent, false);
        }
    }
}

