/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlwidgets.cwd.CwdComponentSet;
import com.mathworks.widgets.desk.DTMainToolBarSupplier;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolSet;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JToolBar;

class MLMainToolBarSupplier
extends DTMainToolBarSupplier {
    private static final String NEW_M_FILE = "NewMFile";
    private static final String OPEN = "Open";
    private static final String SIMULINK = "Simulink";
    private static final String GUIDE = "Guide";
    private static final String PROFILER = "Profiler";
    private static final String HELP = "Help";
    private static final String DEMOS = "Demos";
    private static final String PREFERENCES = "Preferences";
    private static final String CURRENT_DIRECTORY = "CurrentDirectory";
    private static final String BROWSE_DIRECTORY = "BrowserDirectory";
    private static final String UP_ONE_DIRECTORY = "UpOneDirectory";
    private static final String PROJECT = "Project";
    private static final String RUN_PROJECT = "RunProject";
    private final CwdComponentSet fCwdSet = new CwdComponentSet();

    public MLMainToolBarSupplier(Desktop desktop) {
        super(desktop);
    }

    CwdComponentSet getCwdComponmentSet() {
        return this.fCwdSet;
    }

    protected JToolBar[] createToolBars() {
        if (this.fDesktop.useToolstrip()) {
            return new JToolBar[0];
        }
        return super.createToolBars();
    }

    protected DTToolBarInfo[] getToolBarInfo() {
        DTToolSet dTToolSet = new DTToolSet();
        MLDesktop mLDesktop = (MLDesktop)this.fDesktop;
        dTToolSet.add(NEW_M_FILE, mLDesktop.getNewMFileAction());
        dTToolSet.add(OPEN, mLDesktop.getOpenAction());
        dTToolSet.add("Cut", DTMenuBar.sCutAction);
        dTToolSet.add("Copy", DTMenuBar.sCopyAction);
        dTToolSet.add("Paste", DTMenuBar.sPasteAction);
        dTToolSet.add("Undo", DTMenuBar.sUndoAction);
        dTToolSet.add("Redo", DTMenuBar.sRedoAction);
        dTToolSet.add(SIMULINK, mLDesktop.getLaunchSimulinkAction());
        dTToolSet.add(GUIDE, mLDesktop.getLaunchGuideAction());
        dTToolSet.add(PROFILER, mLDesktop.getLaunchProfilerAction());
        dTToolSet.add(HELP, mLDesktop.getProductHelpAction());
        dTToolSet.add(DEMOS, mLDesktop.getExamplesAction());
        dTToolSet.add(PREFERENCES, mLDesktop.getPreferencesAction());
        dTToolSet.add(CURRENT_DIRECTORY, this.fCwdSet.getDirectoryLabel(), (Component)this.fCwdSet.getDirectoryCombo(), null);
        dTToolSet.add(BROWSE_DIRECTORY, this.fCwdSet.getBrowseLabel(), (Component)this.fCwdSet.getBrowseButton(), this.fCwdSet.getBrowseIcon());
        dTToolSet.add(UP_ONE_DIRECTORY, this.fCwdSet.getUpOneLabel(), (Component)this.fCwdSet.getUpOneButton(), this.fCwdSet.getUpOneIcon());
        String[] stringArray = new String[]{NEW_M_FILE, OPEN, "Tool Bar Separator Key", "Cut", "Copy", "Paste", "Undo", "Redo", "Tool Bar Separator Key", SIMULINK, GUIDE, PROFILER, "Tool Bar Separator Key", HELP, "Tool Bar Separator Key", CURRENT_DIRECTORY, BROWSE_DIRECTORY, UP_ONE_DIRECTORY};
        DTToolBarConfiguration dTToolBarConfiguration = new DTToolBarConfiguration(Arrays.asList(stringArray));
        DTToolBarInfo[] dTToolBarInfoArray = new DTToolBarInfo[]{new DTToolBarInfo("Main", "MATLAB", dTToolSet, dTToolBarConfiguration)};
        return dTToolBarInfoArray;
    }
}

