/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.mde.dataimport.ImportProxy;
import com.mathworks.mde.dataimport.ImportUtils;
import com.mathworks.mde.dataimport.ImportVariableListModel;
import com.mathworks.mde.dataimport.ValueSpecification;
import com.mathworks.mde.dataimport.VariableContentsViewer;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WorkspaceChange;
import com.mathworks.mlwidgets.workspace.WorkspaceObserver;
import com.mathworks.mlwidgets.workspace.WorkspaceTable;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.services.ColorPrefs;
import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.recordlist.IEditingObserver;
import com.mathworks.widgets.recordlist.IGenericNameSupplier;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.ObserverAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VariableSourceSelectionPanel
extends MJPanel
implements ActionListener {
    private static final String RADIO_PREVIEW = "PREVIEW";
    private static final String RADIO_COL = "COL";
    private static final String RADIO_ROW = "ROW";
    private static final int BY = 120;
    private static final String[] ESA = new String[0];
    private ImportProxy fImportProxy;
    private MJRadioButton fPreviewButton;
    private MJRadioButton fColButton;
    private MJRadioButton fRowButton;
    private String[] fTrueVars = ESA;
    private String[] fTrueSizes = ESA;
    private long[] fTrueBytes = null;
    private String[] fTrueClasses = ESA;
    private String[] fExistingMatlabVariables = ESA;
    private ImportVariableListModel fListModel;
    private WorkspaceTable fWorkspaceTable;
    private MJScrollPane fWorkspaceScrollPane;
    private MJPanel fVariablePreviewPanel;
    private File fFileToImport = null;
    private MJPanel fPreviewPanel;
    private String[] fColHeaders = ESA;
    private String[] fRowHeaders = ESA;
    private boolean fGenerateCodeRequested;
    private LocalWO fWorkspaceObserver;
    private final boolean fCheckForNameCollision;
    private String fWorksheetname;

    VariableSourceSelectionPanel(ImportProxy importProxy, String string, File file, String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5, boolean bl, boolean bl2) {
        this.fImportProxy = importProxy;
        this.fWorksheetname = string;
        this.fCheckForNameCollision = bl2;
        this.setLayout(new BorderLayout());
        MJPanel mJPanel = this.createVariableStyleSelectionPanel();
        MJPanel mJPanel2 = this.createDataPreviewPanel();
        this.add((Component)mJPanel, "North");
        this.add((Component)mJPanel2, "Center");
        this.reinitialize(file, string, stringArray, stringArray2, lArray, stringArray3, stringArray4, stringArray5);
        if (!bl2) {
            this.fWorkspaceObserver = new LocalWO();
            MatlabWorkspaceListener.addWorkspaceChangeObserver((WorkspaceObserver)this.fWorkspaceObserver);
        }
        this.setCodeGenerationRequested(bl);
    }

    private MJPanel createVariableStyleSelectionPanel() {
        MJPanel mJPanel = new MJPanel();
        MJRadioButton mJRadioButton = new MJRadioButton(ImportUtils.getResource("vssp.createMatching"));
        mJRadioButton.setMnemonic(80);
        mJRadioButton.setActionCommand(RADIO_PREVIEW);
        mJRadioButton.addActionListener((ActionListener)this);
        mJRadioButton.setSelected(true);
        mJRadioButton.setName("MatchPreview");
        this.fPreviewButton = mJRadioButton;
        MJRadioButton mJRadioButton2 = new MJRadioButton(ImportUtils.getResource("vssp.createColumns"));
        mJRadioButton2.setMnemonic(67);
        mJRadioButton2.setActionCommand(RADIO_COL);
        mJRadioButton2.addActionListener((ActionListener)this);
        mJRadioButton2.setName("CreateColumns");
        this.fColButton = mJRadioButton2;
        MJRadioButton mJRadioButton3 = new MJRadioButton(ImportUtils.getResource("vssp.createRows"));
        mJRadioButton3.setMnemonic(82);
        mJRadioButton3.setActionCommand(RADIO_ROW);
        mJRadioButton3.addActionListener((ActionListener)this);
        mJRadioButton3.setName("CreateRows");
        this.fRowButton = mJRadioButton3;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fPreviewButton);
        buttonGroup.add((AbstractButton)this.fColButton);
        buttonGroup.add((AbstractButton)this.fRowButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        jPanel.add((Component)this.fPreviewButton);
        jPanel.add((Component)this.fColButton);
        jPanel.add((Component)this.fRowButton);
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        mJPanel.add((Component)jPanel, (Object)"West");
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(ImportUtils.getResource("vssp.checkboxBorder")));
        return mJPanel;
    }

    void reinitialize(File file, String string, String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        this.fWorksheetname = string;
        String[] stringArray6 = stringArray;
        String[] stringArray7 = stringArray2;
        long[] lArray2 = lArray;
        String[] stringArray8 = stringArray3;
        String[] stringArray9 = stringArray4;
        String[] stringArray10 = stringArray5;
        this.fFileToImport = file;
        this.refreshPreviewBorder();
        this.fPreviewButton.setSelected(true);
        if (stringArray6 == null) {
            stringArray6 = ArrayUtils.EmptyObjects.STRING;
            stringArray7 = ArrayUtils.EmptyObjects.STRING;
            lArray2 = ArrayUtils.EmptyPrimitives.LONG;
            stringArray8 = ArrayUtils.EmptyObjects.STRING;
            stringArray9 = ArrayUtils.EmptyObjects.STRING;
            stringArray10 = ArrayUtils.EmptyObjects.STRING;
        }
        this.setTrueVariableList(stringArray6, stringArray7, lArray2, stringArray8, stringArray9, stringArray10);
    }

    private void refreshPreviewBorder() {
        String string = this.fFileToImport == null ? ImportUtils.getResource("vssp.varsInClipboard") : ImportUtils.getResource("vssp.varsInArg", this.fFileToImport.getAbsolutePath());
        if (this.fWorksheetname != null && !"".equals(this.fWorksheetname)) {
            string = string + ImportUtils.getResource("vssp.varsInArgW") + this.fWorksheetname;
        }
        this.fPreviewPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
    }

    private void setTrueVariableList(String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fListModel.setData(stringArray, stringArray2, lArray, stringArray3);
            this.fTrueVars = stringArray;
            this.fTrueSizes = stringArray2;
            this.fTrueBytes = lArray;
            this.fTrueClasses = stringArray3;
            this.fColHeaders = stringArray4;
            this.fRowHeaders = stringArray5;
            if (stringArray4 == null && this.fColButton.isSelected()) {
                this.fPreviewButton.setSelected(true);
            }
            if (stringArray5 == null && this.fRowButton.isSelected()) {
                this.fPreviewButton.setSelected(true);
            }
            this.fColButton.setEnabled(stringArray4 != null);
            this.fRowButton.setEnabled(stringArray5 != null);
        } else {
            VariableListUpdater variableListUpdater = new VariableListUpdater(stringArray, stringArray2, lArray, stringArray3, stringArray4, stringArray5);
            SwingUtilities.invokeLater(variableListUpdater);
        }
    }

    private void setShownVariableList() {
        if (SwingUtilities.isEventDispatchThread()) {
            int n;
            String string;
            String string2;
            String[] stringArray;
            String[] stringArray2;
            long[] lArray;
            int n2;
            if (this.fColButton.isSelected()) {
                assert (this.fTrueSizes.length != 0);
                n2 = this.fColHeaders.length;
                lArray = new long[n2];
                stringArray2 = new String[n2];
                stringArray = new String[n2];
                string2 = this.fTrueSizes[0];
                string = string2.substring(0, string2.indexOf(120)) + "x1";
                for (n = 0; n < n2; ++n) {
                    lArray[n] = this.fTrueBytes[0] / (long)n2;
                    stringArray2[n] = this.fTrueClasses[0];
                    stringArray[n] = string;
                }
                this.fListModel.setData(this.fColHeaders, stringArray, lArray, stringArray2);
            }
            if (this.fRowButton.isSelected()) {
                assert (this.fTrueSizes.length != 0);
                n2 = this.fRowHeaders.length;
                lArray = new long[n2];
                stringArray2 = new String[n2];
                stringArray = new String[n2];
                string2 = this.fTrueSizes[0];
                string = '1' + string2.substring(string2.indexOf(120));
                for (n = 0; n < n2; ++n) {
                    lArray[n] = this.fTrueBytes[0] / (long)n2;
                    stringArray2[n] = this.fTrueClasses[0];
                    stringArray[n] = string;
                }
                this.fListModel.setData(this.fRowHeaders, stringArray, lArray, stringArray2);
            }
            if (this.fPreviewButton.isSelected()) {
                this.fListModel.setData(this.fTrueVars, this.fTrueSizes, this.fTrueBytes, this.fTrueClasses);
            }
        } else {
            ShownVariableListUpdater shownVariableListUpdater = new ShownVariableListUpdater();
            SwingUtilities.invokeLater(shownVariableListUpdater);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(RADIO_PREVIEW)) {
            this.setShownVariableList();
        }
        if (string.equals(RADIO_COL)) {
            this.setShownVariableList();
        }
        if (string.equals(RADIO_ROW)) {
            this.setShownVariableList();
        }
    }

    private MJPanel createDataPreviewPanel() {
        this.fPreviewPanel = new MJPanel();
        this.fPreviewPanel.setLayout((LayoutManager)new BorderLayout());
        this.fListModel = new ImportVariableListModel();
        this.fWorkspaceTable = new ImportWorkspaceTable(this.fListModel);
        this.fWorkspaceTable.setName("VariableTable");
        this.fWorkspaceTable.sortByColumn(1, 0);
        this.fWorkspaceScrollPane = new MJScrollPane((Component)this.fWorkspaceTable);
        this.fWorkspaceScrollPane.setName("VariableTableScrollPane");
        this.fVariablePreviewPanel = new MJPanel();
        this.fVariablePreviewPanel.setLayout((LayoutManager)new BorderLayout());
        MJTextArea mJTextArea = new MJTextArea(ImportUtils.getResource("vssp.noVarSelectedPreview"));
        mJTextArea.setName("NoVariableTextArea");
        mJTextArea.setForeground(ColorPrefs.getTextColor());
        mJTextArea.setBackground(ColorPrefs.getBackgroundColor());
        mJTextArea.setEditable(false);
        this.fVariablePreviewPanel.add((Component)mJTextArea);
        this.refreshPreviewBorder();
        MJSplitPane mJSplitPane = new MJSplitPane(1, (Component)this.fWorkspaceScrollPane, (Component)this.fVariablePreviewPanel);
        mJSplitPane.setName("VariableSelectionSplitPane");
        this.fPreviewPanel.add((Component)mJSplitPane, (Object)"Center");
        mJSplitPane.setDividerLocation(0.5);
        mJSplitPane.setResizeWeight(0.5);
        this.resetColors();
        this.fWorkspaceTable.getSelectionModel().addListSelectionListener(new VariableSelectionListener());
        return this.fPreviewPanel;
    }

    private String[] getOrigNamesOfVarsToImport() {
        return this.fListModel.getApprovedVariables();
    }

    private String[] getNewNamesOfVarsToImport() {
        return this.fListModel.getApprovedNewVariables();
    }

    boolean finish() {
        boolean bl;
        if (!this.fCheckForNameCollision) {
            String[] stringArray = VariableSourceSelectionPanel.findMatchingStrings(this.fExistingMatlabVariables, this.getNewNamesOfVarsToImport());
            bl = this.getProceedConfirmation(stringArray);
        } else {
            bl = true;
        }
        if (bl) {
            this.fImportProxy.requestFinish(this.getStyle(), this.fWorksheetname, null, this.getOrigNamesOfVarsToImport(), this.getNewNamesOfVarsToImport(), this.fGenerateCodeRequested);
        }
        return bl;
    }

    void setCodeGenerationRequested(boolean bl) {
        this.fGenerateCodeRequested = bl;
    }

    int getStyle() {
        if (this.fRowButton.isSelected()) {
            return 1;
        }
        if (this.fColButton.isSelected()) {
            return 2;
        }
        return 0;
    }

    private static String[] findMatchingStrings(String[] stringArray, String[] stringArray2) {
        Vector<String> vector = new Vector<String>();
        block0: for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (!string.equals(string2)) continue;
                vector.add(string);
                continue block0;
            }
        }
        String[] stringArray3 = new String[vector.size()];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = (String)vector.get(i);
        }
        return stringArray3;
    }

    private boolean getProceedConfirmation(String[] stringArray) {
        boolean bl = true;
        if (stringArray.length > 0) {
            String string;
            String string2;
            switch (stringArray.length) {
                case 1: {
                    string2 = ImportUtils.getResource("vssp.overwrite.start.one", stringArray[0]);
                    string = ImportUtils.getResource("vssp.overwrite.finish.single");
                    break;
                }
                case 2: {
                    string2 = ImportUtils.getResource("vssp.overwrite.start.two", stringArray[0], stringArray[1]);
                    string = ImportUtils.getResource("vssp.overwrite.finish.plural");
                    break;
                }
                default: {
                    string2 = ImportUtils.getResource("vssp.overwrite.start.many");
                    string = ImportUtils.getResource("vssp.overwrite.finish.plural");
                }
            }
            String string3 = string2 + "\n\n" + string + "\n\n";
            int n = MJOptionPane.showConfirmDialog((Component)((Object)this), (Object)string3, (String)ImportUtils.getResource("dialog.titleConfirmation"), (int)2, (int)3);
            bl = n == 0;
        }
        return bl;
    }

    void resetColors() {
        Color color = ColorPrefs.getTextColor();
        Color color2 = ColorPrefs.getBackgroundColor();
        JViewport jViewport = this.fWorkspaceScrollPane.getViewport();
        this.fWorkspaceTable.setForeground(color);
        ((Component)jViewport).setForeground(color);
        this.fWorkspaceTable.setBackground(color2);
        ((Component)jViewport).setBackground(color2);
        Component component = this.fVariablePreviewPanel.getComponent(0);
        if (component instanceof VariableContentsViewer) {
            ((VariableContentsViewer)((Object)component)).resetColors();
        } else {
            component.setForeground(color);
            component.setBackground(color2);
        }
    }

    boolean isBackAvailable() {
        return true;
    }

    public void cleanup() {
        if (this.fWorkspaceObserver != null) {
            MatlabWorkspaceListener.removeWorkspaceChangeObserver((WorkspaceObserver)this.fWorkspaceObserver);
            this.fWorkspaceObserver.cleanup();
            this.fWorkspaceObserver = null;
        }
        this.removeAll();
        this.fImportProxy = null;
        this.fWorkspaceTable.cleanup();
        this.fWorkspaceTable = null;
        this.fWorkspaceScrollPane.setViewportView(null);
        this.fWorkspaceScrollPane = null;
        this.fListModel = null;
        VariableSourceSelectionPanel.cleanupVariablePreviewPanel(this.fVariablePreviewPanel);
        this.fVariablePreviewPanel = null;
    }

    private static void cleanupVariablePreviewPanel(MJPanel mJPanel) {
        if (mJPanel != null) {
            Component[] componentArray;
            for (Component component : componentArray = mJPanel.getComponents()) {
                if (!(component instanceof VariableContentsViewer)) continue;
                ((VariableContentsViewer)((Object)component)).cleanup();
            }
            mJPanel.removeAll();
        }
    }

    static /* synthetic */ String[] access$1502(VariableSourceSelectionPanel variableSourceSelectionPanel, String[] stringArray) {
        variableSourceSelectionPanel.fExistingMatlabVariables = stringArray;
        return stringArray;
    }

    private class LocalWO
    implements WorkspaceObserver {
        private boolean iIsValid = true;

        private LocalWO() {
        }

        public void workspaceUpdate(WorkspaceChange workspaceChange, WhosInformation whosInformation) {
            if (this.iIsValid) {
                int n = whosInformation.size();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = whosInformation.getName(i);
                }
                VariableSourceSelectionPanel.access$1502(VariableSourceSelectionPanel.this, stringArray);
            }
        }

        void cleanup() {
            this.iIsValid = false;
        }
    }

    private class VariableSelectionListener
    implements ListSelectionListener {
        private VariableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = VariableSourceSelectionPanel.this.fWorkspaceTable.getSelectedRow();
                VariableSourceSelectionPanel.cleanupVariablePreviewPanel(VariableSourceSelectionPanel.this.fVariablePreviewPanel);
                if (n != -1) {
                    int n2;
                    String string = (String)VariableSourceSelectionPanel.this.fWorkspaceTable.getValueAt(n, VariableSourceSelectionPanel.this.fWorkspaceTable.convertColumnIndexToModel(1));
                    String string2 = string = VariableSourceSelectionPanel.this.fListModel.getTrueName(string);
                    int n3 = -1;
                    if (VariableSourceSelectionPanel.this.fColButton.isSelected()) {
                        string2 = "data";
                        for (n2 = 0; n2 < VariableSourceSelectionPanel.this.fColHeaders.length; ++n2) {
                            if (!VariableSourceSelectionPanel.this.fColHeaders[n2].equals(string)) continue;
                            n3 = n2 + 1;
                        }
                    }
                    n2 = -1;
                    if (VariableSourceSelectionPanel.this.fRowButton.isSelected()) {
                        string2 = "data";
                        for (int i = 0; i < VariableSourceSelectionPanel.this.fRowHeaders.length; ++i) {
                            if (!VariableSourceSelectionPanel.this.fRowHeaders[i].equals(string)) continue;
                            n2 = i + 1;
                        }
                    }
                    VariableContentsViewer variableContentsViewer = new VariableContentsViewer(VariableSourceSelectionPanel.this.fImportProxy, new ValueSpecification(string2, n2, n3, VariableSourceSelectionPanel.this.fWorksheetname));
                    variableContentsViewer.setName("VariablecontentsViewer");
                    VariableSourceSelectionPanel.this.fVariablePreviewPanel.add((Component)((Object)variableContentsViewer), (Object)"Center");
                } else {
                    MJTextArea mJTextArea = new MJTextArea(ImportUtils.getResource("vssp.noVarSelected"));
                    mJTextArea.setEditable(false);
                    mJTextArea.setName("NoVariableTextArea");
                    VariableSourceSelectionPanel.this.fVariablePreviewPanel.add((Component)mJTextArea);
                    mJTextArea.revalidate();
                }
            }
        }
    }

    private static class ImportWorkspaceTable
    extends WorkspaceTable {
        ImportWorkspaceTable(ImportVariableListModel importVariableListModel) {
            super((IRecordlistModel)importVariableListModel);
            this.enableEditingFailureDialog(importVariableListModel);
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.add((Action)this.getEditingActions()[1]);
            this.setSelectionPopupMenu(mJPopupMenu);
        }

        private void enableEditingFailureDialog(ImportVariableListModel importVariableListModel) {
            ObserverAdapter observerAdapter = new ObserverAdapter((IGenericNameSupplier)importVariableListModel);
            this.setEditingObserver((IEditingObserver)observerAdapter);
            observerAdapter.enableEditingFailureDialog((Component)((Object)this), ImportUtils.getResource("dialog.title"));
        }

        public void addNotify() {
            super.addNotify();
            this.doLayout();
        }
    }

    private class ShownVariableListUpdater
    implements Runnable {
        private ShownVariableListUpdater() {
        }

        @Override
        public void run() {
            VariableSourceSelectionPanel.this.setShownVariableList();
        }
    }

    private class VariableListUpdater
    implements Runnable {
        private String[] iVarNames;
        private String[] iSizes;
        private long[] iByteses;
        private String[] iClasses;
        private String[] iColHeaders;
        private String[] iRowHeaders;

        VariableListUpdater(String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
            this.iVarNames = stringArray;
            this.iSizes = stringArray2;
            this.iByteses = lArray;
            this.iClasses = stringArray3;
            this.iColHeaders = stringArray4;
            this.iRowHeaders = stringArray5;
        }

        @Override
        public void run() {
            VariableSourceSelectionPanel.this.setTrueVariableList(this.iVarNames, this.iSizes, this.iByteses, this.iClasses, this.iColHeaders, this.iRowHeaders);
        }
    }
}

