/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.matchers.TrueMatcher;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.mathworks.mde.cmdhist.AltHistory;
import com.mathworks.mde.cmdhist.AltHistoryCollection;
import com.mathworks.mde.cmdhist.CmdHistoryPrefs;
import com.mathworks.mde.cmdhist.CommandStyleInfo;
import com.mathworks.mde.cmdhist.ErrorTip;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.datatransfer.MJDragCursorUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.Pair;
import com.mathworks.util.PlatformInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AltHistoryTable
extends MJTable {
    private AltHistoryCollection fCollection;
    private boolean fInitialized;
    private DragSource fDragSource;
    private Color fSecondaryForeground = Color.gray;
    private EventList<AltHistoryCollection.CommandRecord> fFilteredRecordList;
    private MatcherSupplier fMatcherSupplier = new MatcherSupplier();
    private String fTextToHighlight;
    private String fFilterText;
    private boolean fCaseSensitiveMatching = CmdHistoryPrefs.getMatchCase();
    private boolean fMatchAnywhere = CmdHistoryPrefs.getMatchAnywhere();
    private TableColumn fTimeColumn;
    private Pair<Integer, Integer> fOverBatch;
    private ImageIcon fErrorIcon;
    private Color fErrorIconColor;
    private static final int REPEAT_COLUMN = 0;
    private static final int COMMAND_COLUMN = 1;
    private static final int TIME_COLUMN = 2;
    private static final int MAX_REPEAT_DISPLAYED = 9;
    private static final String[] COLUMN_NAMES = new String[]{"Repeat/Error", "Command", "Time"};
    private static final int ERROR_ICON_WIDTH = 12;
    private static final int ERROR_ICON_HEIGHT = 12;
    private static final int ERROR_MARK_HEIGHT = 3;

    public AltHistoryTable(AltHistoryCollection altHistoryCollection) {
        this.setName("CommandHistoryTable");
        this.fCollection = altHistoryCollection;
        AltHistoryCollection.CommandRecordList commandRecordList = this.fCollection.getCommandRecordList();
        this.setModelFromList((EventList<AltHistoryCollection.CommandRecord>)commandRecordList);
        commandRecordList.addListEventListener(new AltHistoryCollection.CommandRecordListListener(){

            @Override
            public void listCleared(AltHistoryCollection.CommandRecordList commandRecordList) {
                AltHistoryTable.this.setModelFromList((EventList<AltHistoryCollection.CommandRecord>)AltHistoryTable.this.fCollection.getCommandRecordList());
            }

            @Override
            public void listRepopulated(AltHistoryCollection.CommandRecordList commandRecordList) {
                AltHistoryTable.this.setModelFromList((EventList<AltHistoryCollection.CommandRecord>)AltHistoryTable.this.fCollection.getCommandRecordList());
            }

            public void listChanged(ListEvent<AltHistoryCollection.CommandRecord> listEvent) {
            }
        });
        this.setTableHeader(null);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setAutoscrolls(true);
        this.setRightSelectionEnabled(true);
        this.setCellViewerEnabled(true);
        this.addMouseMotionListener(new LocalMouseMotionListener());
        ColorPrefs.addColorListener((String)"Colors_M_", (PrefListener)new PrefListener(){

            public void prefChanged(PrefEvent prefEvent) {
                if (prefEvent.getPrefKey().equals("Colors_M_")) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Color color = ColorPrefs.MatlabColor.CW_ERROR.getPreferredColor();
                            if (!color.equals(AltHistoryTable.this.fErrorIconColor)) {
                                AltHistoryTable.this.fErrorIcon = null;
                            }
                            AltHistoryTable.this.repaint();
                        }
                    });
                }
            }
        });
        this.enableDragHandling(true);
        this.fDragSource = new DragSource();
        DragListener dragListener = new DragListener();
        new DropTarget((Component)((Object)this), dragListener);
        this.fDragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 3, dragListener);
        this.fInitialized = true;
    }

    void setModelFromList(EventList<AltHistoryCollection.CommandRecord> eventList) {
        Object object;
        if (this.fFilteredRecordList != null) {
            object = (FilterList)this.fFilteredRecordList;
            object.setMatcherEditor((MatcherEditor)new TextMatcherEditor());
            object.dispose();
            eventList.removeListEventListener((ListEventListener)this.fMatcherSupplier);
            this.fMatcherSupplier = new MatcherSupplier();
        }
        this.fFilteredRecordList = new FilterList(eventList, (MatcherEditor)this.fMatcherSupplier);
        this.setModel((TableModel)new EventTableModel(this.fFilteredRecordList, (TableFormat)new HistoryTableFormat()));
        eventList.addListEventListener((ListEventListener)this.fMatcherSupplier);
        object = this.getColumnModel().getColumn(0);
        ((TableColumn)object).setResizable(false);
        ((TableColumn)object).setCellRenderer(new RepeatRenderer());
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new CommandRenderer());
        this.fTimeColumn = this.getColumnModel().getColumn(2);
        this.fTimeColumn.setResizable(false);
        this.fTimeColumn.setCellRenderer(new TimeRenderer());
        this.updateColumnWidths();
    }

    public void addNotify() {
        super.addNotify();
        this.scrollToBottom();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fInitialized) {
            this.updateColumnWidths();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.updateSecondaryForeground();
        this.fErrorIcon = null;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.updateSecondaryForeground();
    }

    public void setTimeColumnVisible(boolean bl) {
        if (bl != this.isTimeColumnVisible()) {
            if (bl) {
                this.getColumnModel().addColumn(this.fTimeColumn);
            } else {
                this.getColumnModel().removeColumn(this.fTimeColumn);
            }
        }
    }

    public boolean isTimeColumnVisible() {
        return this.getColumnModel().getColumnCount() > 2;
    }

    Color getSecondaryForeground() {
        return this.fSecondaryForeground;
    }

    private void updateSecondaryForeground() {
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (color != null && color2 != null) {
            this.fSecondaryForeground = ColorUtils.mixColors((Color)color2, (Color)color, (float)0.5f);
        }
    }

    Color getOverridableSelectionBackground() {
        return this.getSelectionBackground();
    }

    Color getOverridableSelectionForeground() {
        return this.getSelectionForeground();
    }

    private void updateColumnWidths() {
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), new Integer(10), false, false, 0, 0);
        Dimension dimension = component.getPreferredSize();
        tableColumn.setMaxWidth(dimension.width + 4);
        tableColumn.setPreferredWidth(dimension.width + 4);
        tableCellRenderer = this.fTimeColumn.getCellRenderer();
        component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), 610000L, false, false, 0, 0);
        dimension = component.getPreferredSize();
        this.fTimeColumn.setMaxWidth(dimension.width);
        this.fTimeColumn.setPreferredWidth(dimension.width);
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension2.height < dimension.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    public int getPreferredWidth(int n) {
        int n2;
        int n3;
        int n4 = n / this.getRowHeight();
        int n5 = 100;
        TableModel tableModel = this.getModel();
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        int n6 = Math.max(0, n3 - n4);
        for (n3 = this.getSelectionModel().isSelectionEmpty() ? this.getRowCount() - 1 : Math.min(this.getSelectionModel().getMinSelectionIndex() + n4 - 1, this.getRowCount() - 1); n3 >= n6; --n3) {
            n2 = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), (Object)tableModel.getValueAt((int)n3, (int)1), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
            if (n2 <= n5) continue;
            n5 = n2;
        }
        n2 = this.isTimeColumnVisible() ? this.fTimeColumn.getPreferredWidth() : 0;
        return this.getColumnModel().getColumn(0).getPreferredWidth() + n2 + n5;
    }

    int getCommandInset() {
        return this.getColumnModel().getColumn(0).getPreferredWidth();
    }

    void scrollToBottom() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollBar jScrollBar;
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, (Component)((Object)AltHistoryTable.this));
                if (jScrollPane != null && (jScrollBar = jScrollPane.getVerticalScrollBar()) != null) {
                    int n = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent();
                    jScrollBar.setValue(n);
                }
            }
        });
    }

    void ensureRowVisible(int n) {
        Rectangle rectangle = this.getCellRect(n, 0, false);
        Rectangle rectangle2 = this.getVisibleRect();
        rectangle.x = rectangle2.x;
        rectangle.width = rectangle2.width;
        this.scrollRectToVisible(rectangle);
    }

    public void setTextToHighlight(String string) {
        if (!(string == this.fTextToHighlight || string != null && string.equals(this.fTextToHighlight))) {
            this.fTextToHighlight = string;
            this.repaint();
        }
    }

    public void setCaseSensitiveMatching(boolean bl) {
        if (bl != this.fCaseSensitiveMatching) {
            this.fCaseSensitiveMatching = bl;
            this.fMatcherSupplier.updateMatcher();
            if (this.fTextToHighlight != null) {
                this.repaint();
            }
        }
    }

    public void setMatchAnywhere(boolean bl) {
        if (bl != this.fMatchAnywhere) {
            this.fMatchAnywhere = bl;
            this.fMatcherSupplier.updateMatcher();
            if (this.fTextToHighlight != null) {
                this.repaint();
            }
        }
    }

    public void setFilterText(String string) {
        this.clearSelection();
        this.fFilterText = string;
        this.fMatcherSupplier.updateMatcher();
    }

    public int rowOfPreviousMatch(int n, String string, boolean bl, boolean bl2) {
        if (n == -1 || n > this.getRowCount()) {
            n = this.getRowCount();
        }
        if (string == null || string.length() == 0 || string.equals(this.fFilterText)) {
            for (int i = n - 1; i >= 0; --i) {
                if (this.getCommandRecord(i).isTimeStamp()) continue;
                return i;
            }
            return -1;
        }
        if (!bl) {
            string = string.toUpperCase();
        }
        if (bl2) {
            for (int i = n - 1; i >= 0; --i) {
                String string2 = this.getCommand(i);
                if (!bl) {
                    string2 = string2.toUpperCase();
                }
                if (string2.indexOf(string) < 0) continue;
                return i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                String string3 = this.getCommand(i);
                if (!bl) {
                    string3 = string3.toUpperCase();
                }
                if (!string3.startsWith(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public int rowOfNextMatch(int n, String string, boolean bl, boolean bl2) {
        if (n == -1) {
            return -1;
        }
        if (string == null || string.length() == 0 || string.equals(this.fFilterText)) {
            for (int i = n + 1; i < this.getRowCount(); ++i) {
                if (this.getCommandRecord(i).isTimeStamp()) continue;
                return i;
            }
            return -1;
        }
        if (!bl) {
            string = string.toUpperCase();
        }
        if (bl2) {
            for (int i = n + 1; i < this.getRowCount(); ++i) {
                String string2 = this.getCommand(i);
                if (!bl) {
                    string2 = string2.toUpperCase();
                }
                if (string2.indexOf(string) < 0) continue;
                return i;
            }
        } else {
            for (int i = n + 1; i < this.getRowCount(); ++i) {
                String string3 = this.getCommand(i);
                if (!bl) {
                    string3 = string3.toUpperCase();
                }
                if (!string3.startsWith(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public int[] getHighlightedRows() {
        if (this.fTextToHighlight == null) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string = this.fCaseSensitiveMatching ? this.fTextToHighlight : this.fTextToHighlight.toUpperCase();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string2 = this.getCommand(i);
            if (!this.fCaseSensitiveMatching) {
                string2 = string2.toUpperCase();
            }
            if (!this.commandMatches(string2, string, this.fMatchAnywhere)) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    private boolean commandMatches(String string, String string2, boolean bl) {
        return bl ? string.indexOf(string2) >= 0 : string.startsWith(string2);
    }

    String getCommand(int n) {
        return this.getCommandRecord(n).getCommandText();
    }

    AltHistoryCollection.CommandRecord getCommandRecord(int n) {
        return (AltHistoryCollection.CommandRecord)this.fFilteredRecordList.get(n);
    }

    public String[] getSelectedCommands() {
        int[] nArray = this.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.getCommand(nArray[i]);
        }
        return stringArray;
    }

    public String getSelectedString() {
        if (this.getSelectedRowCount() == 0) {
            return "";
        }
        int[] nArray = this.getSelectedRows();
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append(this.getCommand(n));
            stringBuilder.append('\n');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public void cutSelectedCommands() {
        this.copySelectedCommands();
        this.deleteSelectedCommands();
    }

    public void copySelectedCommands() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        String string = this.getSelectedString();
        if (string.length() > 0) {
            MJClipboard.getMJClipboard().setContents(string, null);
            if (PlatformInfo.isXWindows()) {
                MJClipboard.getMJClipboard().setXSelectionContents(string);
            }
        }
    }

    public void undoLastDeletion() {
        this.clearSelection();
        this.fCollection.undoLastDeletion();
    }

    public boolean anythingToUndo() {
        return this.fCollection.anythingToUndo();
    }

    public void deleteSelectedCommands() {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        this.clearSelection();
        this.fCollection.delete(nArray);
    }

    public boolean selectionCausedError() {
        int[] nArray;
        if (this.getSelectedRowCount() == 0) {
            return false;
        }
        for (int n : nArray = this.getSelectedRows()) {
            if (!this.getCommandRecord(n).causedError()) continue;
            return true;
        }
        return false;
    }

    public void setCausedErrorForSelection(boolean bl) {
        if (this.getSelectedRowCount() == 0) {
            return;
        }
        this.fCollection.setCausedError(this.getSelectedRows(), bl);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        Pair<Integer, Integer> pair;
        if (mouseEvent.getID() == 501 && !mouseEvent.isShiftDown() && (SwingUtilities.isLeftMouseButton(mouseEvent) || MJUtilities.isRightMouseButton((MouseEvent)mouseEvent) && this.isRightSelectionEnabled()) && (pair = this.getBatchRangeAtPoint(mouseEvent.getPoint())) != null) {
            if (mouseEvent.isControlDown()) {
                for (int i = ((Integer)pair.getFirst()).intValue(); i <= (Integer)pair.getSecond(); ++i) {
                    this.changeSelection(i, 0, true, false);
                }
            } else {
                this.getSelectionModel().setSelectionInterval((Integer)pair.getFirst(), (Integer)pair.getSecond());
            }
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    private Pair<Integer, Integer> getBatchRangeAtPoint(Point point) {
        int n;
        if (this.columnAtPoint(point) == 0 && (n = this.rowAtPoint(point)) >= 0 && this.fCollection.isInBatch(n)) {
            return new Pair((Object)this.fCollection.getBatchStart(n), (Object)this.fCollection.getBatchEnd(n));
        }
        return null;
    }

    private boolean isFiltered() {
        return this.fFilterText != null && this.fFilterText.length() > 0;
    }

    public JToolTip createToolTip() {
        return new ErrorTip();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        int n;
        Point point = mouseEvent.getPoint();
        int n2 = this.columnAtPoint(point);
        if (n2 == 0 && (n = this.rowAtPoint(point)) >= 0 && this.getCommandRecord(n).causedError()) {
            point.x -= 2;
            point.y -= 2;
            return point;
        }
        return null;
    }

    private ImageIcon getErrorIcon() {
        if (this.fErrorIcon == null) {
            this.fErrorIcon = this.createErrorIcon();
        }
        return this.fErrorIcon;
    }

    private ImageIcon createErrorIcon() {
        this.fErrorIconColor = ColorPrefs.MatlabColor.CW_ERROR.getPreferredColor();
        BufferedImage bufferedImage = new BufferedImage(12, 12, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Rectangle rectangle = new Rectangle(1, 5, 10, 3);
        graphics2D.setColor(this.fErrorIconColor);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(this.getBackground());
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private class LocalMouseMotionListener
    extends MouseMotionAdapter {
        private LocalMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            Rectangle rectangle;
            Pair pair = AltHistoryTable.this.getBatchRangeAtPoint(mouseEvent.getPoint());
            if (AltHistoryTable.this.fOverBatch != null && !AltHistoryTable.this.fOverBatch.equals((Object)pair)) {
                rectangle = new Rectangle();
                for (n = ((Integer)AltHistoryTable.this.fOverBatch.getFirst()).intValue(); n <= (Integer)AltHistoryTable.this.fOverBatch.getSecond(); ++n) {
                    rectangle = rectangle.union(AltHistoryTable.this.getCellRect(n, 0, false));
                }
                AltHistoryTable.this.repaint(rectangle);
            }
            if (pair != null && !pair.equals((Object)AltHistoryTable.this.fOverBatch)) {
                rectangle = new Rectangle();
                for (n = ((Integer)pair.getFirst()).intValue(); n <= (Integer)pair.getSecond(); ++n) {
                    rectangle = rectangle.union(AltHistoryTable.this.getCellRect(n, 0, false));
                }
                AltHistoryTable.this.repaint(rectangle);
            }
            AltHistoryTable.this.fOverBatch = pair;
        }
    }

    private class TimeRenderer
    extends DefaultTableCellRenderer {
        TimeRenderer() {
            this.setOpaque(false);
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = null;
            String string2 = null;
            if (object != null) {
                long l = (Long)object;
                if (l < 0L) {
                    string = null;
                } else if (l < 100L) {
                    string = null;
                    string2 = MessageFormat.format(AltHistory.sRes.getString("tip.RanInLessThan"), "0.1 sec.");
                } else if (l < 60000L) {
                    float f = (float)l / 1000.0f;
                    string = String.format("%5.2f sec", Float.valueOf(f));
                } else if (l < 3600000L) {
                    int n3 = (int)(l / 60000L);
                    int n4 = (int)((l - (long)(n3 * 60000)) / 1000L);
                    string = n3 + " min " + n4 + " sec";
                } else {
                    int n5 = (int)(l / 3600000L);
                    int n6 = (int)((l - (long)(n5 * 3600000)) / 60000L);
                    string = n5 + " hrs " + n6 + " min";
                }
            }
            this.setText(string);
            this.setToolTipText(string2);
            this.setForeground(AltHistoryTable.this.fSecondaryForeground);
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            if (AltHistoryTable.this.isFiltered()) {
                return;
            }
            super.paint(graphics);
        }
    }

    class CommandRenderer
    extends StyledLabel
    implements TableCellRenderer {
        CommandRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            StyleRange[] styleRangeArray = null;
            if (object == null) {
                this.setText("");
            } else {
                StyleRange[] styleRangeArray2;
                AltHistoryCollection.CommandRecord commandRecord = (AltHistoryCollection.CommandRecord)object;
                String string = commandRecord.getCommandText();
                this.setText(string);
                StyleRange[] styleRangeArray3 = AltHistoryTable.this.fTextToHighlight == null ? null : (styleRangeArray2 = CommandStyleInfo.getHighlightRanges(string, AltHistoryTable.this.fTextToHighlight, AltHistoryTable.this.fCaseSensitiveMatching, !AltHistoryTable.this.fMatchAnywhere));
                if (bl) {
                    this.setForeground(((AltHistoryTable)((Object)jTable)).getOverridableSelectionForeground());
                    this.setBackground(((AltHistoryTable)((Object)jTable)).getOverridableSelectionBackground());
                    styleRangeArray = styleRangeArray2;
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                    styleRangeArray = commandRecord.getStyleInfo().getStyleRanges();
                    if (styleRangeArray2 != null) {
                        styleRangeArray = CommandStyleInfo.addHighlightRanges(styleRangeArray, styleRangeArray2);
                    }
                }
            }
            if (styleRangeArray == null) {
                this.clearStyleRanges();
            } else {
                this.setStyleRanges(styleRangeArray);
            }
            this.setFont(jTable.getFont());
            return this;
        }
    }

    private class RepeatRenderer
    extends DefaultTableCellRenderer {
        private BatchPart iBatchPart;

        RepeatRenderer() {
            this.setOpaque(false);
            this.setIconTextGap(0);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (AltHistoryTable.this.isFiltered() || object == null) {
                this.setText(null);
                this.setIcon(null);
                this.setToolTipText(null);
                this.iBatchPart = null;
            } else {
                this.setForeground(AltHistoryTable.this.fSecondaryForeground);
                int n3 = (Integer)object;
                if (n3 < 0) {
                    this.setText(null);
                    this.setIcon(AltHistoryTable.this.getErrorIcon());
                    String string = AltHistoryTable.this.getCommandRecord(n).getErrorMessage();
                    if (string == null) {
                        string = AltHistory.sRes.getString("tip.error_info_unavailable");
                    }
                    this.setToolTipText(string);
                } else {
                    this.setIcon(null);
                    this.setToolTipText(null);
                    if (n3 <= 1) {
                        this.setText(null);
                    } else if (n3 <= 9) {
                        this.setText(n3 + "x");
                    } else {
                        this.setText(">9");
                        this.setToolTipText(n3 + "x");
                    }
                }
                if (!AltHistoryTable.this.fCollection.isEmpty() && AltHistoryTable.this.fCollection.isInBatch(n)) {
                    if (AltHistoryTable.this.fOverBatch != null && n >= (Integer)AltHistoryTable.this.fOverBatch.getFirst() && n <= (Integer)AltHistoryTable.this.fOverBatch.getSecond()) {
                        this.setForeground(AltHistoryTable.this.getSelectionBackground());
                    }
                    this.iBatchPart = AltHistoryTable.this.fCollection.isFirstInBatch(n) ? BatchPart.START : (AltHistoryTable.this.fCollection.isLastInBatch(n) ? BatchPart.END : BatchPart.INTERIOR);
                } else {
                    this.iBatchPart = null;
                }
            }
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            if (AltHistoryTable.this.isFiltered()) {
                return;
            }
            if (this.iBatchPart == null) {
                super.paint(graphics);
            } else {
                graphics.setColor(this.getForeground());
                int n = this.getWidth();
                int n2 = this.getHeight();
                int n3 = n / 2;
                int n4 = n2 / 2;
                switch (this.iBatchPart) {
                    case START: {
                        Shape shape = null;
                        String string = this.getText();
                        if (string != null && string.length() > 0) {
                            shape = graphics.getClip();
                            Rectangle rectangle = new Rectangle(0, 0, n - 2, n2 - 4);
                            Area area = new Area(shape);
                            area.subtract(new Area(rectangle));
                            graphics.setClip(area);
                        }
                        graphics.drawLine(n3, n4, n, n4);
                        graphics.drawLine(n3, n4, n3, n2);
                        if (shape != null) {
                            graphics.setClip(shape);
                        }
                        super.paint(graphics);
                        break;
                    }
                    case END: {
                        graphics.drawLine(n3, 0, n3, n4);
                        graphics.drawLine(n3, n4, n, n4);
                        break;
                    }
                    case INTERIOR: {
                        graphics.drawLine(n3, 0, n3, n2);
                    }
                }
            }
        }
    }

    private static enum BatchPart {
        START,
        INTERIOR,
        END;

    }

    private class UniqueCommandMatcher
    implements Matcher<AltHistoryCollection.CommandRecord> {
        private final String iText;
        private final boolean iCaseSensitive;
        private final boolean iAnywhere;

        private UniqueCommandMatcher(String string, boolean bl, boolean bl2) {
            this.iText = string;
            this.iCaseSensitive = bl;
            this.iAnywhere = bl2;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = bl ? string : string.toUpperCase();
            AltHistoryCollection.CommandRecordList commandRecordList = AltHistoryTable.this.fCollection.getCommandRecordList();
            for (int i = commandRecordList.size() - 1; i >= 0; --i) {
                AltHistoryCollection.CommandRecord commandRecord = (AltHistoryCollection.CommandRecord)commandRecordList.get(i);
                String string3 = bl ? commandRecord.getCommandText() : commandRecord.getCommandText().toUpperCase();
                boolean bl3 = AltHistoryTable.this.commandMatches(string3, string2, bl2);
                commandRecord.iMatches = false;
                if (!bl3 || hashMap.containsKey(string3)) continue;
                hashMap.put(string3, string3);
                commandRecord.iMatches = true;
            }
        }

        public boolean matches(AltHistoryCollection.CommandRecord commandRecord) {
            return commandRecord == null ? false : commandRecord.iMatches;
        }
    }

    private class MatcherSupplier
    extends AbstractMatcherEditor<AltHistoryCollection.CommandRecord>
    implements AltHistoryCollection.CommandRecordListListener {
        private MatcherSupplier() {
            this.currentMatcher = TrueMatcher.getInstance();
        }

        public void listChanged(ListEvent<AltHistoryCollection.CommandRecord> listEvent) {
            this.refreshMatcher();
        }

        @Override
        public void listCleared(AltHistoryCollection.CommandRecordList commandRecordList) {
        }

        @Override
        public void listRepopulated(AltHistoryCollection.CommandRecordList commandRecordList) {
            this.refreshMatcher();
        }

        private void updateMatcher() {
            boolean bl;
            FilterChange filterChange = null;
            boolean bl2 = !AltHistoryTable.this.isFiltered();
            boolean bl3 = bl = !(this.currentMatcher instanceof UniqueCommandMatcher);
            if (bl2) {
                if (!bl) {
                    this.currentMatcher = TrueMatcher.getInstance();
                    filterChange = FilterChange.ALL;
                }
            } else {
                AltHistoryTable.this.clearSelection();
                if (bl) {
                    filterChange = FilterChange.CONSTRAIN;
                } else {
                    UniqueCommandMatcher uniqueCommandMatcher = (UniqueCommandMatcher)this.currentMatcher;
                    if (AltHistoryTable.this.fCaseSensitiveMatching != uniqueCommandMatcher.iCaseSensitive) {
                        filterChange = FilterChange.ARBITRARY;
                    }
                    if (AltHistoryTable.this.fMatchAnywhere != uniqueCommandMatcher.iAnywhere) {
                        filterChange = AltHistoryTable.this.fMatchAnywhere ? FilterChange.RELAX : FilterChange.CONSTRAIN;
                    }
                    int n = AltHistoryTable.this.fFilterText.length();
                    int n2 = uniqueCommandMatcher.iText.length();
                    if (n2 < n && AltHistoryTable.this.fFilterText.startsWith(uniqueCommandMatcher.iText)) {
                        filterChange = FilterChange.CONSTRAIN;
                    } else if (n2 > n && uniqueCommandMatcher.iText.startsWith(AltHistoryTable.this.fFilterText)) {
                        filterChange = FilterChange.RELAX;
                    } else if (!AltHistoryTable.this.fFilterText.equals(uniqueCommandMatcher.iText)) {
                        filterChange = FilterChange.ARBITRARY;
                    }
                }
                if (filterChange != null) {
                    this.currentMatcher = new UniqueCommandMatcher(AltHistoryTable.this.fFilterText, AltHistoryTable.this.fCaseSensitiveMatching, AltHistoryTable.this.fMatchAnywhere);
                }
            }
            if (filterChange != null) {
                switch (filterChange) {
                    case CONSTRAIN: {
                        this.fireConstrained(this.currentMatcher);
                        break;
                    }
                    case RELAX: {
                        this.fireRelaxed(this.currentMatcher);
                        break;
                    }
                    case ARBITRARY: {
                        this.fireChanged(this.currentMatcher);
                        break;
                    }
                    case ALL: {
                        this.fireMatchAll();
                    }
                }
            }
        }

        private void refreshMatcher() {
            if (AltHistoryTable.this.fFilterText != null) {
                this.currentMatcher = TrueMatcher.getInstance();
                this.fireMatchAll();
                this.updateMatcher();
            }
        }
    }

    static enum FilterChange {
        CONSTRAIN,
        RELAX,
        ARBITRARY,
        ALL,
        NONE;

    }

    private static class HistoryTableFormat
    implements TableFormat<AltHistoryCollection.CommandRecord> {
        private HistoryTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return COLUMN_NAMES[n];
        }

        public Object getColumnValue(AltHistoryCollection.CommandRecord commandRecord, int n) {
            switch (n) {
                case 0: {
                    return commandRecord.causedError() ? -1 : commandRecord.getRepeatCount();
                }
                case 1: {
                    return commandRecord;
                }
                case 2: {
                    return commandRecord.getExecutionTime();
                }
            }
            return null;
        }
    }

    private class DragListener
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private DragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (AltHistoryTable.this.getSelectedRowCount() == 0) {
                return;
            }
            String string = AltHistoryTable.this.getSelectedString();
            if (string == null || string.length() == 0) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string);
            AltHistoryTable.this.fDragSource.startDrag(dragGestureEvent, MJDragCursorUtilities.getCursor((int)1), MJDragCursorUtilities.getMacImageToDrag(), new Point(0, 0), stringSelection, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            Cursor cursor = dragSourceDragEvent.getDragSourceContext().getCursor();
            if (dragSourceDragEvent.getUserAction() != 1 || !cursor.equals(MJDragCursorUtilities.getCursor((int)1))) {
                Cursor cursor2 = MJDragCursorUtilities.getCursor((int)1);
                dragSourceDragEvent.getDragSourceContext().setCursor(cursor2);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(MJDragCursorUtilities.getCursor((int)7563));
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            this.dragEnter(dragSourceDragEvent);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }
}

