/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.system;

import com.sun.jini.system.CommandLine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class POSIXCommandLine
extends CommandLine {
    private String[] orig;
    private char[][] args;
    private boolean allUsed;
    private boolean singles;
    private boolean usedUp;
    private ArrayList options;
    private String prog;
    private int str;
    private int pos;
    private char opt;
    private static final char USED = '\u0000';

    public POSIXCommandLine(String[] stringArray) {
        this(null, stringArray);
    }

    public POSIXCommandLine(String string, String[] stringArray) {
        this.orig = stringArray;
        this.args = new char[stringArray.length][];
        this.prog = string;
        for (int i = 0; i < stringArray.length; ++i) {
            this.args[i] = stringArray[i].toCharArray();
        }
        this.options = new ArrayList();
    }

    public synchronized boolean getBoolean(char c) {
        this.addOpt(c, null);
        this.singles = true;
        boolean bl = false;
        while (this.findOpt(c)) {
            bl = true;
        }
        return bl;
    }

    private String getArgument(char c) throws CommandLine.BadInvocationException {
        this.assertNoSingles();
        if (this.findOpt(c)) {
            return this.optArg();
        }
        return null;
    }

    public synchronized String getString(char c, String string) throws CommandLine.BadInvocationException {
        this.addOpt(c, "str");
        return POSIXCommandLine.parseString(this.getArgument(c), string);
    }

    public synchronized int getInt(char c, int n) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(c, "int");
        return POSIXCommandLine.parseInt(this.getArgument(c), n);
    }

    public synchronized long getLong(char c, long l) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(c, "long");
        return POSIXCommandLine.parseLong(this.getArgument(c), l);
    }

    public synchronized double getDouble(char c, double d) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(c, "val");
        return POSIXCommandLine.parseDouble(this.getArgument(c), d);
    }

    public synchronized Writer getWriter(char c, Writer writer) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseWriter(this.getArgument(c), writer);
    }

    public synchronized Writer getWriter(char c, String string) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseWriter(this.getArgument(c), string);
    }

    public synchronized Reader getReader(char c, Reader reader) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseReader(this.getArgument(c), reader);
    }

    public synchronized Reader getReader(char c, String string) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseReader(this.getArgument(c), string);
    }

    public synchronized OutputStream getOutputStream(char c, OutputStream outputStream) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseOutputStream(this.getArgument(c), outputStream);
    }

    public synchronized OutputStream getOutputStream(char c, String string) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseOutputStream(this.getArgument(c), string);
    }

    public synchronized InputStream getInputStream(char c, InputStream inputStream) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseInputStream(this.getArgument(c), inputStream);
    }

    public synchronized InputStream getInputStream(char c, String string) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseInputStream(this.getArgument(c), string);
    }

    public synchronized RandomAccessFile getRandomAccessFile(char c, RandomAccessFile randomAccessFile, String string) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseRandomAccessFile(this.getArgument(c), randomAccessFile, string);
    }

    public synchronized RandomAccessFile getRandomAccessFile(char c, String string, String string2) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(c, "file");
        return POSIXCommandLine.parseRandomAccessFile(this.getArgument(c), string, string2);
    }

    private void assertNoSingles() {
        this.assertNotUsedUp();
        if (this.singles) {
            throw new CommandLine.ProgrammingException("opts with args must come first");
        }
    }

    private void assertNotUsedUp() {
        if (this.usedUp) {
            throw new CommandLine.ProgrammingException("Command line used up");
        }
    }

    private boolean findOpt(char c) {
        if (this.allUsed) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i][0] != '-') continue;
            if (this.args[i][1] == '-') break;
            for (int j = 1; j < this.args[i].length; ++j) {
                if (this.args[i][j] == c) {
                    this.str = i;
                    this.pos = j;
                    this.opt = c;
                    this.args[i][j] = '\u0000';
                    return true;
                }
                if (this.args[i][j] == '\u0000') continue;
                bl = true;
            }
        }
        if (!bl) {
            this.allUsed = true;
        }
        return false;
    }

    private String optArg() throws CommandLine.BadInvocationException {
        if (this.pos + 1 < this.args[this.str].length) {
            for (int i = this.pos + 1; i < this.args[this.str].length; ++i) {
                this.args[this.str][i] = '\u0000';
            }
            return this.orig[this.str].substring(this.pos + 1);
        }
        if (this.str >= this.orig.length) {
            throw new CommandLine.BadInvocationException(new Character(this.opt));
        }
        for (int i = 0; i < this.args[this.str + 1].length; ++i) {
            this.args[this.str + 1][i] = '\u0000';
        }
        return this.orig[this.str + 1];
    }

    public String[] getOperands() throws CommandLine.BadInvocationException, CommandLine.HelpOnlyException {
        int n;
        if (this.getBoolean('?')) {
            this.usage();
            throw new CommandLine.HelpOnlyException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.args.length; ++n) {
            if (this.args[n][0] == '\u0000') continue;
            if (this.args[n][0] != '-') break;
            if (this.args[n][1] == '-') {
                ++n;
                break;
            }
            for (int i = 1; i < this.args[n].length; ++i) {
                if (this.args[n][i] == '\u0000') continue;
                stringBuffer.append(this.args[n][i]);
            }
        }
        if (stringBuffer.length() != 0) {
            throw new CommandLine.BadInvocationException("unknown option" + (stringBuffer.length() > 1 ? "s" : "") + ": " + stringBuffer);
        }
        String[] stringArray = new String[this.args.length - n];
        for (int i = n; i < this.args.length; ++i) {
            stringArray[i - n] = this.orig[i];
        }
        this.usedUp = true;
        return stringArray;
    }

    private void addOpt(char c, String string) {
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Opt opt = (Opt)iterator.next();
            if (opt.opt != c) continue;
            opt.multi = true;
            return;
        }
        if (c != '?') {
            this.options.add(new Opt(c, string));
        }
    }

    public void usage() {
        Opt opt;
        if (this.prog != null) {
            System.out.print(this.prog);
            System.out.print(' ');
        }
        System.out.print("[-?]");
        boolean bl = false;
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            opt = (Opt)iterator.next();
            if (opt.argType != null) continue;
            if (!bl) {
                System.out.print(" [-");
            }
            System.out.print(opt.opt);
            bl = true;
        }
        if (bl) {
            System.out.print(']');
        }
        iterator = this.options.iterator();
        while (iterator.hasNext()) {
            opt = (Opt)iterator.next();
            if (opt.argType == null) continue;
            System.out.print(" [-");
            System.out.print(opt.opt);
            System.out.print(' ');
            System.out.print(opt.argType);
            System.out.print("]");
            if (!opt.multi) continue;
            System.out.print("...");
        }
        System.out.println(" ...");
    }

    private static class Opt {
        char opt;
        String argType;
        boolean multi;

        Opt(char c, String string) {
            this.opt = c;
            this.argType = string;
        }
    }
}

