/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.osgi;

import com.mathworks.util.osgi.OSGiUtils;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ServicesActivator
implements BundleActivator {
    private static final String SERVICES_ATTRIBUTE = "Services";
    private static final String PAIR_DELIMITER = ",";
    private static final String SERVICE_DELIMITER = ":";

    public void start(BundleContext bundleContext) throws Exception {
        String string = (String)bundleContext.getBundle().getHeaders().get(SERVICES_ATTRIBUTE);
        assert (string != null && string.length() > 0) : "The OSGi ServicesActivator requires a \"Services\" attribute in the bundle's Manifest";
        ServicesActivator.parseServices(bundleContext, string);
    }

    private static void parseServices(BundleContext bundleContext, String string) throws Exception {
        for (String string2 : string.split(PAIR_DELIMITER)) {
            ServicesActivator.registerServicePair(bundleContext, string2);
        }
    }

    private static void registerServicePair(BundleContext bundleContext, String string) throws Exception {
        String string2 = "OSGi Manifest \"Services\" attribute incorrect; expected \"Services: interfaceName: className, interfaceName: className ...\"";
        assert (string.contains(SERVICE_DELIMITER)) : string2;
        String[] stringArray = string.split(SERVICE_DELIMITER);
        assert (stringArray.length == 2) : string2;
        String string3 = stringArray[0].trim();
        String string4 = stringArray[1].trim();
        Class<?> clazz = Class.forName(string3);
        assert (clazz.isInterface()) : "OSGi expected " + string3 + " in " + string + " to be an interface";
        Object obj = Class.forName(string4).newInstance();
        assert (clazz.isInstance(obj)) : "OSGi expected " + string4 + " to implement " + string3;
        OSGiUtils.log("Registering " + string4 + " as a " + string3);
        bundleContext.registerService(clazz.getName(), obj, (Dictionary)new Properties());
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

