/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.toolbox.testmeas.propertyeditor.IPropertySetter;
import com.mathworks.toolbox.testmeas.propertyeditor.Property;
import com.mathworks.toolbox.testmeas.propertyeditor.ReadStatus;
import com.mathworks.toolbox.testmeas.propertyeditor.TMNoMarginPanel;
import com.mathworks.toolbox.testmeas.tmswing.TMAbstractStyleGuideJPanel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public abstract class Widget
implements PropertyChangeListener {
    private IPropertySetter fPropertySetter;
    private Property fProperty;
    private TMAbstractStyleGuideJPanel fPanel = new TMNoMarginPanel();

    public Widget(IPropertySetter iPropertySetter, Property property) {
        this.fPropertySetter = iPropertySetter;
        this.fProperty = property;
        this.fProperty.addPropertyChangeListener("value", this);
    }

    public TMAbstractStyleGuideJPanel getWidget() {
        this.addContent(this.fPanel);
        this.enableWidget(this.fProperty.getReadStauts() != ReadStatus.READ_ONLY);
        List<Component> list = this.getComponents((Container)((Object)this.fPanel));
        for (final Component component : list) {
            final MouseListener mouseListener = new MouseListener(component);
            component.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Widget.this.fProperty.setBeingEdited(true);
                    if (!(component instanceof JComboBox)) {
                        Toolkit.getDefaultToolkit().addAWTEventListener(mouseListener, 16L);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(mouseListener);
                    Widget.this.fProperty.setBeingEdited(false);
                }
            });
        }
        this.fPanel.setRequestFocusEnabled(true);
        this.fPanel.setFocusable(true);
        return this.fPanel;
    }

    public void set(Object object, Component component) {
        this.fPropertySetter.set(this.fProperty, object, component);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.displayValue(propertyChangeEvent.getNewValue());
        }
    }

    public void destroy() {
        List<Component> list = this.getComponents((Container)((Object)this.fPanel));
        for (Component component : list) {
            FocusListener[] focusListenerArray;
            for (FocusListener focusListener : focusListenerArray = component.getFocusListeners()) {
                component.removeFocusListener(focusListener);
            }
        }
        this.cleanup();
        this.fProperty.removePropertyChangeListener("value", this);
    }

    public abstract void addContent(TMAbstractStyleGuideJPanel var1);

    public abstract void cleanup();

    public abstract void displayValue(Object var1);

    public abstract void enableWidget(boolean var1);

    protected Property getProperty() {
        return this.fProperty;
    }

    protected List<Component> getComponents(Container container) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : container.getComponents()) {
            if (component instanceof JPanel) {
                List<Component> list = this.getComponents((Container)component);
                arrayList.addAll(list);
                continue;
            }
            arrayList.add(component);
        }
        return arrayList;
    }

    public class MouseListener
    implements AWTEventListener {
        private Component fComponent;

        public MouseListener(Component component) {
            this.fComponent = component;
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (mouseEvent.getID() == 500 && !this.fComponent.contains(mouseEvent.getPoint())) {
                Widget.this.fPanel.requestFocusInWindow();
            }
        }
    }
}

