/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.guiutil;

import com.mathworks.beans.editors.ApplyPropertyEditor;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class TMCallbackEditor
extends MWPropertyEditorSupport
implements Runnable,
KeyListener,
EnhancedPropertyEditor,
ApplyPropertyEditor {
    private static String LINESEP = new Character('\r').toString() + new Character('\n').toString();
    private Image icon;
    private JTextField textfield = null;
    private JPanel outerPanel = null;
    private int action = 0;
    private boolean setValue = false;

    public Component getCustomEditor() {
        Object object;
        if (this.outerPanel == null) {
            this.outerPanel = new JPanel(new BorderLayout(5, 5));
            this.outerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            object = new JPanel(new BorderLayout());
            this.textfield = new JTextField();
            this.textfield.addKeyListener(this);
            this.textfield.requestFocus();
            ((Container)object).add((Component)new JLabel("Enter the callback value:"), "North");
            ((Container)object).add((Component)this.textfield, "Center");
            this.outerPanel.add((Component)this.createInstructions(), "Center");
            this.outerPanel.add((Component)object, "South");
        }
        this.setValue = false;
        this.outerPanel.setPreferredSize(new Dimension(350, 240));
        object = (MLArrayRef)this.getValue();
        this.action = object.getType();
        Matlab.whenMatlabReady((Runnable)this);
        return this.outerPanel;
    }

    private JPanel createInstructions() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Configuring Callbacks"), BorderFactory.createEmptyBorder(0, 4, 4, 4)));
        JTextArea jTextArea = new JTextArea();
        jPanel.add((Component)jTextArea, "Center");
        jTextArea.setBackground(jPanel.getBackground());
        jTextArea.setText("A callback can be configured to a:" + LINESEP + LINESEP + "1. string, e.g. plot(1:10) " + LINESEP + "2. cell array, e.g {'myfun', 1, 2}" + LINESEP + "3. function handle, e.g @instrcallback " + LINESEP + LINESEP + "When the callback is set to a cell array or a function handle, the object " + "that caused the event to occur and an event structure are passed to the " + "evaluated function.");
        jTextArea.setFont(new Font("Dialog", 0, 12));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        return jPanel;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public boolean supportsInPlaceEditing() {
        return false;
    }

    public void apply() {
        if (this.setValue) {
            this.action = 0;
            Matlab.whenMatlabReady((Runnable)this);
        }
    }

    @Override
    public void run() {
        if (this.action == 0) {
            this.setValueFromText();
        } else {
            this.setTextFromValue();
        }
    }

    public void setTextFromValue() {
        MLArrayRef mLArrayRef = (MLArrayRef)this.getValue();
        switch (this.action) {
            case 4: {
                this.textfield.setText((String)mLArrayRef.getData());
                return;
            }
            case 1: {
                this.textfield.setText(this.convertCell2String(mLArrayRef));
                return;
            }
            case 16: {
                this.textfield.setText(this.convertFunctionHandle2String(mLArrayRef));
                return;
            }
        }
    }

    public void setValueFromText() {
        String string = this.textfield.getText();
        String string2 = string;
        if (string2.startsWith("{") || string2.startsWith("@")) {
            Object[] objectArray = new Object[1];
            string2 = "system_dependent(45," + string2 + ")";
            objectArray[0] = string2;
            MLArrayRef mLArrayRef = null;
            try {
                mLArrayRef = (MLArrayRef)Matlab.mtFeval((String)"eval", (Object[])objectArray, (int)1);
                this.setValue(mLArrayRef);
            }
            catch (Exception exception) {}
        } else {
            Object[] objectArray = new Object[]{new Integer(45), string};
            MLArrayRef mLArrayRef = null;
            try {
                mLArrayRef = (MLArrayRef)Matlab.mtFeval((String)"system_dependent", (Object[])objectArray, (int)1);
                this.setValue(mLArrayRef);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean okToConvertCell2String(MLArrayRef mLArrayRef) {
        for (int i = 0; i < mLArrayRef.getN(); ++i) {
            MLArrayRef mLArrayRef2 = mLArrayRef.cellAt(i);
            if (mLArrayRef2.getType() == 6 || mLArrayRef2.getType() == 4 || mLArrayRef2.getType() == 16) continue;
            return false;
        }
        return true;
    }

    private String convertCell2String(MLArrayRef mLArrayRef) {
        if (!this.okToConvertCell2String(mLArrayRef)) {
            return mLArrayRef.toString();
        }
        String string = "{";
        block5: for (int i = 0; i < mLArrayRef.getN(); ++i) {
            MLArrayRef mLArrayRef2 = mLArrayRef.cellAt(i);
            switch (mLArrayRef2.getType()) {
                case 6: {
                    string = string + this.convertMatrix2String(mLArrayRef2) + ",";
                    continue block5;
                }
                case 4: {
                    string = string + "'" + (String)mLArrayRef2.getData() + "',";
                    continue block5;
                }
                case 16: {
                    string = string + this.convertFunctionHandle2String(mLArrayRef2) + ",";
                }
            }
        }
        string = string.substring(0, string.length() - 1);
        string = string + "}";
        return string;
    }

    private String convertMatrix2String(MLArrayRef mLArrayRef) {
        try {
            Object[] objectArray = new Object[]{mLArrayRef};
            String string = (String)Matlab.mtFeval((String)"mat2str", (Object[])objectArray, (int)1);
            return string;
        }
        catch (Exception exception) {
            return mLArrayRef.toString();
        }
    }

    private String convertFunctionHandle2String(MLArrayRef mLArrayRef) {
        try {
            Object[] objectArray = new Object[]{mLArrayRef};
            String string = (String)Matlab.mtFeval((String)"func2str", (Object[])objectArray, (int)1);
            return "@" + string;
        }
        catch (Exception exception) {
            return mLArrayRef.toString();
        }
    }

    public Image getIcon() {
        if (this.icon == null) {
            ResLoader resLoader = new ResLoader(this.getClass());
            this.icon = resLoader.loadImage("/com/mathworks/toolbox/testmeas/resources/CallbackIcon.gif");
        }
        return this.icon;
    }

    public boolean hasAttachedData() {
        return false;
    }

    public String getDataKey() {
        return null;
    }

    public void setData(Object object) {
    }

    public void setFrame(Frame frame) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.setValue = true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

