/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.browser;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolbox.testmeas.browser.Browser;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.TreeViewEditorListener;
import com.mathworks.toolbox.testmeas.browser.TreeViewListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeView
extends JTree
implements TreeSelectionListener,
MouseListener,
KeyListener,
TreeViewListener,
PopupMenuListener {
    private static final long serialVersionUID = 1L;
    private Browser browser;
    private BrowserTreeNode root;
    private DefaultTreeModel treeModel;
    private Vector<Object> nodes = new Vector();
    protected MJPopupMenu popup;
    private TreePath previousPath;
    protected TreePath previousRightClickPath;
    private TreePath rightClickPath;
    private boolean rightClickWasShown = false;
    private boolean foundPopupTrigger = false;
    private boolean rightClickAvailable = true;
    private Vector<TreeViewEditorListener> listeners;
    private BrowserTreeNode nodeBeingEdited;
    private Color backgroundColor;
    private Color foregroundColor;
    private BrowserTreeNode selectedNode;
    protected BrowserTreeNode valueChangedNode;

    public TreeView(Browser browser) {
        this(browser, new BrowserTreeNode("Test & Measurement", null));
    }

    public TreeView(Browser browser, BrowserTreeNode browserTreeNode) {
        this.browser = browser;
        this.root = browserTreeNode;
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        this.setSelectionModel(new DefaultTreeSelectionModel());
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.popup = new MJPopupMenu();
        this.popup.addPopupMenuListener((PopupMenuListener)this);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(50);
        toolTipManager.setReshowDelay(50);
        toolTipManager.setDismissDelay(1000);
        toolTipManager.registerComponent(this);
        BrowserTreeRenderer browserTreeRenderer = new BrowserTreeRenderer();
        this.setCellRenderer(browserTreeRenderer);
        this.setCellEditor(new BrowserTreeEditor(this, browserTreeRenderer));
        this.setEditable(true);
        this.setLargeModel(true);
        this.setRowHeight(18);
        this.backgroundColor = ColorPrefs.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.foregroundColor = ColorPrefs.getTextColor();
        browserTreeRenderer.setTextNonSelectionColor(this.foregroundColor);
        this.setForeground(this.foregroundColor);
        this.setSelectionPath(new TreePath(this.root.getPath()));
    }

    @Override
    public void setSelectionPath(TreePath treePath) {
        try {
            super.setSelectionPath(treePath);
            this.nodeBeingEdited = this.getNode(treePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.removeTreeSelectionListener(this);
        this.removeMouseListener(this);
        this.removeKeyListener(this);
        this.popup.removePopupMenuListener((PopupMenuListener)this);
    }

    public void addParentandChildNodes(BrowserTreeNode browserTreeNode, BrowserTreeNode[] browserTreeNodeArray) {
        if (browserTreeNode == null) {
            return;
        }
        browserTreeNode.setIsRootNode(true);
        this.addChildNode(this.root, browserTreeNode, -1);
        if (browserTreeNodeArray == null) {
            return;
        }
        for (int i = 0; i < browserTreeNodeArray.length; ++i) {
            browserTreeNodeArray[i].setIsLevelOneNode(true);
            this.addChildNode(browserTreeNode, browserTreeNodeArray[i], -1);
        }
        this.expandPath(new TreePath(browserTreeNode.getPath()));
    }

    @Override
    public boolean isPathEditable(TreePath treePath) {
        this.nodeBeingEdited = this.getNode(treePath);
        return this.nodeBeingEdited.getEditable();
    }

    @Override
    public void updateNode(BrowserTreeNode browserTreeNode) {
        if (this.treeModel == null) {
            return;
        }
        this.treeModel.nodeChanged(browserTreeNode);
        this.repaint();
    }

    @Override
    public void editingNode(BrowserTreeNode browserTreeNode) {
        if (this.treeModel == null) {
            return;
        }
        browserTreeNode.setEditable(true);
        this.startEditingAtPath(new TreePath(browserTreeNode.getPath()));
    }

    @Override
    public BrowserTreeNode getCurrentNode() {
        return this.selectedNode;
    }

    @Override
    public void addNode(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, boolean bl, int n) {
        this.addChildNode(browserTreeNode, browserTreeNode2, n);
        if (bl) {
            this.setSelectionPath(new TreePath(browserTreeNode2.getPath()));
            this.browser.updateDetailView(browserTreeNode2);
        }
    }

    @Override
    public void addNode(String string, String[] stringArray, BrowserTreeNode browserTreeNode, int n, boolean bl) {
        this.addNode(string, stringArray, browserTreeNode, n, bl, -1);
    }

    @Override
    public void addNode(String string, String[] stringArray, BrowserTreeNode browserTreeNode, int n, boolean bl, int n2) {
        switch (n) {
            case 3: {
                BrowserTreeNode browserTreeNode2 = this.getNode(stringArray);
                if (browserTreeNode2 != null) {
                    this.addChildNode(browserTreeNode2, browserTreeNode, n2);
                    break;
                }
                this.addChildAndParentNodesAsNeeded(stringArray, browserTreeNode, n, n2);
                break;
            }
            case 0: {
                BrowserTreeNode browserTreeNode3 = this.getNode(stringArray);
                if (browserTreeNode3 == null) break;
                this.addChildNode(browserTreeNode3, browserTreeNode, n2);
                break;
            }
            case 1: {
                BrowserTreeNode browserTreeNode4 = this.getNode(stringArray);
                if (browserTreeNode4 != null) {
                    if (this.getNode(browserTreeNode4, string) != null) break;
                    this.addChildNode(browserTreeNode4, browserTreeNode, n2);
                    break;
                }
                this.addChildAndParentNodesAsNeeded(stringArray, browserTreeNode, n, n2);
                break;
            }
            case 2: {
                this.addChildAndParentNodesAsNeeded(stringArray, browserTreeNode, n, n2);
            }
        }
        if (bl) {
            this.selectNode(browserTreeNode);
        }
    }

    @Override
    public void selectNode(BrowserTreeNode browserTreeNode) {
        this.setSelectionPath(new TreePath(browserTreeNode.getPath()));
        this.browser.updateDetailView(browserTreeNode);
    }

    private void addChildAndParentNodesAsNeeded(String[] stringArray, BrowserTreeNode browserTreeNode, int n, int n2) {
        BrowserTreeNode browserTreeNode2;
        int n3;
        BrowserTreeNode browserTreeNode3 = this.getNode(stringArray[0]);
        int n4 = -1;
        for (n3 = 1; n3 < stringArray.length; ++n3) {
            browserTreeNode2 = this.getNode(browserTreeNode3, stringArray[n3]);
            if (browserTreeNode2 == null) {
                n4 = n3;
                break;
            }
            browserTreeNode3 = browserTreeNode2;
        }
        if (n4 != -1) {
            for (n3 = n4; n3 < stringArray.length; ++n3) {
                browserTreeNode2 = new BrowserTreeNode(stringArray[n3], browserTreeNode.getClient());
                this.addChildNode(browserTreeNode3, browserTreeNode2, -1);
                browserTreeNode3 = browserTreeNode2;
            }
        }
        if (n2 == -1) {
            n2 = browserTreeNode3.getChildCount();
        }
        switch (n) {
            case 3: {
                this.addChildNode(browserTreeNode3, browserTreeNode, n2);
                break;
            }
            case 1: {
                this.addChildNode(browserTreeNode3, browserTreeNode, n2);
                break;
            }
            case 2: {
                String string = browserTreeNode.getName();
                if (this.getNode(browserTreeNode3, string) == null) {
                    this.addChildNode(browserTreeNode3, browserTreeNode, n2);
                    break;
                }
                int n5 = 2;
                String string2 = string + " (1)";
                while (this.getNode(browserTreeNode3, string2) != null) {
                    string2 = string + " (" + n5 + ")";
                    ++n5;
                }
                browserTreeNode.setName(string2);
                this.addChildNode(browserTreeNode3, browserTreeNode, n2);
            }
        }
    }

    protected void addChildNode(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, int n) {
        int n2 = browserTreeNode.getChildCount();
        if (n == -1) {
            n = n2;
        } else if (n2 < n) {
            n = n2;
        }
        if (this.treeModel == null) {
            return;
        }
        this.treeModel.insertNodeInto(browserTreeNode2, browserTreeNode, n);
        this.nodes.addElement(browserTreeNode2);
    }

    private void removeChildNode(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2) {
        if (this.treeModel == null) {
            return;
        }
        this.treeModel.removeNodeFromParent(browserTreeNode2);
        this.setSelectionPath(new TreePath(browserTreeNode.getPath()));
        this.nodes.remove(browserTreeNode2);
        this.previousPath = this.getSelectionPath();
    }

    private void removeChildNodeQuietly(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2) {
        boolean bl = false;
        if (this.getSelectionPath().equals(new TreePath(browserTreeNode2.getPath()))) {
            bl = true;
        }
        this.treeModel.removeNodeFromParent(browserTreeNode2);
        if (bl) {
            this.setSelectionPath(new TreePath(browserTreeNode.getPath()));
        }
        this.nodes.remove(browserTreeNode2);
        this.previousPath = this.getSelectionPath();
    }

    @Override
    public void removeNode(BrowserTreeNode browserTreeNode) {
        this.removeChildNode((BrowserTreeNode)browserTreeNode.getParent(), browserTreeNode);
    }

    @Override
    public void removeNode(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2) {
        this.removeChildNode(browserTreeNode, browserTreeNode2);
    }

    @Override
    public void removeNode(String string, String[] stringArray, int n) {
        BrowserTreeNode browserTreeNode = this.getNode(stringArray);
        if (browserTreeNode == null) {
            return;
        }
        BrowserTreeNode browserTreeNode2 = this.getNode(browserTreeNode, string);
        if (browserTreeNode2 == null) {
            return;
        }
        if (n == 4) {
            this.removeChildNodeQuietly(browserTreeNode, browserTreeNode2);
            return;
        }
        this.removeChildNode(browserTreeNode, browserTreeNode2);
        this.removeParentNodes(browserTreeNode, n);
    }

    @Override
    public void removeNode(String[] stringArray, Object object, int n) {
        BrowserTreeNode browserTreeNode = this.getNode(stringArray);
        if (browserTreeNode == null) {
            return;
        }
        BrowserTreeNode browserTreeNode2 = this.getNode(browserTreeNode, object);
        if (browserTreeNode2 == null) {
            return;
        }
        if (n == 4) {
            this.removeChildNodeQuietly(browserTreeNode, browserTreeNode2);
            return;
        }
        this.removeChildNode(browserTreeNode, browserTreeNode2);
        this.removeParentNodes(browserTreeNode, n);
    }

    private void removeParentNodes(BrowserTreeNode browserTreeNode, int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                while (browserTreeNode.getChildCount() == 0) {
                    BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)browserTreeNode.getParent();
                    this.removeChildNode(browserTreeNode2, browserTreeNode);
                    browserTreeNode = browserTreeNode2;
                }
                break;
            }
            case 2: {
                if (browserTreeNode.getChildCount() != 0) break;
                this.removeChildNode((BrowserTreeNode)browserTreeNode.getParent(), browserTreeNode);
                break;
            }
            case 3: {
                while (browserTreeNode.getChildCount() == 0 && !browserTreeNode.getIsRootNode() && !browserTreeNode.getIsLevelOneNode()) {
                    BrowserTreeNode browserTreeNode3 = (BrowserTreeNode)browserTreeNode.getParent();
                    this.removeChildNode(browserTreeNode3, browserTreeNode);
                    browserTreeNode = browserTreeNode3;
                }
                break;
            }
        }
    }

    private BrowserTreeNode getNode(BrowserTreeNode browserTreeNode, String string) {
        int n = browserTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)browserTreeNode.getChildAt(i);
            if (!browserTreeNode2.getUserObject().equals(string)) continue;
            return browserTreeNode2;
        }
        return null;
    }

    private BrowserTreeNode getNode(BrowserTreeNode browserTreeNode, Object object) {
        int n = browserTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)browserTreeNode.getChildAt(i);
            if (!browserTreeNode2.getUserData().equals(object)) continue;
            return browserTreeNode2;
        }
        return null;
    }

    private BrowserTreeNode getNode(String[] stringArray) {
        BrowserTreeNode browserTreeNode = this.getNode(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            BrowserTreeNode browserTreeNode2 = this.getNode(browserTreeNode, stringArray[i]);
            if (browserTreeNode2 == null) {
                return null;
            }
            browserTreeNode = browserTreeNode2;
        }
        return browserTreeNode;
    }

    public BrowserTreeNode selectFirstNode() {
        BrowserTreeNode browserTreeNode = this.getNode(this.getPathForRow(0));
        this.selectNode(browserTreeNode);
        return browserTreeNode;
    }

    protected BrowserTreeNode getNode(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        return (BrowserTreeNode)treePath.getLastPathComponent();
    }

    private BrowserTreeNode getNode(String string) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)this.nodes.elementAt(i);
            if (!browserTreeNode.getName().equals(string)) continue;
            return browserTreeNode;
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath;
        this.valueChangedNode = null;
        if (this.popup.isVisible()) {
            this.setSelectionPath(this.previousRightClickPath);
            return;
        }
        if (treeSelectionEvent != null && (treePath = treeSelectionEvent.getNewLeadSelectionPath()) != null) {
            this.valueChangedNode = this.getNode(treePath);
        }
        if (this.valueChangedNode == null) {
            this.valueChangedNode = (BrowserTreeNode)this.getLastSelectedPathComponent();
        }
        if (this.valueChangedNode == null) {
            return;
        }
        this.setSelectionPath(new TreePath(this.valueChangedNode.getPath()));
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeView.this.browser.updateDetailView(TreeView.this.valueChangedNode);
                    }
                });
            }
            catch (Throwable throwable) {}
        } else {
            this.browser.updateDetailView(this.valueChangedNode);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.removeTreeSelectionListener(this);
        if (this.rightClickPath == null && this.previousPath != null) {
            this.setSelectionPath(this.previousPath);
        }
        this.revalidate();
        this.repaint();
        this.addTreeSelectionListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.popupMenuWillBecomeInvisible(popupMenuEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.foundPopupTrigger = mouseEvent.isPopupTrigger();
        TreePath treePath = this.previousPath;
        if (this.rightClickPath == null && this.previousPath != this.getSelectionPath()) {
            this.previousPath = this.getSelectionPath();
        }
        this.rightClickPath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (this.rightClickPath == null || this.rightClickPath == this.previousPath) {
            return;
        }
        if (mouseEvent.getModifiers() == 4 || mouseEvent.getModifiers() == 6 || mouseEvent.getModifiers() == 5) {
            this.removeTreeSelectionListener(this);
            this.setSelectionPath(this.rightClickPath);
            this.revalidate();
            this.repaint();
            this.addTreeSelectionListener(this);
            if (treePath != null) {
                this.previousPath = treePath;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.isPopupTrigger() || this.foundPopupTrigger) && this.rightClickPath != null) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)this.rightClickPath.getLastPathComponent();
            this.popup.removeAll();
            BrowserClient browserClient = browserTreeNode.getClient();
            if (browserClient != null) {
                if (browserClient.defineRightClickMenuItems(browserTreeNode, (JPopupMenu)this.popup)) {
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    this.rightClickWasShown = true;
                    this.rightClickAvailable = true;
                    this.previousRightClickPath = this.rightClickPath;
                } else {
                    this.previousRightClickPath = this.previousPath;
                    this.rightClickAvailable = false;
                }
            } else {
                this.previousRightClickPath = this.previousPath;
                this.rightClickAvailable = false;
            }
        }
        this.previousRightClickPath = this.rightClickPath;
        this.rightClickPath = null;
        this.foundPopupTrigger = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        Serializable serializable;
        if (mouseEvent.getClickCount() == 1 && !this.popup.isVisible()) {
            serializable = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            object = null;
            if (serializable != null) {
                object = this.getNode((TreePath)serializable);
            }
            if (this.selectedNode != null && object != null && this.selectedNode.equals(object)) {
                BrowserClient browserClient = ((BrowserTreeNode)object).getClient();
                if (browserClient != null) {
                    browserClient.reClickOnNode((BrowserTreeNode)object);
                }
            } else if (this.rightClickWasShown) {
                this.valueChanged(new TreeSelectionEvent((Object)this, this.previousRightClickPath, true, this.previousRightClickPath, this.previousRightClickPath));
            }
            this.selectedNode = object;
            if (!this.rightClickAvailable) {
                this.selectNode(this.getNode(this.previousPath));
            }
            this.rightClickWasShown = false;
            this.rightClickAvailable = true;
            if (this.previousRightClickPath == this.previousPath) {
                this.previousRightClickPath = null;
            }
        }
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        serializable = (BrowserTreeNode)this.getLastSelectedPathComponent();
        if (serializable == null) {
            return;
        }
        object = ((BrowserTreeNode)serializable).getClient();
        if (object != null) {
            object.doubleClickOnNode((BrowserTreeNode)serializable);
        }
    }

    @Override
    public void expandNode(BrowserTreeNode browserTreeNode) {
        this.expandAll(browserTreeNode);
    }

    public void expandAll() {
        this.expandAll(this.root);
    }

    protected void expandAll(BrowserTreeNode browserTreeNode) {
        int n = this.treeModel.getChildCount(browserTreeNode);
        for (int i = 0; i < n; ++i) {
            BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)this.treeModel.getChild(browserTreeNode, i);
            if (this.treeModel.getChildCount(browserTreeNode2) != 0) {
                this.expandAll(browserTreeNode2);
            }
            this.expandPath(new TreePath(browserTreeNode2.getPath()));
        }
        this.expandPath(new TreePath(browserTreeNode.getPath()));
    }

    public void collapseAll() {
        this.collapseAll(this.root);
        this.expandPath(new TreePath(this.root.getPath()));
        if (this.isRootVisible()) {
            this.selectNode(this.root);
        } else {
            this.selectNode(this.getNode(this.getPathForRow(0)));
        }
    }

    protected void collapseAll(BrowserTreeNode browserTreeNode) {
        int n = this.treeModel.getChildCount(browserTreeNode);
        for (int i = 0; i < n; ++i) {
            BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)this.treeModel.getChild(browserTreeNode, i);
            if (this.treeModel.getChildCount(browserTreeNode2) != 0) {
                this.collapseAll(browserTreeNode2);
            }
            this.collapsePath(new TreePath(browserTreeNode2.getPath()));
        }
        this.collapsePath(new TreePath(browserTreeNode.getPath()));
    }

    public void addTreeViewEditorListener(TreeViewEditorListener treeViewEditorListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(treeViewEditorListener)) {
            this.listeners.addElement(treeViewEditorListener);
        }
    }

    public void removeTreeViewEditorListener(TreeViewEditorListener treeViewEditorListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(treeViewEditorListener);
    }

    public void postNodeEditingCanceledEvent(ChangeEvent changeEvent, BrowserTreeNode browserTreeNode) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeViewEditorListener treeViewEditorListener = this.listeners.elementAt(i);
            treeViewEditorListener.nodeEditingCanceled(changeEvent, browserTreeNode);
        }
    }

    public void postNodeEditingStoppedEvent(ChangeEvent changeEvent, BrowserTreeNode browserTreeNode) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeViewEditorListener treeViewEditorListener = this.listeners.elementAt(i);
            treeViewEditorListener.nodeEditingStopped(changeEvent, browserTreeNode);
        }
    }

    public void setModel(DefaultTreeModel defaultTreeModel) {
        this.treeModel = defaultTreeModel;
        this.nodes.clear();
        if (defaultTreeModel != null) {
            this.nodes.add(this.treeModel.getRoot());
            if (((TreeNode)this.treeModel.getRoot()).getChildCount() > 0) {
                this.addAllChildren((TreeNode)this.treeModel.getRoot());
            }
        }
        super.setModel(defaultTreeModel);
    }

    protected void addAllChildren(TreeNode treeNode) {
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.nodes.add(treeNode.getChildAt(i));
            if (treeNode.getChildAt(i).getChildCount() <= 0) continue;
            this.addAllChildren(treeNode.getChildAt(i));
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        BrowserTreeNode browserTreeNode;
        int n;
        if (this.popup.isVisible()) {
            // empty if block
        }
        BrowserTreeNode browserTreeNode2 = this.browser.getSelectedNode();
        int n2 = this.getRowForPath(new TreePath(browserTreeNode2.getPath()));
        int n3 = keyEvent.getKeyCode();
        switch (n3) {
            case 109: {
                this.collapseAll(browserTreeNode2);
                return;
            }
            case 106: 
            case 107: {
                this.expandAll(browserTreeNode2);
                return;
            }
        }
        if ((keyEvent.getModifiersEx() & 0x80) == 128) {
            return;
        }
        int n4 = this.getRowCount();
        String string = KeyEvent.getKeyText(n3);
        for (n = n2 + 1; n < n4; ++n) {
            browserTreeNode = (BrowserTreeNode)this.getPathForRow(n).getLastPathComponent();
            if (!browserTreeNode.getName().startsWith(string)) continue;
            TreePath treePath = new TreePath(browserTreeNode.getPath());
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
            this.browser.updateDetailView(browserTreeNode);
            return;
        }
        for (n = 0; n < n2; ++n) {
            browserTreeNode = (BrowserTreeNode)this.getPathForRow(n).getLastPathComponent();
            if (!browserTreeNode.getName().startsWith(string)) continue;
            TreePath treePath = new TreePath(browserTreeNode.getPath());
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
            this.browser.updateDetailView(browserTreeNode);
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    class BrowserTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private BrowserTreeNode node = null;
        private MJLabel label = new MJLabel();

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.node = (BrowserTreeNode)object;
            BrowserClient browserClient = this.node.getClient();
            if (browserClient != null) {
                this.label.setIcon((Icon)browserClient.getNodeIcon(this.node));
            } else {
                this.label.setIcon((Icon)this.node.getIcon());
            }
            if (browserClient == null) {
                this.label.setToolTipText(null);
                return this.label;
            }
            this.label.setToolTipText(browserClient.getToolTipString(this.node));
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.label.setOpaque(true);
            this.label.setText(string);
            this.label.setFont(jTree.getFont());
            if (bl) {
                this.label.setBackground(this.getBackgroundSelectionColor());
                this.label.setForeground(this.getTextSelectionColor());
            } else {
                this.label.setBackground(TreeView.this.backgroundColor);
                this.label.setForeground(this.getTextNonSelectionColor());
            }
            return this.label;
        }

        @Override
        public Icon getOpenIcon() {
            return this.getNodeIcon();
        }

        @Override
        public Icon getClosedIcon() {
            return this.getNodeIcon();
        }

        @Override
        public Icon getLeafIcon() {
            return this.getNodeIcon();
        }

        private Icon getNodeIcon() {
            if (this.node == null) {
                return null;
            }
            BrowserClient browserClient = this.node.getClient();
            if (browserClient != null) {
                return browserClient.getNodeIcon(this.node);
            }
            return this.node.getIcon();
        }
    }

    class BrowserTreeEditor
    extends DefaultTreeCellEditor
    implements CellEditorListener,
    FocusListener {
        private boolean focusListenerAdded;
        private BrowserTreeNode currentNode;

        BrowserTreeEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
            this.focusListenerAdded = false;
            this.currentNode = null;
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            TreeCellEditor treeCellEditor = super.createTreeCellEditor();
            treeCellEditor.addCellEditorListener(this);
            return treeCellEditor;
        }

        @Override
        public void prepareForEditing() {
            super.prepareForEditing();
            if (this.editingComponent != null && !this.focusListenerAdded) {
                this.editingComponent.addFocusListener(this);
                this.focusListenerAdded = true;
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.currentNode != null) {
                String string = (String)this.getCellEditorValue();
                TreeView.this.setSelectionPath(new TreePath(this.currentNode.getPath()));
            }
        }

        @Override
        public boolean canEditImmediately(EventObject eventObject) {
            if (eventObject == null) {
                return true;
            }
            if (TreeView.this.browser == null) {
                return false;
            }
            if (TreeView.this.browser.getSelectedNode() != TreeView.this.nodeBeingEdited) {
                return false;
            }
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                return super.canEditImmediately(eventObject) && this.inHitRegion(mouseEvent.getX() + 23, mouseEvent.getY());
            }
            return super.canEditImmediately(eventObject);
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            Object object = this.getCellEditorValue();
            this.currentNode.setUserObject(object);
            TreeView.this.postNodeEditingStoppedEvent(changeEvent, this.currentNode);
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            TreeView.this.postNodeEditingStoppedEvent(changeEvent, this.currentNode);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.currentNode = TreeView.this.getNode(this.lastPath);
        }
    }
}

