/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.FontProvider;
import ice.pilots.html4.JavaFontProvider;
import ice.util.Defs;
import ice.util.alg.CharKit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FontCache {
    private static String defaultFontFamily = "Serif";
    private static int baseFontSize = 10;
    private static final int defaultFontStyle = 0;
    static int minFontSize = 4;
    private Font fallbackFont;
    private float DPI = 120.0f;
    private static final int MAX_ISO8859_1_CHAR = 255;
    private boolean messageShown;
    private int fontCreations;
    private int cacheFetches;
    private int localCacheResets;
    private final int[] fontMuls = new int[]{256, 307, 369, 442, 531, 637, 764, 850};
    private Hashtable fontMetricsCache = new Hashtable();
    private int LOCAL_FONT_CACHE_SIZE = 5;
    private Font[] localCache = new Font[this.LOCAL_FONT_CACHE_SIZE];
    private boolean traceFonts = Debug.trace && Defs.sysPropertyBoolean((String)"ice.pilots.html4.traceFonts");
    private FontProvider[] fontProviders;

    public FontCache() {
        this.init();
    }

    private void traceFonts(String[] stringArray) {
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Known families: " + n);
        for (int i = 0; i != n; ++i) {
            stringBuffer.append("\n\t");
            stringBuffer.append(stringArray[i]);
        }
        if (Debug.trace) {
            Debug.trace((String)stringBuffer.toString());
        }
    }

    private void traceFontMetrics(FontMetrics fontMetrics) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tfont: ");
        stringBuffer.append(fontMetrics.getFont().toString());
        stringBuffer.append("\n\tascent: ");
        stringBuffer.append(fontMetrics.getAscent());
        stringBuffer.append(", descent: ");
        stringBuffer.append(fontMetrics.getDescent());
        stringBuffer.append(", height: ");
        stringBuffer.append(fontMetrics.getHeight());
        stringBuffer.append(", max-ascent: ");
        stringBuffer.append(fontMetrics.getMaxAscent());
        stringBuffer.append(", max-descent: ");
        stringBuffer.append(fontMetrics.getMaxDescent());
        stringBuffer.append("\n\tmax-advance: ");
        stringBuffer.append(fontMetrics.getMaxAdvance());
        stringBuffer.append(", test-width: ");
        stringBuffer.append(fontMetrics.stringWidth("Hello, world!"));
        if (Debug.trace) {
            Debug.trace((String)stringBuffer.toString());
        }
    }

    void init() {
        FontProvider fontProvider;
        try {
            int n = Toolkit.getDefaultToolkit().getScreenResolution();
            this.DPI = n;
        }
        catch (Exception exception) {
            this.DPI = 120.0f;
        }
        String string = Defs.sysProperty((String)"ice.pilots.html4.addonFontProviders", (String)"JavaVM");
        boolean bl = false;
        Vector<JavaFontProvider> vector = new Vector<JavaFontProvider>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if ("JavaVM".equalsIgnoreCase(string)) {
                    fontProvider = new JavaFontProvider();
                    vector.addElement((JavaFontProvider)fontProvider);
                    bl = true;
                    continue;
                }
                try {
                    fontProvider = (FontProvider)Class.forName(string).newInstance();
                    if (Debug.trace) {
                        Debug.trace((String)("FontProvider instance loaded: " + string));
                    }
                    vector.addElement((JavaFontProvider)fontProvider);
                }
                catch (Exception exception) {
                    if (!Debug.trace) continue;
                    Debug.trace((String)("Exception loading FontProvider: " + string + ", ex: " + exception));
                }
            }
        }
        if (!bl) {
            fontProvider = new JavaFontProvider();
            vector.addElement((JavaFontProvider)fontProvider);
        }
        this.fontProviders = new FontProvider[vector.size()];
        for (int i = 0; i < this.fontProviders.length; ++i) {
            this.fontProviders[i] = (FontProvider)vector.elementAt(i);
        }
    }

    public Font getTestedFont(char[] cArray, int n, int n2, CSSAttribs cSSAttribs) {
        int n3;
        Font font = null;
        FontMetrics fontMetrics = null;
        if (cSSAttribs != null && this.canDisplay(font = (fontMetrics = this.getFontMetrics(cSSAttribs.font_family, cSSAttribs.font_style, cSSAttribs.font_size)).getFont(), cArray, n, n2)) {
            return font;
        }
        for (n3 = 0; n3 < this.localCache.length; ++n3) {
            font = this.localCache[n3];
            if (font == null || !this.canDisplay(font, cArray, n, n2)) continue;
            cSSAttribs.font_family = font.getFamily();
            font = this.getFontMetrics(cSSAttribs.font_family, cSSAttribs.font_style, cSSAttribs.font_size).getFont();
            return font;
        }
        for (n3 = 0; n3 < this.fontProviders.length; ++n3) {
            String[] stringArray = this.fontProviders[n3].getFontFamilies();
            for (int i = 0; i < stringArray.length; ++i) {
                font = this.fontProviders[n3].getFont(stringArray[i], cSSAttribs.font_style, cSSAttribs.font_size);
                if (font == null || !this.canDisplay(font, cArray, n, n2)) continue;
                fontMetrics = this.fontProviders[n3].getFontMetrics(font);
                this.addToFontMetricsCache(stringArray[i], cSSAttribs.font_style, cSSAttribs.font_size, fontMetrics);
                this.addToLocalFamilyCache(font);
                cSSAttribs.font_family = stringArray[i];
                return font;
            }
        }
        font = this.fallbackFont;
        if (Debug.trace) {
            // empty if block
        }
        cSSAttribs.font_family = defaultFontFamily;
        return font;
    }

    public Font getTestedFont(String string, CSSAttribs cSSAttribs) {
        int n;
        Font font = null;
        FontMetrics fontMetrics = this.getFontMetrics(cSSAttribs.font_family, cSSAttribs.font_style, cSSAttribs.font_size);
        font = fontMetrics.getFont();
        if (this.canDisplay(font, string)) {
            return font;
        }
        for (n = 0; n < this.localCache.length; ++n) {
            font = this.localCache[n];
            if (font == null || !this.canDisplay(font, string)) continue;
            cSSAttribs.font_family = this.getSupportedFontFamily(font.getFamily());
            font = this.getFontMetrics(cSSAttribs.font_family, cSSAttribs.font_style, cSSAttribs.font_size).getFont();
            return font;
        }
        for (n = 0; n < this.fontProviders.length; ++n) {
            String[] stringArray = this.fontProviders[n].getFontFamilies();
            for (int i = 0; i < stringArray.length; ++i) {
                font = this.fontProviders[n].getFont(stringArray[i], cSSAttribs.font_style, cSSAttribs.font_size);
                if (font == null || !this.canDisplay(font, string)) continue;
                fontMetrics = this.fontProviders[n].getFontMetrics(font);
                this.addToFontMetricsCache(stringArray[i], cSSAttribs.font_style, cSSAttribs.font_size, fontMetrics);
                this.addToLocalFamilyCache(font);
                cSSAttribs.font_family = stringArray[i];
                return font;
            }
        }
        font = this.fallbackFont;
        if (Debug.trace) {
            // empty if block
        }
        cSSAttribs.font_family = defaultFontFamily;
        return font;
    }

    private boolean canDisplay(Font font, char[] cArray, int n, int n2) {
        try {
            Class<?> clazz = font.getClass();
            Class[] classArray = new Class[]{cArray.getClass(), Integer.TYPE, Integer.TYPE};
            Method method = clazz.getMethod("canDisplayUpTo", classArray);
            Object[] objectArray = new Object[]{cArray, new Integer(n), new Integer(n2)};
            Object object = method.invoke((Object)font, objectArray);
            int n3 = (Integer)object;
            if (n3 == -1) {
                return true;
            }
            if (n3 == n2 - n) {
                return true;
            }
            for (int i = n3; i < n2; ++i) {
                if (cArray[i] <= '\u00ff') continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            if (Debug.trace && !this.messageShown) {
                Debug.p((String)"canDisplay Exception in char[] Introspection test, One warning only, continuing... ");
                this.messageShown = true;
            }
            return true;
        }
    }

    private boolean canDisplay(Font font, String string) {
        try {
            Class<?> clazz = font.getClass();
            Class[] classArray = new Class[]{string.getClass()};
            Method method = clazz.getMethod("canDisplayUpTo", classArray);
            Object[] objectArray = new Object[]{string};
            Object object = method.invoke((Object)font, objectArray);
            int n = (Integer)object;
            if (n == -1) {
                return true;
            }
            if (n == string.length()) {
                return true;
            }
            for (int i = n; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c <= '\u00ff') continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            if (Debug.trace && !this.messageShown) {
                Debug.p((String)"canDisplay Exception in String introspection test, One warning only, continuing...  ");
                this.messageShown = true;
            }
            return true;
        }
    }

    private void addToLocalFamilyCache(Font font) {
        String string = font.getFamily();
        for (int i = 0; i < this.localCache.length; ++i) {
            if (this.localCache[i] != null) {
                if (!string.equals(this.localCache[i].getFamily())) continue;
                return;
            }
            this.localCache[i] = font;
            return;
        }
        ++this.localCacheResets;
        this.localCache = new Font[this.LOCAL_FONT_CACHE_SIZE];
        this.localCache[0] = font;
    }

    float getScreenResolution() {
        return this.DPI;
    }

    public String getDefaultFontFamily() {
        return defaultFontFamily;
    }

    String getSupportedFontFamily(String string) {
        if (string.equals("")) {
            return defaultFontFamily;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith("\"") || string2.startsWith("'")) {
                string2 = string2.substring(1, string2.length());
            }
            if (string2.endsWith("\"") || string2.endsWith("'")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!this.fontFamilySupported(string2 = string2.trim())) continue;
            return string2;
        }
        return defaultFontFamily;
    }

    private boolean fontFamilySupported(String string) {
        for (int i = 0; i < this.fontProviders.length; ++i) {
            if (!this.fontProviders[i].isFamilySupported(string)) continue;
            return true;
        }
        return false;
    }

    FontMetrics getFontMetrics(String string, int n, int n2) {
        FontMetrics fontMetrics = null;
        String string2 = this.getKey(string, n, n2);
        fontMetrics = (FontMetrics)this.fontMetricsCache.get(string2);
        if (fontMetrics == null) {
            ++this.cacheFetches;
            this.loadNewFont(string, n, n2);
            fontMetrics = (FontMetrics)this.fontMetricsCache.get(string2);
            ++this.fontCreations;
        } else {
            ++this.cacheFetches;
        }
        return fontMetrics;
    }

    private Font loadNewFont(String string, int n, int n2) {
        Font font = null;
        FontMetrics fontMetrics = null;
        for (int i = 0; i < this.fontProviders.length; ++i) {
            if (!this.fontProviders[i].isFamilySupported(string) || (font = this.fontProviders[i].getFont(string, n, n2)) == null) continue;
            fontMetrics = this.fontProviders[i].getFontMetrics(font);
            if (this.traceFonts) {
                this.traceFontMetrics(fontMetrics);
            }
            this.addToFontMetricsCache(string, n, n2, fontMetrics);
            return font;
        }
        return this.fallbackFont;
    }

    private void addToFontMetricsCache(String string, int n, int n2, FontMetrics fontMetrics) {
        String string2 = this.getKey(string, n, n2);
        this.fontMetricsCache.put(string2, fontMetrics);
    }

    public void clear() {
        this.fontMetricsCache.clear();
    }

    void setBaseFontFamily(String string) {
        defaultFontFamily = new String(string);
        this.loadDefault();
    }

    void setBaseFontSize(int n) {
        baseFontSize = n;
        this.loadDefault();
    }

    void setMinFontSize(int n) {
        minFontSize = n;
        this.loadDefault();
    }

    private void loadDefault() {
        this.fallbackFont = new Font(defaultFontFamily, 0, baseFontSize);
    }

    int getFontSizeAbs(int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n > 7) {
            n = 7;
        }
        n = baseFontSize * this.fontMuls[n] >> 8;
        if (n2 != 256 && (n = n * n2 >> 8) < minFontSize) {
            n = minFontSize;
        }
        return n;
    }

    int getFontSizeRel(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        if (n < 0) {
            while (n < 0) {
                n2 = n2 * 256 / 307;
                ++n;
            }
        } else if (n > 0) {
            while (n > 0) {
                n2 = n2 * 307 >> 8;
                --n;
            }
        }
        if (n2 < minFontSize) {
            n2 = minFontSize;
        }
        return n2;
    }

    private String getKey(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(CharKit.toLowerCase((String)string)).append("_").append(n).append("_").append(n2);
        return stringBuffer.toString();
    }
}

